/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ExtentAD;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.util.ArrayList;
import java.util.List;

public class UnallocatedSpaceDescriptor
extends UDFDescriptor {
    public Long volumeDescriptorSequenceNumber;
    public Long numberofAllocationDescriptors;
    public List<ExtentAD> allocationDescriptors;
    public final int MINIMUM_LENGTH = 512;

    public UnallocatedSpaceDescriptor() {
    }

    public UnallocatedSpaceDescriptor(byte[] byArray) throws InvalidDescriptor {
        super(byArray);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 7;
    }

    @Override
    public void deserialize(byte[] byArray) throws InvalidDescriptor {
        if (byArray.length < 512) {
            throw new InvalidDescriptor("unallocated space descriptor too short");
        }
        this.deserializeTag(byArray);
        this.volumeDescriptorSequenceNumber = this.getUInt32(byArray);
        this.numberofAllocationDescriptors = this.getUInt32(byArray);
        this.allocationDescriptors = new ArrayList<ExtentAD>();
        for (int i = this.numberofAllocationDescriptors.intValue(); i > 0; --i) {
            ExtentAD extentAD = new ExtentAD(this.getBytes(byArray, 8));
            if (extentAD.length <= 0L) continue;
            this.allocationDescriptors.add(extentAD);
        }
    }
}

