/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.iso9660;

import com.github.stephenc.javaisotools.loopfs.api.LoopFileSystemException;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileEntry;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileSystem;
import com.github.stephenc.javaisotools.loopfs.iso9660.Util;
import com.github.stephenc.javaisotools.loopfs.spi.VolumeDescriptorSet;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Iso9660VolumeDescriptorSet
implements VolumeDescriptorSet<Iso9660FileEntry> {
    public static final int TYPE_BOOTRECORD = 0;
    public static final int TYPE_PRIMARY_DESCRIPTOR = 1;
    public static final int TYPE_SUPPLEMENTARY_DESCRIPTOR = 2;
    public static final int TYPE_PARTITION_DESCRIPTOR = 3;
    public static final int TYPE_TERMINATOR = 255;
    private static final Log log = LogFactory.getLog(Iso9660VolumeDescriptorSet.class);
    private final Iso9660FileSystem isoFile;
    private String systemIdentifier;
    private String volumeSetIdentifier;
    private String volumeIdentifier;
    private String publisher;
    private String preparer;
    private String application;
    private Iso9660FileEntry rootDirectoryEntry;
    private Iso9660FileEntry supRootDirectoryEntry;
    private String standardIdentifier;
    private long totalBlocks;
    private int volumeSetSize;
    private int volumeSequenceNumber;
    private long creationTime;
    private long mostRecentModificationTime;
    private long expirationTime;
    private long effectiveTime;
    private long pathTableSize;
    private long locationOfLittleEndianPathTable;
    private long locationOfOptionalLittleEndianPathTable;
    private long locationOfBigEndianPathTable;
    private long locationOfOptionalBigEndianPathTable;
    public String encoding = "US-ASCII";
    public String escapeSequences;
    private boolean hasPrimary = false;
    private boolean hasSupplementary = false;

    public Iso9660VolumeDescriptorSet(Iso9660FileSystem iso9660FileSystem) {
        this.isoFile = iso9660FileSystem;
    }

    public boolean deserialize(byte[] byArray) throws IOException {
        int n = Util.getUInt8(byArray, 1);
        boolean bl = false;
        switch (n) {
            case 255: {
                if (!this.hasPrimary) {
                    throw new LoopFileSystemException("No primary volume descriptor found");
                }
                bl = true;
                break;
            }
            case 0: {
                log.debug((Object)"Found boot record");
                break;
            }
            case 1: {
                log.debug((Object)"Found primary descriptor");
                this.deserializePrimary(byArray);
                break;
            }
            case 2: {
                log.debug((Object)"Found supplementatory descriptor");
                this.deserializeSupplementary(byArray);
                break;
            }
            case 3: {
                log.debug((Object)"Found partition descriptor");
                break;
            }
            default: {
                log.debug((Object)("Found unknown descriptor with type " + n));
            }
        }
        return bl;
    }

    private void deserializePrimary(byte[] byArray) throws IOException {
        if (this.hasPrimary) {
            return;
        }
        this.validateBlockSize(byArray);
        if (!this.hasSupplementary) {
            this.deserializeCommon(byArray);
        }
        this.standardIdentifier = Util.getDChars(byArray, 2, 5);
        this.volumeSetSize = Util.getUInt16Both(byArray, 121);
        this.volumeSequenceNumber = Util.getUInt16Both(byArray, 125);
        this.totalBlocks = Util.getUInt32Both(byArray, 81);
        this.publisher = Util.getDChars(byArray, 319, 128);
        this.preparer = Util.getDChars(byArray, 447, 128);
        this.application = Util.getDChars(byArray, 575, 128);
        this.creationTime = Util.getStringDate(byArray, 814);
        this.mostRecentModificationTime = Util.getStringDate(byArray, 831);
        this.expirationTime = Util.getStringDate(byArray, 848);
        this.effectiveTime = Util.getStringDate(byArray, 865);
        this.pathTableSize = Util.getUInt32Both(byArray, 133);
        this.locationOfLittleEndianPathTable = Util.getUInt32LE(byArray, 141);
        this.locationOfOptionalLittleEndianPathTable = Util.getUInt32LE(byArray, 145);
        this.locationOfBigEndianPathTable = Util.getUInt32BE(byArray, 149);
        this.locationOfOptionalBigEndianPathTable = Util.getUInt32BE(byArray, 153);
        this.hasPrimary = true;
    }

    private void deserializeSupplementary(byte[] byArray) throws IOException {
        if (this.hasSupplementary) {
            return;
        }
        this.validateBlockSize(byArray);
        String string = Util.getDChars(byArray, 89, 32);
        String string2 = this.getEncoding(string);
        if (null != string2) {
            this.encoding = string2;
            this.escapeSequences = string;
            this.deserializeCommon(byArray);
            this.hasSupplementary = true;
        } else {
            log.warn((Object)("Unsupported encoding, escapeSequences: '" + this.escapeSequences + "'"));
        }
    }

    private void deserializeCommon(byte[] byArray) throws IOException {
        this.systemIdentifier = Util.getAChars(byArray, 9, 32, this.encoding);
        this.volumeIdentifier = Util.getDChars(byArray, 41, 32, this.encoding);
        this.volumeSetIdentifier = Util.getDChars(byArray, 191, 128, this.encoding);
        if (this.rootDirectoryEntry == null) {
            Iso9660FileEntry iso9660FileEntry = new Iso9660FileEntry(this.isoFile, null, byArray, 157, false);
            long l = iso9660FileEntry.getStartBlock();
            byte[] byArray2 = new byte[2048];
            this.isoFile.readBlock(l, byArray2);
            this.rootDirectoryEntry = new Iso9660FileEntry(this.isoFile, null, byArray2, 1);
        } else {
            this.supRootDirectoryEntry = new Iso9660FileEntry(this.isoFile, null, byArray, 157, true);
        }
    }

    private void validateBlockSize(byte[] byArray) throws IOException {
        int n = Util.getUInt16Both(byArray, 129);
        if (n != 2048) {
            throw new LoopFileSystemException("Invalid block size: " + n);
        }
    }

    private String getEncoding(String string) {
        String string2 = null;
        if (string.equals("%/@")) {
            string2 = "UTF-16BE";
        } else if (string.equals("%/C")) {
            string2 = "UTF-16BE";
        } else if (string.equals("%/E")) {
            string2 = "UTF-16BE";
        }
        return string2;
    }

    public boolean hasSupplementary() {
        return this.hasSupplementary;
    }

    public String getSystemIdentifier() {
        return this.systemIdentifier;
    }

    public String getVolumeSetIdentifier() {
        return this.volumeSetIdentifier;
    }

    public String getVolumeIdentifier() {
        return this.volumeIdentifier;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public String getPreparer() {
        return this.preparer;
    }

    public String getApplication() {
        return this.application;
    }

    public Iso9660FileEntry getRootEntry() {
        if (this.hasSupplementary()) {
            return this.supRootDirectoryEntry;
        }
        return this.rootDirectoryEntry;
    }

    public Iso9660FileEntry getPrimaryRootEntry() {
        return this.rootDirectoryEntry;
    }

    public Iso9660FileEntry getSupRootEntry() {
        return this.supRootDirectoryEntry;
    }

    public String getStandardIdentifier() {
        return this.standardIdentifier;
    }

    public long getTotalBlocks() {
        return this.totalBlocks;
    }

    public int getVolumeSetSize() {
        return this.volumeSetSize;
    }

    public int getVolumeSequenceNumber() {
        return this.volumeSequenceNumber;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastModifiedTime() {
        return this.mostRecentModificationTime;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public long getEffectiveTime() {
        return this.effectiveTime;
    }

    public long getPathTableSize() {
        return this.pathTableSize;
    }

    public long getLocationOfLittleEndianPathTable() {
        return this.locationOfLittleEndianPathTable;
    }

    public long getLocationOfOptionalLittleEndianPathTable() {
        return this.locationOfOptionalLittleEndianPathTable;
    }

    public long getLocationOfBigEndianPathTable() {
        return this.locationOfBigEndianPathTable;
    }

    public long getLocationOfOptionalBigEndianPathTable() {
        return this.locationOfOptionalBigEndianPathTable;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getEscapeSequences() {
        return this.escapeSequences;
    }
}

