/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.observablecollections.ObservableCollections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.DateField;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TrailerQuality;
import org.tinymediamanager.core.TrailerSources;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.connector.MovieConnectors;
import org.tinymediamanager.core.movie.connector.MovieSetConnectors;
import org.tinymediamanager.core.movie.filenaming.MovieBannerNaming;
import org.tinymediamanager.core.movie.filenaming.MovieClearartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieClearlogoNaming;
import org.tinymediamanager.core.movie.filenaming.MovieDiscartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieExtraFanartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieFanartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieKeyartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieNfoNaming;
import org.tinymediamanager.core.movie.filenaming.MoviePosterNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetBannerNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetClearartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetClearlogoNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetDiscartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetFanartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetNfoNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetPosterNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetThumbNaming;
import org.tinymediamanager.core.movie.filenaming.MovieThumbNaming;
import org.tinymediamanager.core.movie.filenaming.MovieTrailerNaming;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.rating.RatingProvider;

public final class MovieSettings
extends AbstractSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSettings.class);
    private static final String CONFIG_FILE = "movies.json";
    public static final String DEFAULT_RENAMER_FOLDER_PATTERN = "${title}${ - ,edition,} (${year})";
    public static final String DEFAULT_RENAMER_FILE_PATTERN = "${title}${ - ,edition,} (${year}) ${videoFormat} ${audioCodec}";
    private static MovieSettings instance;
    public static final String MOVIE_UI_FILTER_PRESETS = "movieUiFilterPresets";
    public static final String MOVIE_SET_UI_FILTER_PRESETS = "movieSetUiFilterPresets";
    static final String MOVIE_DATA_SOURCE = "movieDataSource";
    static final String NFO_FILENAME = "nfoFilename";
    static final String POSTER_FILENAME = "posterFilename";
    static final String FANART_FILENAME = "fanartFilename";
    static final String EXTRAFANART_FILENAME = "extraFanartFilename";
    static final String BANNER_FILENAME = "bannerFilename";
    static final String CLEARART_FILENAME = "clearartFilename";
    static final String THUMB_FILENAME = "thumbFilename";
    static final String CLEARLOGO_FILENAME = "clearlogoFilename";
    static final String DISCART_FILENAME = "discartFilename";
    static final String KEYART_FILENAME = "keyartFilename";
    static final String MOVIE_SET_POSTER_FILENAME = "movieSetPosterFilename";
    static final String MOVIE_SET_FANART_FILENAME = "movieSetFanartFilename";
    static final String MOVIE_SET_BANNER_FILENAME = "movieSetBannerFilename";
    static final String MOVIE_SET_CLEARART_FILENAME = "movieSetClearartFilename";
    static final String MOVIE_SET_THUMB_FILENAME = "movieSetThumbFilename";
    static final String MOVIE_SET_CLEARLOGO_FILENAME = "movieSetClearlogoFilename";
    static final String MOVIE_SET_DISCART_FILENAME = "movieSetDiscartFilename";
    static final String TRAILER_FILENAME = "trailerFilename";
    static final String ARTWORK_SCRAPERS = "artworkScrapers";
    static final String TRAILER_SCRAPERS = "trailerScrapers";
    static final String SUBTITLE_SCRAPERS = "subtitleScrapers";
    static final String BAD_WORD = "badWord";
    static final String SKIP_FOLDER = "skipFolder";
    static final String MOVIE_CHECK_METADATA = "movieCheckMetadata";
    static final String MOVIE_CHECK_ARTWORK = "movieCheckArtwork";
    static final String MOVIESET_CHECK_METADATA = "movieSetCheckMetadata";
    static final String MOVIESET_CHECK_ARTWORK = "movieSetCheckArtwork";
    static final String POST_PROCESS = "postProcess";
    static final String MOVIE_SET_POST_PROCESS = "movieSetPostProcess";
    final List<String> movieDataSources = ObservableCollections.observableList(new ArrayList());
    final List<MovieNfoNaming> nfoFilenames = new ArrayList<MovieNfoNaming>();
    final List<MoviePosterNaming> posterFilenames = new ArrayList<MoviePosterNaming>();
    final List<MovieFanartNaming> fanartFilenames = new ArrayList<MovieFanartNaming>();
    final List<MovieExtraFanartNaming> extraFanartFilenames = new ArrayList<MovieExtraFanartNaming>();
    final List<MovieBannerNaming> bannerFilenames = new ArrayList<MovieBannerNaming>();
    final List<MovieClearartNaming> clearartFilenames = new ArrayList<MovieClearartNaming>();
    final List<MovieThumbNaming> thumbFilenames = new ArrayList<MovieThumbNaming>();
    final List<MovieClearlogoNaming> clearlogoFilenames = new ArrayList<MovieClearlogoNaming>();
    final List<MovieDiscartNaming> discartFilenames = new ArrayList<MovieDiscartNaming>();
    final List<MovieKeyartNaming> keyartFilenames = new ArrayList<MovieKeyartNaming>();
    final List<MovieTrailerNaming> trailerFilenames = new ArrayList<MovieTrailerNaming>();
    final List<String> badWords = ObservableCollections.observableList(new ArrayList());
    final List<String> artworkScrapers = ObservableCollections.observableList(new ArrayList());
    final List<String> trailerScrapers = ObservableCollections.observableList(new ArrayList());
    final List<String> subtitleScrapers = ObservableCollections.observableList(new ArrayList());
    final List<String> skipFolders = ObservableCollections.observableList(new ArrayList());
    int version;
    boolean skipFoldersWithNomedia = true;
    boolean buildImageCacheOnImport = true;
    MovieConnectors movieConnector = MovieConnectors.KODI;
    CertificationStyle certificationStyle = CertificationStyle.LARGE;
    boolean nfoDiscFolderInside = true;
    boolean trailerDiscFolderInside = true;
    boolean writeCleanNfo = false;
    boolean nfoWriteDateAdded = true;
    DateField nfoDateAddedField = DateField.DATE_ADDED;
    Locale nfoLanguage = Locale.ENGLISH;
    boolean createOutline = true;
    boolean outlineFirstSentence = false;
    boolean nfoWriteSingleStudio = false;
    boolean nfoWriteLockdata = false;
    boolean nfoWriteTrailer = true;
    boolean nfoWriteFileinfo = true;
    boolean nfoWriteArtworkUrls = true;
    boolean renameAfterScrape = false;
    boolean updateOnStart = false;
    String renamerPathname = "${title}${ - ,edition,} (${year})";
    String renamerFilename = "${title}${ - ,edition,} (${year}) ${videoFormat} ${audioCodec}";
    boolean renamerPathnameSpaceSubstitution = false;
    String renamerPathnameSpaceReplacement = "_";
    boolean renamerFilenameSpaceSubstitution = false;
    String renamerFilenameSpaceReplacement = "_";
    String renamerColonReplacement = "-";
    boolean renamerNfoCleanup = false;
    boolean renamerCleanupUnwanted = false;
    boolean renamerCreateMoviesetForSingleMovie = false;
    String renamerFirstCharacterNumberReplacement = "#";
    boolean asciiReplacement = false;
    boolean unicodeReplacement = false;
    boolean allowMultipleMoviesInSameDir = false;
    String movieScraper = "tmdb";
    MediaLanguages scraperLanguage = MediaLanguages.en;
    CountryCode certificationCountry = CountryCode.US;
    String releaseDateCountry = "";
    double scraperThreshold = 0.75;
    boolean scraperFallback = false;
    final List<MovieScraperMetadataConfig> scraperMetadataConfig = new ArrayList<MovieScraperMetadataConfig>();
    boolean doNotOverwriteExistingData = false;
    boolean capitalWordsInTitles = false;
    boolean fetchAllRatings = true;
    final List<RatingProvider.RatingSource> fetchRatingSources = new ArrayList<RatingProvider.RatingSource>();
    MediaArtwork.PosterSizes imagePosterSize = MediaArtwork.PosterSizes.LARGE;
    MediaArtwork.FanartSizes imageFanartSize = MediaArtwork.FanartSizes.LARGE;
    boolean imageExtraThumbs = false;
    boolean imageExtraThumbsResize = true;
    int imageExtraThumbsSize = 300;
    int imageExtraThumbsCount = 5;
    boolean imageExtraFanart = false;
    int imageExtraFanartCount = 5;
    boolean scrapeBestImage = true;
    final List<MediaLanguages> imageScraperLanguages = ObservableCollections.observableList(new ArrayList());
    boolean imageScraperOtherResolutions = true;
    boolean imageScraperFallback = true;
    boolean imageScraperPreferFanartWoText = true;
    boolean writeActorImages = false;
    boolean useYtDlp = true;
    boolean useTrailerPreference = true;
    boolean automaticTrailerDownload = false;
    TrailerQuality trailerQuality = TrailerQuality.HD_720;
    TrailerSources trailerSource = TrailerSources.YOUTUBE;
    MediaLanguages subtitleScraperLanguage = MediaLanguages.en;
    LanguageStyle subtitleLanguageStyle = LanguageStyle.ISO3T;
    boolean subtitleWithoutLanguageTag = false;
    boolean subtitleForceBestMatch = false;
    boolean runtimeFromMediaInfo = false;
    boolean includeExternalAudioStreams = false;
    boolean syncTrakt = false;
    boolean syncTraktCollection = true;
    boolean syncTraktWatched = true;
    boolean syncTraktRating = true;
    boolean extractArtworkFromVsmeta = false;
    boolean useMediainfoMetadata = false;
    boolean title = true;
    boolean sortableTitle = false;
    boolean originalTitle = true;
    boolean sortableOriginalTitle = false;
    boolean sortTitle = false;
    boolean englishTitle = true;
    final List<PostProcess> postProcess = ObservableCollections.observableList(new ArrayList());
    final List<PostProcess> movieSetPostProcess = ObservableCollections.observableList(new ArrayList());
    final List<MediaFileType> showArtworkTypes = ObservableCollections.observableList(new ArrayList());
    boolean showMovieTableTooltips = true;
    final List<String> ratingSources = ObservableCollections.observableList(new ArrayList());
    final List<MovieScraperMetadataConfig> movieCheckMetadata = new ArrayList<MovieScraperMetadataConfig>();
    boolean movieDisplayAllMissingMetadata = false;
    final List<MovieScraperMetadataConfig> movieCheckArtwork = new ArrayList<MovieScraperMetadataConfig>();
    boolean movieDisplayAllMissingArtwork = false;
    final List<MovieSetScraperMetadataConfig> movieSetCheckMetadata = new ArrayList<MovieSetScraperMetadataConfig>();
    boolean movieSetDisplayAllMissingMetadata = false;
    final List<MovieSetScraperMetadataConfig> movieSetCheckArtwork = new ArrayList<MovieSetScraperMetadataConfig>();
    boolean movieSetDisplayAllMissingArtwork = false;
    boolean storeUiFilters = false;
    final List<AbstractSettings.UIFilters> uiFilters = new ArrayList<AbstractSettings.UIFilters>();
    final List<AbstractSettings.UniversalFilterFields> universalFilterFields = new ArrayList<AbstractSettings.UniversalFilterFields>();
    boolean resetNewFlagOnUds = true;
    MovieSetConnectors movieSetConnector = MovieSetConnectors.EMBY;
    final List<MovieSetNfoNaming> movieSetNfoFilenames = new ArrayList<MovieSetNfoNaming>();
    @JsonAlias(value={"movieSetArtworkFolder"})
    String movieSetDataFolder = "";
    boolean scrapeBestImageMovieSet = true;
    String movieSetTitleCharacterReplacement = "_";
    boolean movieSetAppendTmdbId = false;
    final List<MovieSetPosterNaming> movieSetPosterFilenames = new ArrayList<MovieSetPosterNaming>();
    final List<MovieSetFanartNaming> movieSetFanartFilenames = new ArrayList<MovieSetFanartNaming>();
    boolean showMovieSetTableTooltips = true;
    final List<MovieSetBannerNaming> movieSetBannerFilenames = new ArrayList<MovieSetBannerNaming>();
    boolean displayMovieSetMissingMovies = false;
    final List<MovieSetClearartNaming> movieSetClearartFilenames = new ArrayList<MovieSetClearartNaming>();
    final List<MovieSetThumbNaming> movieSetThumbFilenames = new ArrayList<MovieSetThumbNaming>();
    boolean storeMovieSetUiFilters = false;
    final List<MovieSetClearlogoNaming> movieSetClearlogoFilenames = new ArrayList<MovieSetClearlogoNaming>();
    final List<AbstractSettings.UIFilters> movieSetUiFilters = new ArrayList<AbstractSettings.UIFilters>();
    final Map<String, List<AbstractSettings.UIFilters>> movieUiFilterPresets = new HashMap<String, List<AbstractSettings.UIFilters>>();
    final List<MovieSetDiscartNaming> movieSetDiscartFilenames = new ArrayList<MovieSetDiscartNaming>();
    final Map<String, List<AbstractSettings.UIFilters>> movieSetUiFilterPresets = new HashMap<String, List<AbstractSettings.UIFilters>>();

    public MovieSettings() {
        this.addDefaultEntries();
        this.addPropertyChangeListener(evt -> this.setDirty());
    }

    private void addDefaultEntries() {
        this.skipFolders.clear();
        this.addSkipFolder("MAKEMKV");
        this.nfoFilenames.clear();
        this.addNfoFilename(MovieNfoNaming.FILENAME_NFO);
        this.posterFilenames.clear();
        this.addPosterFilename(MoviePosterNaming.FILENAME_POSTER);
        this.fanartFilenames.clear();
        this.addFanartFilename(MovieFanartNaming.FILENAME_FANART);
        this.extraFanartFilenames.clear();
        this.addExtraFanartFilename(MovieExtraFanartNaming.FILENAME_EXTRAFANART);
        this.bannerFilenames.clear();
        this.addBannerFilename(MovieBannerNaming.FILENAME_BANNER);
        this.clearartFilenames.clear();
        this.addClearartFilename(MovieClearartNaming.FILENAME_CLEARART);
        this.thumbFilenames.clear();
        this.addThumbFilename(MovieThumbNaming.FILENAME_LANDSCAPE);
        this.clearlogoFilenames.clear();
        this.addClearlogoFilename(MovieClearlogoNaming.FILENAME_CLEARLOGO);
        this.discartFilenames.clear();
        this.addDiscartFilename(MovieDiscartNaming.FILENAME_DISCART);
        this.keyartFilenames.clear();
        this.addKeyartFilename(MovieKeyartNaming.FILENAME_KEYART);
        this.movieSetNfoFilenames.clear();
        this.addMovieSetNfoFilename(MovieSetNfoNaming.KODI_NFO);
        this.movieSetPosterFilenames.clear();
        this.addMovieSetPosterFilename(MovieSetPosterNaming.KODI_POSTER);
        this.movieSetFanartFilenames.clear();
        this.addMovieSetFanartFilename(MovieSetFanartNaming.KODI_FANART);
        this.movieSetBannerFilenames.clear();
        this.addMovieSetBannerFilename(MovieSetBannerNaming.KODI_BANNER);
        this.movieSetClearartFilenames.clear();
        this.addMovieSetClearartFilename(MovieSetClearartNaming.KODI_CLEARART);
        this.movieSetThumbFilenames.clear();
        this.addMovieSetThumbFilename(MovieSetThumbNaming.KODI_LANDSCAPE);
        this.movieSetClearlogoFilenames.clear();
        this.addMovieSetClearlogoFilename(MovieSetClearlogoNaming.KODI_CLEARLOGO);
        this.movieSetDiscartFilenames.clear();
        this.addMovieSetDiscartFilename(MovieSetDiscartNaming.KODI_DISCART);
        this.trailerFilenames.clear();
        this.addTrailerFilename(MovieTrailerNaming.FILENAME_TRAILER);
        this.setMovieConnector(MovieConnectors.KODI);
        this.setRenamerPathname(DEFAULT_RENAMER_FOLDER_PATTERN);
        this.setRenamerFilename(DEFAULT_RENAMER_FILE_PATTERN);
        this.setCertificationStyle(CertificationStyle.LARGE);
        this.showArtworkTypes.clear();
        this.addShowArtworkTypes(MediaFileType.POSTER);
        this.addShowArtworkTypes(MediaFileType.FANART);
        this.addShowArtworkTypes(MediaFileType.THUMB);
        this.movieCheckMetadata.clear();
        this.addMovieCheckMetadata(MovieScraperMetadataConfig.ID);
        this.addMovieCheckMetadata(MovieScraperMetadataConfig.TITLE);
        this.addMovieCheckMetadata(MovieScraperMetadataConfig.YEAR);
        this.addMovieCheckMetadata(MovieScraperMetadataConfig.PLOT);
        this.addMovieCheckMetadata(MovieScraperMetadataConfig.RATING);
        this.addMovieCheckMetadata(MovieScraperMetadataConfig.RUNTIME);
        this.addMovieCheckMetadata(MovieScraperMetadataConfig.CERTIFICATION);
        this.addMovieCheckMetadata(MovieScraperMetadataConfig.GENRES);
        this.addMovieCheckMetadata(MovieScraperMetadataConfig.ACTORS);
        this.movieCheckArtwork.clear();
        this.addMovieCheckArtwork(MovieScraperMetadataConfig.POSTER);
        this.addMovieCheckArtwork(MovieScraperMetadataConfig.FANART);
        this.ratingSources.clear();
        this.addRatingSource("imdb");
        this.imageScraperLanguages.clear();
        this.addImageScraperLanguage(MediaLanguages.en);
        this.movieSetCheckMetadata.clear();
        this.addMovieSetCheckMetadata(MovieSetScraperMetadataConfig.ID);
        this.addMovieSetCheckMetadata(MovieSetScraperMetadataConfig.TITLE);
        this.addMovieSetCheckMetadata(MovieSetScraperMetadataConfig.PLOT);
        this.movieSetCheckArtwork.clear();
        this.addMovieSetCheckArtwork(MovieSetScraperMetadataConfig.POSTER);
        this.addMovieSetCheckArtwork(MovieSetScraperMetadataConfig.FANART);
        this.universalFilterFields.addAll(Arrays.asList(AbstractSettings.UniversalFilterFields.values()));
        this.scraperMetadataConfig.addAll(Arrays.asList(MovieScraperMetadataConfig.values()));
        this.fetchRatingSources.add(RatingProvider.RatingSource.IMDB);
    }

    @Override
    protected ObjectWriter createObjectWriter() {
        return objectMapper.writerFor(MovieSettings.class);
    }

    static synchronized MovieSettings getInstance() {
        return MovieSettings.getInstance(Settings.getInstance().getSettingsFolder());
    }

    static synchronized MovieSettings getInstance(String folder) {
        if (instance == null) {
            instance = (MovieSettings)MovieSettings.getInstance(folder, CONFIG_FILE, MovieSettings.class);
        }
        return instance;
    }

    static void clearInstance() {
        instance = null;
    }

    @Override
    public String getConfigFilename() {
        return CONFIG_FILE;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected void afterLoading() {
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
        this.setDirty();
    }

    @Override
    protected void writeDefaultSettings() {
        this.addDefaultEntries();
        String defaultLang = Locale.getDefault().getLanguage();
        CountryCode cc = CountryCode.getByCode(defaultLang.toUpperCase(Locale.ROOT));
        if (cc != null) {
            this.setCertificationCountry(cc);
            this.setReleaseDateCountry(cc.getAlpha2());
        }
        for (MediaLanguages ml : MediaLanguages.values()) {
            if (!ml.name().equals(defaultLang)) continue;
            this.setScraperLanguage(ml);
            this.setNfoLanguage(ml.toLocale());
            this.imageScraperLanguages.clear();
            this.addImageScraperLanguage(ml);
            this.setSubtitleScraperLanguage(ml);
        }
        this.saveSettings();
    }

    public void setMovieDataSources(Collection<String> dataSources) {
        this.movieDataSources.clear();
        this.movieDataSources.addAll(dataSources);
        this.firePropertyChange(MOVIE_DATA_SOURCE, null, this.movieDataSources);
        this.firePropertyChange("dataSource", null, this.movieDataSources);
    }

    public void addMovieDataSources(String path) {
        if (!this.movieDataSources.contains(path)) {
            this.movieDataSources.add(path);
            this.firePropertyChange(MOVIE_DATA_SOURCE, null, this.movieDataSources);
            this.firePropertyChange("dataSource", null, this.movieDataSources);
        }
    }

    public void removeMovieDataSources(String path) {
        MovieList movieList = MovieModuleManager.getInstance().getMovieList();
        movieList.removeDatasource(path);
        this.movieDataSources.remove(path);
        this.firePropertyChange(MOVIE_DATA_SOURCE, null, this.movieDataSources);
        this.firePropertyChange("dataSource", null, this.movieDataSources);
    }

    public void exchangeMovieDatasource(String oldDatasource, String newDatasource) {
        int index = this.movieDataSources.indexOf(oldDatasource);
        if (index > -1) {
            this.movieDataSources.remove(oldDatasource);
            if (!this.movieDataSources.contains(newDatasource)) {
                this.movieDataSources.add(index, newDatasource);
            }
            MovieModuleManager.getInstance().getMovieList().exchangeDatasource(oldDatasource, newDatasource);
        }
        this.firePropertyChange(MOVIE_DATA_SOURCE, null, this.movieDataSources);
        this.firePropertyChange("dataSource", null, this.movieDataSources);
    }

    public List<String> getMovieDataSource() {
        return this.movieDataSources;
    }

    public void swapMovieDataSource(int pos1, int pos2) {
        String tmp = this.movieDataSources.get(pos1);
        this.movieDataSources.set(pos1, this.movieDataSources.get(pos2));
        this.movieDataSources.set(pos2, tmp);
        this.firePropertyChange(MOVIE_DATA_SOURCE, null, this.movieDataSources);
        this.firePropertyChange("dataSource", null, this.movieDataSources);
    }

    public void addNfoFilename(MovieNfoNaming filename) {
        if (!this.nfoFilenames.contains((Object)filename)) {
            this.nfoFilenames.add(filename);
            this.firePropertyChange(NFO_FILENAME, null, this.nfoFilenames);
        }
    }

    public void clearNfoFilenames() {
        this.nfoFilenames.clear();
        this.firePropertyChange(NFO_FILENAME, null, this.nfoFilenames);
    }

    public List<MovieNfoNaming> getNfoFilenames() {
        return new ArrayList<MovieNfoNaming>(this.nfoFilenames);
    }

    public void addTrailerFilename(MovieTrailerNaming filename) {
        if (!this.trailerFilenames.contains(filename)) {
            this.trailerFilenames.add(filename);
            this.firePropertyChange(TRAILER_FILENAME, null, this.trailerFilenames);
        }
    }

    public void clearTrailerFilenames() {
        this.trailerFilenames.clear();
        this.firePropertyChange(TRAILER_FILENAME, null, this.trailerFilenames);
    }

    public List<MovieTrailerNaming> getTrailerFilenames() {
        return new ArrayList<MovieTrailerNaming>(this.trailerFilenames);
    }

    public void addPosterFilename(MoviePosterNaming filename) {
        if (!this.posterFilenames.contains(filename)) {
            this.posterFilenames.add(filename);
            this.firePropertyChange(POSTER_FILENAME, null, this.posterFilenames);
        }
    }

    public void clearPosterFilenames() {
        this.posterFilenames.clear();
        this.firePropertyChange(POSTER_FILENAME, null, this.posterFilenames);
    }

    public List<MoviePosterNaming> getPosterFilenames() {
        return new ArrayList<MoviePosterNaming>(this.posterFilenames);
    }

    public void addFanartFilename(MovieFanartNaming filename) {
        if (!this.fanartFilenames.contains(filename)) {
            this.fanartFilenames.add(filename);
            this.firePropertyChange(FANART_FILENAME, null, this.fanartFilenames);
        }
    }

    public void clearFanartFilenames() {
        this.fanartFilenames.clear();
        this.firePropertyChange(FANART_FILENAME, null, this.fanartFilenames);
    }

    public List<MovieFanartNaming> getFanartFilenames() {
        return new ArrayList<MovieFanartNaming>(this.fanartFilenames);
    }

    public void addExtraFanartFilename(MovieExtraFanartNaming filename) {
        if (!this.extraFanartFilenames.contains(filename)) {
            this.extraFanartFilenames.add(filename);
            this.firePropertyChange(EXTRAFANART_FILENAME, null, this.extraFanartFilenames);
        }
    }

    public void clearExtraFanartFilenames() {
        this.extraFanartFilenames.clear();
        this.firePropertyChange(EXTRAFANART_FILENAME, null, this.extraFanartFilenames);
    }

    public List<MovieExtraFanartNaming> getExtraFanartFilenames() {
        return new ArrayList<MovieExtraFanartNaming>(this.extraFanartFilenames);
    }

    public void addBannerFilename(MovieBannerNaming filename) {
        if (!this.bannerFilenames.contains(filename)) {
            this.bannerFilenames.add(filename);
            this.firePropertyChange(BANNER_FILENAME, null, this.bannerFilenames);
        }
    }

    public void clearBannerFilenames() {
        this.bannerFilenames.clear();
        this.firePropertyChange(BANNER_FILENAME, null, this.bannerFilenames);
    }

    public List<MovieBannerNaming> getBannerFilenames() {
        return new ArrayList<MovieBannerNaming>(this.bannerFilenames);
    }

    public void addClearartFilename(MovieClearartNaming filename) {
        if (!this.clearartFilenames.contains(filename)) {
            this.clearartFilenames.add(filename);
            this.firePropertyChange(CLEARART_FILENAME, null, this.clearartFilenames);
        }
    }

    public void clearClearartFilenames() {
        this.clearartFilenames.clear();
        this.firePropertyChange(CLEARART_FILENAME, null, this.clearartFilenames);
    }

    public List<MovieClearartNaming> getClearartFilenames() {
        return new ArrayList<MovieClearartNaming>(this.clearartFilenames);
    }

    public void addThumbFilename(MovieThumbNaming filename) {
        if (!this.thumbFilenames.contains(filename)) {
            this.thumbFilenames.add(filename);
            this.firePropertyChange(THUMB_FILENAME, null, this.thumbFilenames);
        }
    }

    public void clearThumbFilenames() {
        this.thumbFilenames.clear();
        this.firePropertyChange(THUMB_FILENAME, null, this.thumbFilenames);
    }

    public List<MovieThumbNaming> getThumbFilenames() {
        return new ArrayList<MovieThumbNaming>(this.thumbFilenames);
    }

    public void addClearlogoFilename(MovieClearlogoNaming filename) {
        if (!this.clearlogoFilenames.contains(filename)) {
            this.clearlogoFilenames.add(filename);
            this.firePropertyChange(CLEARLOGO_FILENAME, null, this.clearlogoFilenames);
        }
    }

    public void clearClearlogoFilenames() {
        this.clearlogoFilenames.clear();
        this.firePropertyChange(CLEARLOGO_FILENAME, null, this.clearlogoFilenames);
    }

    public List<MovieClearlogoNaming> getClearlogoFilenames() {
        return new ArrayList<MovieClearlogoNaming>(this.clearlogoFilenames);
    }

    public void addDiscartFilename(MovieDiscartNaming filename) {
        if (!this.discartFilenames.contains(filename)) {
            this.discartFilenames.add(filename);
            this.firePropertyChange(DISCART_FILENAME, null, this.discartFilenames);
        }
    }

    public void clearDiscartFilenames() {
        this.discartFilenames.clear();
        this.firePropertyChange(DISCART_FILENAME, null, this.discartFilenames);
    }

    public List<MovieDiscartNaming> getDiscartFilenames() {
        return new ArrayList<MovieDiscartNaming>(this.discartFilenames);
    }

    public void addShowArtworkTypes(MediaFileType type) {
        if (!this.showArtworkTypes.contains((Object)type)) {
            this.showArtworkTypes.add(type);
            this.firePropertyChange("showArtworkTypes", null, this.showArtworkTypes);
        }
    }

    public void setShowArtworkTypes(List<MediaFileType> newTypes) {
        this.showArtworkTypes.clear();
        this.showArtworkTypes.addAll(newTypes);
        this.firePropertyChange("showArtworkTypes", null, this.showArtworkTypes);
    }

    public List<MediaFileType> getShowArtworkTypes() {
        return new ArrayList<MediaFileType>(this.showArtworkTypes);
    }

    public void clearMovieCheckMetadata() {
        this.movieCheckMetadata.clear();
        this.firePropertyChange(MOVIE_CHECK_METADATA, null, this.movieCheckMetadata);
    }

    public List<MovieScraperMetadataConfig> getMovieCheckMetadata() {
        return new ArrayList<MovieScraperMetadataConfig>(this.movieCheckMetadata);
    }

    public void addMovieCheckMetadata(MovieScraperMetadataConfig config) {
        if (!this.movieCheckMetadata.contains(config)) {
            this.movieCheckMetadata.add(config);
            this.firePropertyChange(MOVIE_CHECK_METADATA, null, this.movieCheckMetadata);
        }
    }

    public void setMovieDisplayAllMissingMetadata(boolean newValue) {
        boolean oldValue = this.movieDisplayAllMissingMetadata;
        this.movieDisplayAllMissingMetadata = newValue;
        this.firePropertyChange("movieDisplayAllMissingMetadata", oldValue, newValue);
    }

    public boolean isMovieDisplayAllMissingMetadata() {
        return this.movieDisplayAllMissingMetadata;
    }

    public void clearMovieCheckArtwork() {
        this.movieCheckArtwork.clear();
        this.firePropertyChange(MOVIE_CHECK_ARTWORK, null, this.movieCheckArtwork);
    }

    public List<MovieScraperMetadataConfig> getMovieCheckArtwork() {
        return new ArrayList<MovieScraperMetadataConfig>(this.movieCheckArtwork);
    }

    public void addMovieCheckArtwork(MovieScraperMetadataConfig config) {
        if (!this.movieCheckArtwork.contains(config)) {
            this.movieCheckArtwork.add(config);
            this.firePropertyChange(MOVIE_CHECK_ARTWORK, null, this.movieCheckArtwork);
        }
    }

    public void removeMovieCheckArtwork(MovieScraperMetadataConfig config) {
        if (this.movieCheckArtwork.remove(config)) {
            this.firePropertyChange(MOVIE_CHECK_ARTWORK, null, this.movieCheckArtwork);
        }
    }

    public void setMovieDisplayAllMissingArtwork(boolean newValue) {
        boolean oldValue = this.movieDisplayAllMissingArtwork;
        this.movieDisplayAllMissingArtwork = newValue;
        this.firePropertyChange("movieDisplayAllMissingArtwork", oldValue, newValue);
    }

    public boolean isMovieDisplayAllMissingArtwork() {
        return this.movieDisplayAllMissingArtwork;
    }

    public void clearMovieSetCheckMetadata() {
        this.movieSetCheckMetadata.clear();
        this.firePropertyChange(MOVIESET_CHECK_METADATA, null, this.movieSetCheckMetadata);
    }

    public List<MovieSetScraperMetadataConfig> getMovieSetCheckMetadata() {
        return new ArrayList<MovieSetScraperMetadataConfig>(this.movieSetCheckMetadata);
    }

    public void addMovieSetCheckMetadata(MovieSetScraperMetadataConfig config) {
        if (!this.movieSetCheckMetadata.contains(config)) {
            this.movieSetCheckMetadata.add(config);
            this.firePropertyChange(MOVIESET_CHECK_METADATA, null, this.movieSetCheckMetadata);
        }
    }

    public void setMovieSetDisplayAllMissingMetadata(boolean newValue) {
        boolean oldValue = this.movieSetDisplayAllMissingMetadata;
        this.movieSetDisplayAllMissingMetadata = newValue;
        this.firePropertyChange("movieSetDisplayAllMissingMetadata", oldValue, newValue);
    }

    public boolean isMovieSetDisplayAllMissingMetadata() {
        return this.movieSetDisplayAllMissingMetadata;
    }

    public void clearMovieSetCheckArtwork() {
        this.movieSetCheckArtwork.clear();
        this.firePropertyChange(MOVIESET_CHECK_ARTWORK, null, this.movieSetCheckArtwork);
    }

    public List<MovieSetScraperMetadataConfig> getMovieSetCheckArtwork() {
        return new ArrayList<MovieSetScraperMetadataConfig>(this.movieSetCheckArtwork);
    }

    public void addMovieSetCheckArtwork(MovieSetScraperMetadataConfig config) {
        if (!this.movieSetCheckArtwork.contains(config)) {
            this.movieSetCheckArtwork.add(config);
            this.firePropertyChange(MOVIESET_CHECK_ARTWORK, null, this.movieSetCheckArtwork);
        }
    }

    public void setMovieSetDisplayAllMissingArtwork(boolean newValue) {
        boolean oldValue = this.movieSetDisplayAllMissingArtwork;
        this.movieSetDisplayAllMissingArtwork = newValue;
        this.firePropertyChange("movieSetDisplayAllMissingArtwork", oldValue, newValue);
    }

    public boolean isMovieSetDisplayAllMissingArtwork() {
        return this.movieSetDisplayAllMissingArtwork;
    }

    public void addKeyartFilename(MovieKeyartNaming filename) {
        if (!this.keyartFilenames.contains(filename)) {
            this.keyartFilenames.add(filename);
            this.firePropertyChange(KEYART_FILENAME, null, this.keyartFilenames);
        }
    }

    public void clearKeyartFilenames() {
        this.keyartFilenames.clear();
        this.firePropertyChange(KEYART_FILENAME, null, this.keyartFilenames);
    }

    public List<MovieKeyartNaming> getKeyartFilenames() {
        return this.keyartFilenames;
    }

    public MediaArtwork.PosterSizes getImagePosterSize() {
        return this.imagePosterSize;
    }

    public void setImagePosterSize(MediaArtwork.PosterSizes newValue) {
        MediaArtwork.PosterSizes oldValue = this.imagePosterSize;
        this.imagePosterSize = newValue;
        this.firePropertyChange("imagePosterSize", (Object)oldValue, (Object)newValue);
    }

    public MediaArtwork.FanartSizes getImageFanartSize() {
        return this.imageFanartSize;
    }

    public void setImageFanartSize(MediaArtwork.FanartSizes newValue) {
        MediaArtwork.FanartSizes oldValue = this.imageFanartSize;
        this.imageFanartSize = newValue;
        this.firePropertyChange("imageFanartSize", (Object)oldValue, (Object)newValue);
    }

    public boolean isImageExtraThumbs() {
        return this.imageExtraThumbs;
    }

    public boolean isImageExtraThumbsResize() {
        return this.imageExtraThumbsResize;
    }

    public int getImageExtraThumbsSize() {
        return this.imageExtraThumbsSize;
    }

    public void setImageExtraThumbsResize(boolean newValue) {
        boolean oldValue = this.imageExtraThumbsResize;
        this.imageExtraThumbsResize = newValue;
        this.firePropertyChange("imageExtraThumbsResize", oldValue, newValue);
    }

    public void setImageExtraThumbsSize(int newValue) {
        int oldValue = this.imageExtraThumbsSize;
        this.imageExtraThumbsSize = newValue;
        this.firePropertyChange("imageExtraThumbsSize", oldValue, newValue);
    }

    public int getImageExtraThumbsCount() {
        return this.imageExtraThumbsCount;
    }

    public void setImageExtraThumbsCount(int newValue) {
        int oldValue = this.imageExtraThumbsCount;
        this.imageExtraThumbsCount = newValue;
        this.firePropertyChange("imageExtraThumbsCount", oldValue, newValue);
    }

    public int getImageExtraFanartCount() {
        return this.imageExtraFanartCount;
    }

    public void setImageExtraFanartCount(int newValue) {
        int oldValue = this.imageExtraFanartCount;
        this.imageExtraFanartCount = newValue;
        this.firePropertyChange("imageExtraFanartCount", oldValue, newValue);
    }

    public boolean isImageExtraFanart() {
        return this.imageExtraFanart;
    }

    public void setImageExtraThumbs(boolean newValue) {
        boolean oldValue = this.imageExtraThumbs;
        this.imageExtraThumbs = newValue;
        this.firePropertyChange("imageExtraThumbs", oldValue, newValue);
    }

    public void setImageExtraFanart(boolean newValue) {
        boolean oldValue = this.imageExtraFanart;
        this.imageExtraFanart = newValue;
        this.firePropertyChange("imageExtraFanart", oldValue, newValue);
    }

    public String getMovieSetDataFolder() {
        return this.movieSetDataFolder;
    }

    public void setMovieSetDataFolder(String newValue) {
        String oldValue = this.movieSetDataFolder;
        this.movieSetDataFolder = newValue;
        this.firePropertyChange("movieSetDataFolder", oldValue, newValue);
    }

    public MovieConnectors getMovieConnector() {
        return this.movieConnector;
    }

    public void setMovieConnector(MovieConnectors newValue) {
        MovieConnectors oldValue = this.movieConnector;
        this.movieConnector = newValue;
        this.firePropertyChange("movieConnector", (Object)oldValue, (Object)newValue);
    }

    public String getRenamerPathname() {
        return this.renamerPathname;
    }

    public void setRenamerPathname(String newValue) {
        String oldValue = this.renamerPathname;
        this.renamerPathname = newValue;
        this.firePropertyChange("renamerPathname", oldValue, newValue);
    }

    public String getRenamerFilename() {
        return this.renamerFilename;
    }

    public void setRenamerFilename(String newValue) {
        String oldValue = this.renamerFilename;
        this.renamerFilename = newValue;
        this.firePropertyChange("renamerFilename", oldValue, newValue);
    }

    public boolean isRenamerPathnameSpaceSubstitution() {
        return this.renamerPathnameSpaceSubstitution;
    }

    public void setRenamerPathnameSpaceSubstitution(boolean newValue) {
        boolean oldValue = this.renamerPathnameSpaceSubstitution;
        this.renamerPathnameSpaceSubstitution = newValue;
        this.firePropertyChange("renamerPathnameSpaceSubstitution", oldValue, newValue);
    }

    public boolean isRenamerFilenameSpaceSubstitution() {
        return this.renamerFilenameSpaceSubstitution;
    }

    @JsonProperty(value="renamerSpaceSubstitution")
    public void setRenamerFilenameSpaceSubstitution(boolean newValue) {
        boolean oldValue = this.renamerFilenameSpaceSubstitution;
        this.renamerFilenameSpaceSubstitution = newValue;
        this.firePropertyChange("renamerFilenameSpaceSubstitution", oldValue, newValue);
    }

    public void setRenameAfterScrape(boolean newValue) {
        boolean oldValue = this.renameAfterScrape;
        this.renameAfterScrape = newValue;
        this.firePropertyChange("renameAfterScrape", oldValue, newValue);
    }

    public boolean isRenameAfterScrape() {
        return this.renameAfterScrape;
    }

    public boolean isUpdateOnStart() {
        return this.updateOnStart;
    }

    public void setUpdateOnStart(boolean newValue) {
        boolean oldValue = this.updateOnStart;
        this.updateOnStart = newValue;
        this.firePropertyChange("updateOnStart", oldValue, newValue);
    }

    public String getRenamerPathnameSpaceReplacement() {
        return this.renamerPathnameSpaceReplacement;
    }

    public void setRenamerPathnameSpaceReplacement(String newValue) {
        String oldValue = this.renamerPathnameSpaceReplacement;
        this.renamerPathnameSpaceReplacement = newValue;
        this.firePropertyChange("renamerPathnameSpaceReplacement", oldValue, newValue);
    }

    @JsonProperty(value="renamerSpaceReplacement")
    public String getRenamerFilenameSpaceReplacement() {
        return this.renamerFilenameSpaceReplacement;
    }

    public void setRenamerFilenameSpaceReplacement(String newValue) {
        String oldValue = this.renamerFilenameSpaceReplacement;
        this.renamerFilenameSpaceReplacement = newValue;
        this.firePropertyChange("renamerFilenameSpaceReplacement", oldValue, newValue);
    }

    public String getRenamerColonReplacement() {
        return this.renamerColonReplacement;
    }

    public void setRenamerColonReplacement(String newValue) {
        String oldValue = this.renamerColonReplacement;
        this.renamerColonReplacement = newValue;
        this.firePropertyChange("renamerColonReplacement", oldValue, newValue);
    }

    public String getRenamerFirstCharacterNumberReplacement() {
        return this.renamerFirstCharacterNumberReplacement;
    }

    public void setRenamerFirstCharacterNumberReplacement(String newValue) {
        String oldValue = this.renamerFirstCharacterNumberReplacement;
        this.renamerFirstCharacterNumberReplacement = newValue;
        this.firePropertyChange("renamerFirstCharacterNumberReplacement", oldValue, newValue);
    }

    public String getMovieScraper() {
        if (StringUtils.isBlank((CharSequence)this.movieScraper)) {
            return "tmdb";
        }
        return this.movieScraper;
    }

    public void setMovieScraper(String newValue) {
        String oldValue = this.movieScraper;
        this.movieScraper = newValue;
        this.firePropertyChange("movieScraper", oldValue, newValue);
    }

    public void addMovieArtworkScraper(String newValue) {
        if (!this.artworkScrapers.contains(newValue)) {
            this.artworkScrapers.add(newValue);
            this.firePropertyChange(ARTWORK_SCRAPERS, null, this.artworkScrapers);
        }
    }

    public void removeMovieArtworkScraper(String newValue) {
        if (this.artworkScrapers.contains(newValue)) {
            this.artworkScrapers.remove(newValue);
            this.firePropertyChange(ARTWORK_SCRAPERS, null, this.artworkScrapers);
        }
    }

    public List<String> getArtworkScrapers() {
        return this.artworkScrapers;
    }

    public boolean isScrapeBestImage() {
        return this.scrapeBestImage;
    }

    public void setScrapeBestImage(boolean newValue) {
        boolean oldValue = this.scrapeBestImage;
        this.scrapeBestImage = newValue;
        this.firePropertyChange("scrapeBestImage", oldValue, newValue);
    }

    public boolean isScrapeBestImageMovieSet() {
        return this.scrapeBestImageMovieSet;
    }

    public void setScrapeBestImageMovieSet(boolean newValue) {
        boolean oldValue = this.scrapeBestImageMovieSet;
        this.scrapeBestImageMovieSet = newValue;
        this.firePropertyChange("scrapeBestImageMovieSet", oldValue, newValue);
    }

    public String getMovieSetTitleCharacterReplacement() {
        return this.movieSetTitleCharacterReplacement;
    }

    public void setMovieSetTitleCharacterReplacement(String newValue) {
        String oldValue = this.movieSetTitleCharacterReplacement;
        this.movieSetTitleCharacterReplacement = newValue;
        this.firePropertyChange("movieSetTitleCharacterReplacement", oldValue, newValue);
    }

    public boolean isMovieSetAppendTmdbId() {
        return this.movieSetAppendTmdbId;
    }

    public void setMovieSetAppendTmdbId(boolean newValue) {
        boolean oldValue = this.movieSetAppendTmdbId;
        this.movieSetAppendTmdbId = newValue;
        this.firePropertyChange("movieSetAppendTmdbId", oldValue, newValue);
    }

    public void addMovieTrailerScraper(String newValue) {
        if (!this.trailerScrapers.contains(newValue)) {
            this.trailerScrapers.add(newValue);
            this.firePropertyChange(TRAILER_SCRAPERS, null, this.trailerScrapers);
        }
    }

    public void removeMovieTrailerScraper(String newValue) {
        if (this.trailerScrapers.contains(newValue)) {
            this.trailerScrapers.remove(newValue);
            this.firePropertyChange(TRAILER_SCRAPERS, null, this.trailerScrapers);
        }
    }

    public List<String> getTrailerScrapers() {
        return this.trailerScrapers;
    }

    public void addMovieSubtitleScraper(String newValue) {
        if (!this.subtitleScrapers.contains(newValue)) {
            this.subtitleScrapers.add(newValue);
            this.firePropertyChange(SUBTITLE_SCRAPERS, null, this.subtitleScrapers);
        }
    }

    public void removeMovieSubtitleScraper(String newValue) {
        if (this.subtitleScrapers.contains(newValue)) {
            this.subtitleScrapers.remove(newValue);
            this.firePropertyChange(SUBTITLE_SCRAPERS, null, this.subtitleScrapers);
        }
    }

    public List<String> getSubtitleScrapers() {
        return this.subtitleScrapers;
    }

    @JsonSetter
    public void setSkipFolder(List<String> newValues) {
        this.skipFolders.clear();
        this.skipFolders.addAll(newValues);
    }

    public void addSkipFolder(String newValue) {
        if (!this.skipFolders.contains(newValue)) {
            this.skipFolders.add(newValue);
            this.firePropertyChange(SKIP_FOLDER, null, this.skipFolders);
        }
    }

    public void removeSkipFolder(String newValue) {
        if (this.skipFolders.contains(newValue)) {
            this.skipFolders.remove(newValue);
            this.firePropertyChange(SKIP_FOLDER, null, this.skipFolders);
        }
    }

    public List<String> getSkipFolder() {
        return this.skipFolders;
    }

    public Map<String, List<AbstractSettings.UIFilters>> getMovieUiFilterPresets() {
        return this.movieUiFilterPresets;
    }

    public void setMovieUiFilterPresets(Map<String, List<AbstractSettings.UIFilters>> newValues) {
        this.movieUiFilterPresets.clear();
        this.movieUiFilterPresets.putAll(newValues);
        this.firePropertyChange(MOVIE_UI_FILTER_PRESETS, null, this.movieUiFilterPresets);
    }

    public Map<String, List<AbstractSettings.UIFilters>> getMovieSetUiFilterPresets() {
        return this.movieSetUiFilterPresets;
    }

    public void setMovieSetUiFilterPresets(Map<String, List<AbstractSettings.UIFilters>> newValues) {
        this.movieSetUiFilterPresets.clear();
        this.movieSetUiFilterPresets.putAll(newValues);
        this.firePropertyChange(MOVIE_SET_UI_FILTER_PRESETS, null, this.movieSetUiFilterPresets);
    }

    public boolean isWriteActorImages() {
        return this.writeActorImages;
    }

    public void setWriteActorImages(boolean newValue) {
        boolean oldValue = this.writeActorImages;
        this.writeActorImages = newValue;
        this.firePropertyChange("writeActorImages", oldValue, newValue);
    }

    public MediaLanguages getScraperLanguage() {
        return this.scraperLanguage;
    }

    public void setScraperLanguage(MediaLanguages newValue) {
        MediaLanguages oldValue = this.scraperLanguage;
        this.scraperLanguage = newValue;
        this.firePropertyChange("scraperLanguage", (Object)oldValue, (Object)newValue);
    }

    public MediaLanguages getSubtitleScraperLanguage() {
        return this.subtitleScraperLanguage;
    }

    public void setSubtitleScraperLanguage(MediaLanguages newValue) {
        MediaLanguages oldValue = this.subtitleScraperLanguage;
        this.subtitleScraperLanguage = newValue;
        this.firePropertyChange("subtitleScraperLanguage", (Object)oldValue, (Object)newValue);
    }

    public CountryCode getCertificationCountry() {
        return this.certificationCountry;
    }

    public void setCertificationCountry(CountryCode newValue) {
        CountryCode oldValue = this.certificationCountry;
        this.certificationCountry = newValue;
        this.firePropertyChange("certificationCountry", (Object)oldValue, (Object)newValue);
    }

    public String getReleaseDateCountry() {
        return this.releaseDateCountry;
    }

    public void setReleaseDateCountry(String newValue) {
        String oldValue = this.releaseDateCountry;
        this.releaseDateCountry = newValue;
        this.firePropertyChange("releaseDateCountry", oldValue, newValue);
    }

    public double getScraperThreshold() {
        return this.scraperThreshold;
    }

    public void setScraperThreshold(double newValue) {
        double oldValue = this.scraperThreshold;
        this.scraperThreshold = newValue;
        this.firePropertyChange("scraperThreshold", oldValue, newValue);
    }

    public boolean isRenamerCleanupUnwanted() {
        return this.renamerCleanupUnwanted;
    }

    public void setRenamerCleanupUnwanted(boolean newValue) {
        boolean oldValue = this.renamerCleanupUnwanted;
        this.renamerCleanupUnwanted = newValue;
        this.firePropertyChange("renamerCleanupUnwanted", oldValue, newValue);
    }

    public boolean isRenamerNfoCleanup() {
        return this.renamerNfoCleanup;
    }

    public void setRenamerNfoCleanup(boolean newValue) {
        boolean oldValue = this.renamerNfoCleanup;
        this.renamerNfoCleanup = newValue;
        this.firePropertyChange("renamerNfoCleanup", oldValue, newValue);
    }

    public boolean isSkipFoldersWithNomedia() {
        return this.skipFoldersWithNomedia;
    }

    public void setSkipFoldersWithNomedia(boolean newValue) {
        boolean oldValue = this.skipFoldersWithNomedia;
        this.skipFoldersWithNomedia = newValue;
        this.firePropertyChange("skipFoldersWithNomedia", oldValue, newValue);
    }

    public boolean isBuildImageCacheOnImport() {
        return this.buildImageCacheOnImport;
    }

    public void setBuildImageCacheOnImport(boolean newValue) {
        boolean oldValue = this.buildImageCacheOnImport;
        this.buildImageCacheOnImport = newValue;
        this.firePropertyChange("buildImageCacheOnImport", oldValue, newValue);
    }

    public boolean isRenamerCreateMoviesetForSingleMovie() {
        return this.renamerCreateMoviesetForSingleMovie;
    }

    public void setRenamerCreateMoviesetForSingleMovie(boolean newValue) {
        boolean oldValue = this.renamerCreateMoviesetForSingleMovie;
        this.renamerCreateMoviesetForSingleMovie = newValue;
        this.firePropertyChange("renamerCreateMoviesetForSingleMovie", oldValue, newValue);
    }

    public boolean isRuntimeFromMediaInfo() {
        return this.runtimeFromMediaInfo;
    }

    public void setRuntimeFromMediaInfo(boolean newValue) {
        boolean oldValue = this.runtimeFromMediaInfo;
        this.runtimeFromMediaInfo = newValue;
        this.firePropertyChange("runtimeFromMediaInfo", oldValue, newValue);
    }

    public boolean isExtractArtworkFromVsmeta() {
        return this.extractArtworkFromVsmeta;
    }

    public void setExtractArtworkFromVsmeta(boolean newValue) {
        boolean oldValue = this.extractArtworkFromVsmeta;
        this.extractArtworkFromVsmeta = newValue;
        this.firePropertyChange("extractArtworkFromVsmeta", oldValue, newValue);
    }

    public boolean isUseMediainfoMetadata() {
        return this.useMediainfoMetadata;
    }

    public void setUseMediainfoMetadata(boolean newValue) {
        boolean oldValue = this.useMediainfoMetadata;
        this.useMediainfoMetadata = newValue;
        this.firePropertyChange("useMediainfoMetadata", oldValue, newValue);
    }

    public void setTitle(boolean newValue) {
        boolean oldValue = this.title;
        this.title = newValue;
        this.firePropertyChange("title", oldValue, newValue);
    }

    public void setSortableTitle(boolean newValue) {
        boolean oldValue = this.sortableTitle;
        this.sortableTitle = newValue;
        this.firePropertyChange("sortableTitle", oldValue, newValue);
    }

    public void setOriginalTitle(boolean newValue) {
        boolean oldValue = this.originalTitle;
        this.originalTitle = newValue;
        this.firePropertyChange("originalTitle", oldValue, newValue);
    }

    public void setSortableOriginalTitle(boolean newValue) {
        boolean oldValue = this.sortableOriginalTitle;
        this.sortableOriginalTitle = newValue;
        this.firePropertyChange("sortableOriginalTitle", oldValue, newValue);
    }

    public void setSortTitle(boolean newValue) {
        boolean oldValue = this.sortTitle;
        this.sortTitle = newValue;
        this.firePropertyChange("sortTitle", oldValue, newValue);
    }

    public void setEnglishTitle(boolean newValue) {
        boolean oldValue = this.englishTitle;
        this.englishTitle = newValue;
        this.firePropertyChange("englishTitle", oldValue, newValue);
    }

    public boolean getTitle() {
        return this.title;
    }

    public boolean getSortableTitle() {
        return this.sortableTitle;
    }

    public boolean getOriginalTitle() {
        return this.originalTitle;
    }

    public boolean getSortableOriginalTitle() {
        return this.sortableOriginalTitle;
    }

    public boolean getSortTitle() {
        return this.sortTitle;
    }

    public boolean getEnglishTitle() {
        return this.englishTitle;
    }

    public boolean isIncludeExternalAudioStreams() {
        return this.includeExternalAudioStreams;
    }

    public void setIncludeExternalAudioStreams(boolean newValue) {
        boolean oldValue = this.includeExternalAudioStreams;
        this.includeExternalAudioStreams = newValue;
        this.firePropertyChange("includeExternalAudioStreams", oldValue, newValue);
    }

    public boolean isAsciiReplacement() {
        return this.asciiReplacement;
    }

    public void setAsciiReplacement(boolean newValue) {
        boolean oldValue = this.asciiReplacement;
        this.asciiReplacement = newValue;
        this.firePropertyChange("asciiReplacement", oldValue, newValue);
    }

    public boolean isUnicodeReplacement() {
        return this.unicodeReplacement;
    }

    public void setUnicodeReplacement(boolean newValue) {
        boolean oldValue = this.unicodeReplacement;
        this.unicodeReplacement = newValue;
        this.firePropertyChange("unicodeReplacement", oldValue, newValue);
    }

    public boolean isAllowMultipleMoviesInSameDir() {
        return this.allowMultipleMoviesInSameDir;
    }

    public void setAllowMultipleMoviesInSameDir(boolean newValue) {
        boolean oldValue = this.allowMultipleMoviesInSameDir;
        this.allowMultipleMoviesInSameDir = newValue;
        this.firePropertyChange("allowMultipleMoviesInSameDir", oldValue, newValue);
    }

    public void addBadWord(String badWord) {
        if (!this.badWords.contains(badWord.toLowerCase(Locale.ROOT))) {
            this.badWords.add(badWord.toLowerCase(Locale.ROOT));
            this.firePropertyChange(BAD_WORD, null, this.badWords);
        }
    }

    public void removeBadWord(String badWord) {
        this.badWords.remove(badWord.toLowerCase(Locale.ROOT));
        this.firePropertyChange(BAD_WORD, null, this.badWords);
    }

    public List<String> getBadWord() {
        ListIterator<String> iterator = this.badWords.listIterator();
        while (iterator.hasNext()) {
            iterator.set(iterator.next().toLowerCase(Locale.ROOT));
        }
        return this.badWords;
    }

    public boolean isScraperFallback() {
        return this.scraperFallback;
    }

    public void setScraperFallback(boolean newValue) {
        boolean oldValue = this.scraperFallback;
        this.scraperFallback = newValue;
        this.firePropertyChange("scraperFallback", oldValue, newValue);
    }

    public boolean isUseYtDlp() {
        return this.useYtDlp;
    }

    public void setUseYtDlp(boolean newValue) {
        boolean oldValue = this.useYtDlp;
        this.useYtDlp = newValue;
        this.firePropertyChange("useYtDlp", oldValue, newValue);
    }

    public boolean isUseTrailerPreference() {
        return this.useTrailerPreference;
    }

    public void setUseTrailerPreference(boolean newValue) {
        boolean oldValue = this.useTrailerPreference;
        this.useTrailerPreference = newValue;
        this.firePropertyChange("useTrailerPreference", oldValue, newValue);
        this.firePropertyChange("automaticTrailerDownload", oldValue, newValue);
    }

    public boolean isAutomaticTrailerDownload() {
        return this.useTrailerPreference && this.automaticTrailerDownload;
    }

    public void setAutomaticTrailerDownload(boolean newValue) {
        boolean oldValue = this.automaticTrailerDownload;
        this.automaticTrailerDownload = newValue;
        this.firePropertyChange("automaticTrailerDownload", oldValue, newValue);
    }

    public TrailerQuality getTrailerQuality() {
        return this.trailerQuality;
    }

    public void setTrailerQuality(TrailerQuality newValue) {
        TrailerQuality oldValue = this.trailerQuality;
        this.trailerQuality = newValue;
        this.firePropertyChange("trailerQuality", (Object)oldValue, (Object)newValue);
    }

    public TrailerSources getTrailerSource() {
        return this.trailerSource;
    }

    public void setTrailerSource(TrailerSources newValue) {
        TrailerSources oldValue = this.trailerSource;
        this.trailerSource = newValue;
        this.firePropertyChange("trailerSource", (Object)oldValue, (Object)newValue);
    }

    public void setSyncTrakt(boolean newValue) {
        boolean oldValue = this.syncTrakt;
        this.syncTrakt = newValue;
        this.firePropertyChange("syncTrakt", oldValue, newValue);
    }

    public boolean getSyncTrakt() {
        return this.syncTrakt;
    }

    public void setSyncTraktCollection(boolean newValue) {
        boolean oldValue = this.syncTraktCollection;
        this.syncTraktCollection = newValue;
        this.firePropertyChange("syncTraktCollection", oldValue, newValue);
    }

    public boolean getSyncTraktCollection() {
        return this.syncTraktCollection;
    }

    public void setSyncTraktWatched(boolean newValue) {
        boolean oldValue = this.syncTraktWatched;
        this.syncTraktWatched = newValue;
        this.firePropertyChange("syncTraktWatched", oldValue, newValue);
    }

    public boolean getSyncTraktWatched() {
        return this.syncTraktWatched;
    }

    public void setSyncTraktRating(boolean newValue) {
        boolean oldValue = this.syncTraktRating;
        this.syncTraktRating = newValue;
        this.firePropertyChange("syncTraktRating", oldValue, newValue);
    }

    public boolean getSyncTraktRating() {
        return this.syncTraktRating;
    }

    public List<String> getRatingSources() {
        return this.ratingSources;
    }

    public void setRatingSources(List<String> newValue) {
        this.ratingSources.clear();
        this.ratingSources.addAll(newValue);
        this.firePropertyChange("ratingSources", null, this.ratingSources);
    }

    public void addRatingSource(String ratingSource) {
        if (!this.ratingSources.contains(ratingSource)) {
            this.ratingSources.add(ratingSource);
            this.firePropertyChange("ratingSources", null, this.ratingSources);
        }
    }

    public void removeRatingSource(String ratingSource) {
        if (this.ratingSources.remove(ratingSource)) {
            this.firePropertyChange("ratingSources", null, this.ratingSources);
        }
    }

    public void swapRatingSources(int pos1, int pos2) {
        String tmp = this.ratingSources.get(pos1);
        this.ratingSources.set(pos1, this.ratingSources.get(pos2));
        this.ratingSources.set(pos2, tmp);
        this.firePropertyChange("ratingSources", null, this.ratingSources);
    }

    public void setImageScraperLanguages(List<MediaLanguages> newValue) {
        this.imageScraperLanguages.clear();
        this.imageScraperLanguages.addAll(newValue);
        this.firePropertyChange("imageScraperLanguages", null, this.imageScraperLanguages);
    }

    public void addImageScraperLanguage(MediaLanguages language) {
        if (!this.imageScraperLanguages.contains((Object)language)) {
            this.imageScraperLanguages.add(language);
            this.firePropertyChange("imageScraperLanguages", null, this.imageScraperLanguages);
        }
    }

    public void removeImageScraperLanguage(MediaLanguages language) {
        if (this.imageScraperLanguages.remove((Object)language)) {
            this.firePropertyChange("imageScraperLanguages", null, this.imageScraperLanguages);
        }
    }

    public void swapImageScraperLanguage(int pos1, int pos2) {
        MediaLanguages tmp = this.imageScraperLanguages.get(pos1);
        this.imageScraperLanguages.set(pos1, this.imageScraperLanguages.get(pos2));
        this.imageScraperLanguages.set(pos2, tmp);
        this.firePropertyChange("imageScraperLanguages", null, this.imageScraperLanguages);
    }

    public List<MediaLanguages> getImageScraperLanguages() {
        return this.imageScraperLanguages;
    }

    public MediaLanguages getDefaultImageScraperLanguage() {
        MediaLanguages language = this.scraperLanguage;
        if (!this.imageScraperLanguages.isEmpty()) {
            language = this.imageScraperLanguages.get(0);
        }
        return language;
    }

    public boolean isImageScraperOtherResolutions() {
        return this.imageScraperOtherResolutions;
    }

    public void setImageScraperOtherResolutions(boolean newValue) {
        boolean oldValue = this.imageScraperOtherResolutions;
        this.imageScraperOtherResolutions = newValue;
        this.firePropertyChange("imageScraperOtherResolutions", oldValue, newValue);
    }

    public boolean isImageScraperFallback() {
        return this.imageScraperFallback;
    }

    public void setImageScraperFallback(boolean newValue) {
        boolean oldValue = this.imageScraperFallback;
        this.imageScraperFallback = newValue;
        this.firePropertyChange("imageScraperFallback", oldValue, newValue);
    }

    public boolean isImageScraperPreferFanartWoText() {
        return this.imageScraperPreferFanartWoText;
    }

    public void setImageScraperPreferFanartWoText(boolean newValue) {
        boolean oldValue = this.imageScraperPreferFanartWoText;
        this.imageScraperPreferFanartWoText = newValue;
        this.firePropertyChange("imageScraperPreferFanartWoText", oldValue, newValue);
    }

    public CertificationStyle getCertificationStyle() {
        return this.certificationStyle;
    }

    public void setCertificationStyle(CertificationStyle newValue) {
        CertificationStyle oldValue = this.certificationStyle;
        this.certificationStyle = newValue;
        this.firePropertyChange("certificationStyle", (Object)oldValue, (Object)newValue);
    }

    public LanguageStyle getSubtitleLanguageStyle() {
        return this.subtitleLanguageStyle;
    }

    public void setSubtitleLanguageStyle(LanguageStyle newValue) {
        LanguageStyle oldValue = this.subtitleLanguageStyle;
        this.subtitleLanguageStyle = newValue;
        this.firePropertyChange("subtitleLanguageStyle", (Object)oldValue, (Object)newValue);
    }

    public boolean isSubtitleWithoutLanguageTag() {
        return this.subtitleWithoutLanguageTag;
    }

    public void setSubtitleWithoutLanguageTag(boolean newValue) {
        boolean oldValue = this.subtitleWithoutLanguageTag;
        this.subtitleWithoutLanguageTag = newValue;
        this.firePropertyChange("subtitleWithoutLanguageTag", oldValue, newValue);
    }

    public boolean isSubtitleForceBestMatch() {
        return this.subtitleForceBestMatch;
    }

    public void setSubtitleForceBestMatch(boolean newValue) {
        boolean oldValue = this.subtitleForceBestMatch;
        this.subtitleForceBestMatch = newValue;
        this.firePropertyChange("subtitleForceBestMatch", oldValue, newValue);
    }

    public List<MovieScraperMetadataConfig> getScraperMetadataConfig() {
        return this.scraperMetadataConfig;
    }

    public void setScraperMetadataConfig(List<MovieScraperMetadataConfig> newValues) {
        this.scraperMetadataConfig.clear();
        this.scraperMetadataConfig.addAll(newValues);
        this.firePropertyChange("scraperMetadataConfig", null, this.scraperMetadataConfig);
    }

    public boolean isNfoDiscFolderInside() {
        return this.nfoDiscFolderInside;
    }

    public void setNfoDiscFolderInside(boolean newValue) {
        boolean oldValue = this.nfoDiscFolderInside;
        this.nfoDiscFolderInside = newValue;
        this.firePropertyChange("nfoDiscFolderInside", oldValue, newValue);
    }

    public boolean isTrailerDiscFolderInside() {
        return this.trailerDiscFolderInside;
    }

    public void setTrailerDiscFolderInside(boolean newValue) {
        boolean oldValue = this.trailerDiscFolderInside;
        this.trailerDiscFolderInside = newValue;
        this.firePropertyChange("trailerDiscFolderInside", oldValue, newValue);
    }

    public boolean isWriteCleanNfo() {
        return this.writeCleanNfo;
    }

    public void setWriteCleanNfo(boolean newValue) {
        boolean oldValue = this.writeCleanNfo;
        this.writeCleanNfo = newValue;
        this.firePropertyChange("writeCleanNfo", oldValue, newValue);
    }

    public boolean isNfoWriteDateAdded() {
        return this.nfoWriteDateAdded;
    }

    public void setNfoWriteDateAdded(boolean newValue) {
        boolean oldValue = this.nfoWriteDateAdded;
        this.nfoWriteDateAdded = newValue;
        this.firePropertyChange("nfoWriteDateAdded", oldValue, newValue);
    }

    public DateField getNfoDateAddedField() {
        return this.nfoDateAddedField;
    }

    public void setNfoDateAddedField(DateField newValue) {
        DateField oldValue = this.nfoDateAddedField;
        this.nfoDateAddedField = newValue;
        this.firePropertyChange("nfoDateAddedField", (Object)oldValue, (Object)newValue);
    }

    public boolean isNfoWriteSingleStudio() {
        return this.nfoWriteSingleStudio;
    }

    public void setNfoWriteSingleStudio(boolean newValue) {
        boolean oldValue = this.nfoWriteSingleStudio;
        this.nfoWriteSingleStudio = newValue;
        this.firePropertyChange("nfoWriteSingleStudio", oldValue, newValue);
    }

    public boolean isNfoWriteLockdata() {
        return this.nfoWriteLockdata;
    }

    public void setNfoWriteLockdata(boolean newValue) {
        boolean oldValue = this.nfoWriteLockdata;
        this.nfoWriteLockdata = newValue;
        this.firePropertyChange("nfoWriteLockdata", oldValue, newValue);
    }

    public boolean isNfoWriteTrailer() {
        return this.nfoWriteTrailer;
    }

    public void setNfoWriteTrailer(boolean newValue) {
        boolean oldValue = this.nfoWriteTrailer;
        this.nfoWriteTrailer = newValue;
        this.firePropertyChange("nfoWriteTrailer", oldValue, newValue);
    }

    public boolean isNfoWriteFileinfo() {
        return this.nfoWriteFileinfo;
    }

    public void setNfoWriteFileinfo(boolean newValue) {
        boolean oldValue = this.nfoWriteFileinfo;
        this.nfoWriteFileinfo = newValue;
        this.firePropertyChange("nfoWriteFileinfo", oldValue, newValue);
    }

    public boolean isNfoWriteArtworkUrls() {
        return this.nfoWriteArtworkUrls;
    }

    public void setNfoWriteArtworkUrls(boolean newValue) {
        boolean oldValue = this.nfoWriteArtworkUrls;
        this.nfoWriteArtworkUrls = newValue;
        this.firePropertyChange("nfoWriteArtworkUrls", oldValue, newValue);
    }

    public Locale getNfoLanguage() {
        return this.nfoLanguage;
    }

    public void setNfoLanguage(Locale newValue) {
        Locale oldValue = this.nfoLanguage;
        this.nfoLanguage = newValue;
        this.firePropertyChange("nfoLanguage", oldValue, newValue);
    }

    public boolean isCreateOutline() {
        return this.createOutline;
    }

    public void setCreateOutline(boolean newValue) {
        boolean oldValue = this.createOutline;
        this.createOutline = newValue;
        this.firePropertyChange("createOutline", oldValue, newValue);
    }

    public boolean isOutlineFirstSentence() {
        return this.outlineFirstSentence;
    }

    public void setOutlineFirstSentence(boolean newValue) {
        boolean oldValue = this.outlineFirstSentence;
        this.outlineFirstSentence = newValue;
        this.firePropertyChange("outlineFirstSentence", oldValue, newValue);
    }

    public boolean getCapitalWordsInTitles() {
        return this.capitalWordsInTitles;
    }

    public void setCapitalWordsInTitles(boolean newValue) {
        boolean oldValue = this.capitalWordsInTitles;
        this.capitalWordsInTitles = newValue;
        this.firePropertyChange("capitalWordsInTitles", oldValue, newValue);
    }

    public boolean isFetchAllRatings() {
        return this.fetchAllRatings;
    }

    public void setFetchAllRatings(boolean newValue) {
        boolean oldValue = this.fetchAllRatings;
        this.fetchAllRatings = newValue;
        this.firePropertyChange("fetchAllRatings", oldValue, newValue);
    }

    public List<RatingProvider.RatingSource> getFetchRatingSources() {
        return this.fetchRatingSources;
    }

    public void setFetchRatingSources(List<RatingProvider.RatingSource> newValues) {
        this.fetchRatingSources.clear();
        this.fetchRatingSources.addAll(newValues);
        this.firePropertyChange("fetchRatingSources", null, this.fetchRatingSources);
    }

    public boolean isDoNotOverwriteExistingData() {
        return this.doNotOverwriteExistingData;
    }

    public void setDoNotOverwriteExistingData(boolean newValue) {
        boolean oldValue = this.doNotOverwriteExistingData;
        this.doNotOverwriteExistingData = newValue;
        this.firePropertyChange("doNotOverwriteExistingData", oldValue, newValue);
    }

    public MovieSetConnectors getMovieSetConnector() {
        return this.movieSetConnector;
    }

    public void setMovieSetConnector(MovieSetConnectors newValue) {
        MovieSetConnectors oldValue = this.movieSetConnector;
        this.movieSetConnector = newValue;
        this.firePropertyChange("movieSetConnector", (Object)oldValue, (Object)newValue);
    }

    public void addMovieSetNfoFilename(MovieSetNfoNaming filename) {
        if (!this.movieSetNfoFilenames.contains(filename)) {
            this.movieSetNfoFilenames.add(filename);
            this.firePropertyChange("movieSetNfoFilenames", null, this.movieSetNfoFilenames);
        }
    }

    public void clearMovieSetNfoFilenames() {
        this.movieSetNfoFilenames.clear();
        this.firePropertyChange("movieSetNfoFilenames", null, this.movieSetNfoFilenames);
    }

    public List<MovieSetNfoNaming> getMovieSetNfoFilenames() {
        return new ArrayList<MovieSetNfoNaming>(this.movieSetNfoFilenames);
    }

    public void addMovieSetPosterFilename(MovieSetPosterNaming filename) {
        if (!this.movieSetPosterFilenames.contains(filename)) {
            this.movieSetPosterFilenames.add(filename);
            this.firePropertyChange(MOVIE_SET_POSTER_FILENAME, null, this.movieSetPosterFilenames);
        }
    }

    public void clearMovieSetPosterFilenames() {
        this.movieSetPosterFilenames.clear();
        this.firePropertyChange(MOVIE_SET_POSTER_FILENAME, null, this.movieSetPosterFilenames);
    }

    public List<MovieSetPosterNaming> getMovieSetPosterFilenames() {
        return new ArrayList<MovieSetPosterNaming>(this.movieSetPosterFilenames);
    }

    public void addMovieSetFanartFilename(MovieSetFanartNaming filename) {
        if (!this.movieSetFanartFilenames.contains(filename)) {
            this.movieSetFanartFilenames.add(filename);
            this.firePropertyChange(MOVIE_SET_FANART_FILENAME, null, this.movieSetFanartFilenames);
        }
    }

    public void clearMovieSetFanartFilenames() {
        this.movieSetFanartFilenames.clear();
        this.firePropertyChange(MOVIE_SET_FANART_FILENAME, null, this.movieSetFanartFilenames);
    }

    public List<MovieSetFanartNaming> getMovieSetFanartFilenames() {
        return new ArrayList<MovieSetFanartNaming>(this.movieSetFanartFilenames);
    }

    public void addMovieSetBannerFilename(MovieSetBannerNaming filename) {
        if (!this.movieSetBannerFilenames.contains(filename)) {
            this.movieSetBannerFilenames.add(filename);
            this.firePropertyChange(MOVIE_SET_BANNER_FILENAME, null, this.movieSetBannerFilenames);
        }
    }

    public void clearMovieSetBannerFilenames() {
        this.movieSetBannerFilenames.clear();
        this.firePropertyChange(MOVIE_SET_BANNER_FILENAME, null, this.movieSetBannerFilenames);
    }

    public List<MovieSetBannerNaming> getMovieSetBannerFilenames() {
        return new ArrayList<MovieSetBannerNaming>(this.movieSetBannerFilenames);
    }

    public void addMovieSetClearartFilename(MovieSetClearartNaming filename) {
        if (!this.movieSetClearartFilenames.contains(filename)) {
            this.movieSetClearartFilenames.add(filename);
            this.firePropertyChange(MOVIE_SET_CLEARART_FILENAME, null, this.movieSetClearartFilenames);
        }
    }

    public void clearMovieSetClearartFilenames() {
        this.movieSetClearartFilenames.clear();
        this.firePropertyChange(MOVIE_SET_CLEARART_FILENAME, null, this.movieSetClearartFilenames);
    }

    public List<MovieSetClearartNaming> getMovieSetClearartFilenames() {
        return new ArrayList<MovieSetClearartNaming>(this.movieSetClearartFilenames);
    }

    public void addMovieSetThumbFilename(MovieSetThumbNaming filename) {
        if (!this.movieSetThumbFilenames.contains(filename)) {
            this.movieSetThumbFilenames.add(filename);
            this.firePropertyChange(MOVIE_SET_THUMB_FILENAME, null, this.movieSetThumbFilenames);
        }
    }

    public void clearMovieSetThumbFilenames() {
        this.movieSetThumbFilenames.clear();
        this.firePropertyChange(MOVIE_SET_THUMB_FILENAME, null, this.movieSetThumbFilenames);
    }

    public List<MovieSetThumbNaming> getMovieSetThumbFilenames() {
        return new ArrayList<MovieSetThumbNaming>(this.movieSetThumbFilenames);
    }

    public void addMovieSetClearlogoFilename(MovieSetClearlogoNaming filename) {
        if (!this.movieSetClearlogoFilenames.contains(filename)) {
            this.movieSetClearlogoFilenames.add(filename);
            this.firePropertyChange(MOVIE_SET_CLEARLOGO_FILENAME, null, this.movieSetClearlogoFilenames);
        }
    }

    public void clearMovieSetClearlogoFilenames() {
        this.movieSetClearlogoFilenames.clear();
        this.firePropertyChange(MOVIE_SET_CLEARLOGO_FILENAME, null, this.movieSetClearlogoFilenames);
    }

    public List<MovieSetClearlogoNaming> getMovieSetClearlogoFilenames() {
        return new ArrayList<MovieSetClearlogoNaming>(this.movieSetClearlogoFilenames);
    }

    public void addMovieSetDiscartFilename(MovieSetDiscartNaming filename) {
        if (!this.movieSetDiscartFilenames.contains(filename)) {
            this.movieSetDiscartFilenames.add(filename);
            this.firePropertyChange(MOVIE_SET_DISCART_FILENAME, null, this.movieSetDiscartFilenames);
        }
    }

    public void clearMovieSetDiscartFilenames() {
        this.movieSetDiscartFilenames.clear();
        this.firePropertyChange(MOVIE_SET_DISCART_FILENAME, null, this.movieSetDiscartFilenames);
    }

    public List<MovieSetDiscartNaming> getMovieSetDiscartFilenames() {
        return new ArrayList<MovieSetDiscartNaming>(this.movieSetDiscartFilenames);
    }

    public boolean isShowMovieTableTooltips() {
        return this.showMovieTableTooltips;
    }

    public void setShowMovieTableTooltips(boolean newValue) {
        boolean oldValue = this.showMovieTableTooltips;
        this.showMovieTableTooltips = newValue;
        this.firePropertyChange("showMovieTableTooltips", oldValue, newValue);
    }

    public boolean isShowMovieSetTableTooltips() {
        return this.showMovieSetTableTooltips;
    }

    public void setShowMovieSetTableTooltips(boolean newValue) {
        boolean oldValue = this.showMovieSetTableTooltips;
        this.showMovieSetTableTooltips = newValue;
        this.firePropertyChange("showMovieSetTableTooltips", oldValue, newValue);
    }

    public boolean isDisplayMovieSetMissingMovies() {
        return this.displayMovieSetMissingMovies;
    }

    public void setDisplayMovieSetMissingMovies(boolean newValue) {
        boolean oldValue = this.displayMovieSetMissingMovies;
        this.displayMovieSetMissingMovies = newValue;
        this.firePropertyChange("displayMovieSetMissingMovies", oldValue, newValue);
    }

    public void setUiFilters(List<AbstractSettings.UIFilters> filters) {
        this.uiFilters.clear();
        this.uiFilters.addAll(filters);
        this.firePropertyChange("uiFilters", null, this.uiFilters);
    }

    public List<AbstractSettings.UIFilters> getUiFilters() {
        if (this.storeUiFilters) {
            return this.uiFilters;
        }
        return new ArrayList<AbstractSettings.UIFilters>();
    }

    public void setUniversalFilterFields(List<AbstractSettings.UniversalFilterFields> fields) {
        this.universalFilterFields.clear();
        this.universalFilterFields.addAll(fields);
        this.firePropertyChange("universalFilterFields", null, this.universalFilterFields);
    }

    public List<AbstractSettings.UniversalFilterFields> getUniversalFilterFields() {
        return this.universalFilterFields;
    }

    public void setStoreUiFilters(boolean newValue) {
        boolean oldValue = this.storeUiFilters;
        this.storeUiFilters = newValue;
        this.firePropertyChange("storeUiFilters", oldValue, newValue);
    }

    public boolean isStoreUiFilters() {
        return this.storeUiFilters;
    }

    public void setMovieSetUiFilters(List<AbstractSettings.UIFilters> filters) {
        this.movieSetUiFilters.clear();
        this.movieSetUiFilters.addAll(filters);
        this.firePropertyChange("movieSetUiFilters", null, this.movieSetUiFilters);
    }

    public List<AbstractSettings.UIFilters> getMovieSetUiFilters() {
        if (this.storeUiFilters) {
            return this.movieSetUiFilters;
        }
        return new ArrayList<AbstractSettings.UIFilters>();
    }

    public void setStoreMovieSetUiFilters(boolean newValue) {
        boolean oldValue = this.storeMovieSetUiFilters;
        this.storeMovieSetUiFilters = newValue;
        this.firePropertyChange("storeMovieSetUiFilters", oldValue, newValue);
    }

    public boolean isStoreMovieSetUiFilters() {
        return this.storeMovieSetUiFilters;
    }

    public void addPostProcess(PostProcess newProcess) {
        this.postProcess.add(newProcess);
        this.firePropertyChange(POST_PROCESS, null, this.postProcess);
    }

    public void removePostProcess(PostProcess process) {
        this.postProcess.remove(process);
        this.firePropertyChange(POST_PROCESS, null, this.postProcess);
    }

    public List<PostProcess> getPostProcess() {
        return this.postProcess;
    }

    public void setPostProcess(List<PostProcess> newValues) {
        this.postProcess.clear();
        this.postProcess.addAll(newValues);
        this.firePropertyChange(POST_PROCESS, null, this.postProcess);
    }

    public void addMovieSetPostProcess(PostProcess newProcess) {
        this.movieSetPostProcess.add(newProcess);
        this.firePropertyChange(MOVIE_SET_POST_PROCESS, null, this.movieSetPostProcess);
    }

    public void removeMovieSetPostProcess(PostProcess process) {
        this.movieSetPostProcess.remove(process);
        this.firePropertyChange(MOVIE_SET_POST_PROCESS, null, this.movieSetPostProcess);
    }

    public List<PostProcess> getMovieSetPostProcess() {
        return this.movieSetPostProcess;
    }

    public void setMovieSetPostProcess(List<PostProcess> newValues) {
        this.movieSetPostProcess.clear();
        this.movieSetPostProcess.addAll(newValues);
        this.firePropertyChange(MOVIE_SET_POST_PROCESS, null, this.movieSetPostProcess);
    }

    public boolean isResetNewFlagOnUds() {
        return this.resetNewFlagOnUds;
    }

    public void setResetNewFlagOnUds(boolean newValue) {
        boolean oldValue = this.resetNewFlagOnUds;
        this.resetNewFlagOnUds = newValue;
        this.firePropertyChange("resetNewFlagOnUds", oldValue, newValue);
    }
}

