/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.util;

import com.hdcookbook.grin.util.ImageManager;
import com.hdcookbook.grin.util.ManagedFullImage;
import com.hdcookbook.grin.util.ManagedImage;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class ManagedSubImage
extends ManagedImage {
    private String name;
    private ManagedFullImage mosaic;
    private Rectangle placement;
    private int numReferences = 0;

    ManagedSubImage(String string, String string2, Rectangle rectangle) {
        this.name = string;
        this.mosaic = (ManagedFullImage)ImageManager.getImage(string2);
        this.placement = rectangle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getWidth() {
        return this.placement.width;
    }

    @Override
    public int getHeight() {
        return this.placement.height;
    }

    @Override
    void addReference() {
        ++this.numReferences;
        this.mosaic.addReference();
    }

    @Override
    void removeReference() {
        --this.numReferences;
        this.mosaic.removeReference();
    }

    @Override
    boolean isReferenced() {
        return this.numReferences > 0;
    }

    @Override
    public void prepare() {
        this.mosaic.prepare();
    }

    @Override
    public boolean isLoaded() {
        return this.mosaic.isLoaded();
    }

    @Override
    public boolean hadErrorLoading() {
        return this.mosaic.hadErrorLoading();
    }

    @Override
    public void load(Component component) {
        this.mosaic.load(component);
    }

    @Override
    public synchronized void startLoading(Component component) {
        this.mosaic.startLoading(component);
    }

    @Override
    public void unprepare() {
        this.mosaic.unprepare();
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, Component component) {
        Rectangle rectangle = this.placement;
        graphics2D.drawImage(this.mosaic.image, n, n2, n + rectangle.width, n2 + rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, component);
    }

    @Override
    public void drawScaled(Graphics2D graphics2D, Rectangle rectangle, Component component) {
        Rectangle rectangle2 = this.placement;
        graphics2D.drawImage(this.mosaic.image, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, component);
    }

    @Override
    public void drawClipped(Graphics2D graphics2D, int n, int n2, Rectangle rectangle, Component component) {
        Rectangle rectangle2 = this.placement;
        graphics2D.drawImage(this.mosaic.image, n, n2, n + rectangle.width, n2 + rectangle.height, rectangle2.x + rectangle.x, rectangle2.y + rectangle.y, rectangle2.x + rectangle.x + rectangle.width, rectangle2.y + rectangle.y + rectangle.height, component);
    }

    @Override
    void destroy() {
        ImageManager.ungetImage(this.mosaic);
    }
}

