/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.updater;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.license.License;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.util.UrlUtil;

public class UpdateCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateCheck.class);
    private String changelog = "";
    private String baseUrl = "";
    private boolean forceUpdate = false;

    /*
     * WARNING - void declaration
     */
    public boolean isUpdateAvailable() {
        TmmProperties.getInstance().putProperty("lastUpdateCheck", Long.toString(new Date().getTime()));
        if (ReleaseInfo.isGitBuild()) {
            return false;
        }
        Path getdownFile = UpdateCheck.getFile("getdown.txt");
        Path digestFile = UpdateCheck.getFile("digest.txt");
        LOGGER.info("Checking for updates...");
        try {
            List<String> updateUrls = UpdateCheck.parseUpdateUrls();
            boolean valid = false;
            String remoteDigest = "";
            String remoteUrl = "";
            for (String string : updateUrls) {
                void var8_14;
                if (!string.endsWith("/")) {
                    String string2 = string + "/";
                }
                try {
                    URL url = new URL((String)var8_14);
                    String protocol = url.getProtocol();
                    String authority = url.getAuthority();
                    this.baseUrl = String.format("%s://%s", protocol, authority);
                }
                catch (Exception e) {
                    LOGGER.debug("could not parse appbase - '{}'", (Object)e.getMessage());
                }
                String urlAsString = (String)var8_14 + "digest.txt";
                LOGGER.trace("Checking {}", (Object)var8_14);
                try {
                    Url url = ReleaseInfo.isNightly() ? new Url(urlAsString) : new Url(urlAsString + "?z=" + System.nanoTime() + "&clientver=" + License.getInstance().ref());
                    remoteDigest = UrlUtil.getStringFromUrl(url);
                    if (remoteDigest != null && remoteDigest.contains("tmm.jar")) {
                        remoteDigest = remoteDigest.strip();
                        valid = true;
                        remoteUrl = var8_14;
                    }
                }
                catch (InterruptedIOException | InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to download from url '{}' - '{}'", (Object)urlAsString, (Object)e.getMessage());
                }
                if (!valid) continue;
                break;
            }
            if (!valid) {
                throw new IOException("Error downloading remote checksum information.");
            }
            String localDigest = "";
            try {
                localDigest = Utils.readFileToString(digestFile).strip();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!localDigest.equals(remoteDigest)) {
                LOGGER.info("Update needed...");
                String string = UrlUtil.getStringFromUrl(remoteUrl + "getdown.txt");
                if (string.contains("forceUpdate")) {
                    this.forceUpdate = true;
                }
                this.changelog = UrlUtil.getStringFromUrl(remoteUrl + "changelog.txt");
                return true;
            }
            LOGGER.info("Already up2date :)");
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.warn("Update task failed badly - '{}'", (Object)e.getMessage());
            try {
                LOGGER.info("Trying fallback...");
                Object fallback = "https://www.tinymediamanager.org";
                fallback = ReleaseInfo.isPreRelease() ? (String)fallback + "/getdown_prerelease_v5.txt" : (ReleaseInfo.isNightly() ? (String)fallback + "/getdown_nightly_v5.txt" : (String)fallback + "/getdown_v5.txt");
                String gd = UrlUtil.getStringFromUrl((String)fallback);
                if (StringUtils.isBlank((CharSequence)gd) || !gd.contains("appbase")) {
                    throw new IOException("could not even download our fallback");
                }
                Utils.writeStringToFile(getdownFile, gd);
                return true;
            }
            catch (InterruptedIOException | InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e2) {
                LOGGER.warn("Update fallback failed - '{}'", (Object)e2.getMessage());
            }
        }
        return false;
    }

    public static List<String> parseUpdateUrls() {
        Path getdownFile = UpdateCheck.getFile("getdown.txt");
        ArrayList<String> updateUrls = new ArrayList<String>();
        try (Scanner scanner = new Scanner(getdownFile.toFile());){
            while (scanner.hasNextLine()) {
                String[] kv = scanner.nextLine().split("=");
                if (!"appbase".equals(kv[0].strip()) && !"mirror".equals(kv[0].strip())) continue;
                updateUrls.add(kv[1].strip());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return updateUrls;
    }

    public String getChangelog() {
        return this.changelog;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isForcedUpdate() {
        return this.forceUpdate;
    }

    private static Path getFile(String file) {
        Path ret = Paths.get(file, new String[0]);
        if (!Files.exists(ret, new LinkOption[0])) {
            ret = Paths.get(file + "_old", new String[0]);
        }
        return ret;
    }
}

