/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels.tvshow;

import java.beans.PropertyChangeListener;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.tvshow.TvShowHelpers;
import org.tinymediamanager.scraper.imdb.ImdbTvShowTrailerProvider;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.panels.TrailerPanel;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;

public class TvShowTrailerPanel
extends TrailerPanel {
    private final TvShowSelectionModel tvShowSelectionModel;

    public TvShowTrailerPanel(TvShowSelectionModel model) {
        this.tvShowSelectionModel = model;
        this.createLayout();
        this.table.setName("movies.trailerTable");
        TmmUILayoutStore.getInstance().install(this.table);
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != TvShowSelectionModel.class) {
                return;
            }
            if ("selectedTvShow".equals(property) || "trailer".equals(property)) {
                try {
                    this.trailerEventList.getReadWriteLock().writeLock().lock();
                    this.trailerEventList.clear();
                    this.trailerEventList.addAll(this.tvShowSelectionModel.getSelectedTvShow().getTrailer());
                }
                catch (Exception exception) {
                }
                finally {
                    this.trailerEventList.getReadWriteLock().writeLock().unlock();
                    this.table.adjustColumnPreferredWidths(7);
                }
            }
        };
        this.tvShowSelectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    protected void downloadTrailer(MediaTrailer trailer) {
        TvShowHelpers.downloadTrailer(this.tvShowSelectionModel.getSelectedTvShow(), trailer);
    }

    @Override
    protected String refreshUrlFromId(MediaTrailer trailer) {
        String url = trailer.getUrl();
        if (!url.startsWith("http")) {
            String id = trailer.getId();
            if (!id.matches("vi\\d+")) {
                return "";
            }
            ImdbTvShowTrailerProvider tp = new ImdbTvShowTrailerProvider();
            url = tp.getUrlForId(trailer);
            if (url.isEmpty()) {
                return "";
            }
        }
        return url;
    }
}

