/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaStreamInfo;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieSubtitleTypeFilter
extends AbstractCheckComboBoxMovieUIFilter<MediaStreamInfo.Flags> {
    public MovieSubtitleTypeFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.checkComboBox.setItems(List.of(MediaStreamInfo.Flags.FLAG_DEFAULT, MediaStreamInfo.Flags.FLAG_FORCED, MediaStreamInfo.Flags.FLAG_HEARING_IMPAIRED));
    }

    @Override
    protected String parseTypeToString(MediaStreamInfo.Flags type) throws Exception {
        return type.name();
    }

    @Override
    protected MediaStreamInfo.Flags parseStringToType(String string) throws Exception {
        try {
            return MediaStreamInfo.Flags.valueOf(string);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.subtitletype"));
    }

    @Override
    public String getId() {
        return "movieSubtitleType";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        List<MediaStreamInfo.Flags> types = movie.getMediaInfoSubtitleTypeList();
        for (MediaStreamInfo.Flags sel : selectedItems) {
            if (!types.contains((Object)sel)) continue;
            return true;
        }
        return false;
    }
}

