/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.MovieSetSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaIdProvider;
import org.tinymediamanager.scraper.interfaces.IMovieImdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieSetMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieTmdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IRatingProvider;
import org.tinymediamanager.scraper.tmdb.TmdbMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbUtils;
import org.tinymediamanager.scraper.tmdb.entities.AppendToResponse;
import org.tinymediamanager.scraper.tmdb.entities.BaseCollection;
import org.tinymediamanager.scraper.tmdb.entities.BaseCompany;
import org.tinymediamanager.scraper.tmdb.entities.BaseKeyword;
import org.tinymediamanager.scraper.tmdb.entities.BaseMovie;
import org.tinymediamanager.scraper.tmdb.entities.CastMember;
import org.tinymediamanager.scraper.tmdb.entities.Collection;
import org.tinymediamanager.scraper.tmdb.entities.CollectionResultsPage;
import org.tinymediamanager.scraper.tmdb.entities.Country;
import org.tinymediamanager.scraper.tmdb.entities.CrewMember;
import org.tinymediamanager.scraper.tmdb.entities.FindResults;
import org.tinymediamanager.scraper.tmdb.entities.Genre;
import org.tinymediamanager.scraper.tmdb.entities.Movie;
import org.tinymediamanager.scraper.tmdb.entities.MovieResultsPage;
import org.tinymediamanager.scraper.tmdb.entities.ReleaseDate;
import org.tinymediamanager.scraper.tmdb.entities.ReleaseDatesResult;
import org.tinymediamanager.scraper.tmdb.entities.SpokenLanguage;
import org.tinymediamanager.scraper.tmdb.enumerations.AppendToResponseItem;
import org.tinymediamanager.scraper.tmdb.enumerations.ExternalSource;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import retrofit2.Response;

public class TmdbMovieMetadataProvider
extends TmdbMetadataProvider
implements IMovieMetadataProvider,
IMovieSetMetadataProvider,
IMovieTmdbMetadataProvider,
IMovieImdbMetadataProvider,
IRatingProvider,
IMediaIdProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbMovieMetadataProvider.class);

    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = super.createMediaProviderInfo();
        info.getConfig().addBoolean("includeAdult", false);
        info.getConfig().addBoolean("scrapeLanguageNames", true);
        info.getConfig().addBoolean("titleFallback", false);
        info.getConfig().addSelect("titleFallbackLanguage", PT, "en-US");
        info.getConfig().addBoolean("localReleaseDate", true);
        info.getConfig().addBoolean("includePremiereDate", true);
        info.getConfig().load();
        return info;
    }

    @Override
    protected String getSubId() {
        return "movie";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public SortedSet<MediaSearchResult> search(MovieSearchAndScrapeOptions options) throws ScrapeException {
        Response httpResponse;
        LOGGER.debug("search(): {}", (Object)options);
        this.initAPI();
        Exception savedException = null;
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        String searchString = "";
        if (StringUtils.isNotEmpty((CharSequence)options.getSearchQuery())) {
            searchString = Utils.removeSortableName(options.getSearchQuery());
        }
        searchString = MetadataUtil.removeNonSearchCharacters(searchString);
        String imdbId = options.getImdbId();
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            imdbId = "";
        }
        if (MediaIdUtil.isValidImdbId(searchString)) {
            imdbId = searchString;
        }
        int tmdbId = options.getTmdbId();
        boolean adult = this.getProviderInfo().getConfig().getValueAsBool("includeAdult");
        String language = TmdbMovieMetadataProvider.getRequestLanguage(options.getLanguage());
        LOGGER.debug("========= BEGIN TMDB Scraper Search for: {}", (Object)searchString);
        if (tmdbId != 0) {
            LOGGER.debug("found TMDB ID {} - getting direct", (Object)tmdbId);
            try {
                httpResponse = this.api.moviesService().summary(tmdbId, language, new AppendToResponse(AppendToResponseItem.TRANSLATIONS)).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                Movie movie = (Movie)httpResponse.body();
                this.injectTranslations(Locale.forLanguageTag(language), movie);
                MediaSearchResult result = this.morphMovieToSearchResult(movie, options);
                results.add(result);
                LOGGER.debug("found {} results with TMDB id", (Object)results.size());
            }
            catch (Exception e) {
                LOGGER.debug("problem getting data from tmdb: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (results.isEmpty() && StringUtils.isNotEmpty((CharSequence)imdbId)) {
            LOGGER.debug("found IMDB ID {} - getting direct", (Object)imdbId);
            try {
                httpResponse = this.api.findService().find(imdbId, ExternalSource.IMDB_ID, language).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                for (BaseMovie movie : ListUtils.nullSafe(((FindResults)httpResponse.body()).movie_results)) {
                    results.add(this.morphMovieToSearchResult(movie, options));
                }
                LOGGER.debug("found {} results with IMDB id", (Object)results.size());
            }
            catch (Exception e) {
                LOGGER.debug("problem getting data from tmdb: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (results.isEmpty()) {
            try {
                Response httpResponse2;
                int page = 1;
                int maxPage = 1;
                do {
                    if (!(httpResponse2 = this.api.searchService().movie(searchString, page, language, null, adult, null, null).execute()).isSuccessful() || httpResponse2.body() == null) {
                        throw new HttpException(httpResponse2.code(), httpResponse2.message());
                    }
                    for (BaseMovie movie : ListUtils.nullSafe(((MovieResultsPage)httpResponse2.body()).results)) {
                        results.add(this.morphMovieToSearchResult(movie, options));
                    }
                } while (++page <= (maxPage = ((MovieResultsPage)httpResponse2.body()).total_pages.intValue()));
                LOGGER.debug("found {} results with search string", (Object)results.size());
            }
            catch (Exception e) {
                LOGGER.debug("problem getting data from tmdb: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (results.isEmpty()) {
            searchString = searchString.replaceFirst("\\s\\d{4}$", "");
            try {
                MovieResultsPage resultsPage = (MovieResultsPage)this.api.searchService().movie(searchString, 1, language, null, adult, null, null).execute().body();
                if (resultsPage != null && resultsPage.results != null) {
                    for (BaseMovie movie : resultsPage.results) {
                        results.add(this.morphMovieToSearchResult(movie, options));
                    }
                }
                LOGGER.debug("found {} results with search string without year", (Object)results.size());
            }
            catch (Exception e) {
                LOGGER.debug("problem getting data from tmdb: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (results.isEmpty() && savedException != null) {
            throw new ScrapeException(savedException);
        }
        return results;
    }

    @Override
    public List<MediaSearchResult> search(MovieSetSearchAndScrapeOptions options) throws ScrapeException {
        ArrayList<MediaSearchResult> movieSetsFound;
        block6: {
            LOGGER.debug("search(): {}", (Object)options);
            this.initAPI();
            movieSetsFound = new ArrayList<MediaSearchResult>();
            String searchString = "";
            if (StringUtils.isNotEmpty((CharSequence)options.getSearchQuery())) {
                searchString = Utils.removeSortableName(options.getSearchQuery());
            }
            if (StringUtils.isEmpty((CharSequence)searchString)) {
                LOGGER.debug("TMDB Scraper: empty searchString");
                return movieSetsFound;
            }
            String language = TmdbMovieMetadataProvider.getRequestLanguage(options.getLanguage());
            try {
                CollectionResultsPage resultsPage = (CollectionResultsPage)this.api.searchService().collection(searchString, 1, language).execute().body();
                if (resultsPage == null) break block6;
                for (BaseCollection collection : ListUtils.nullSafe(resultsPage.results)) {
                    MediaSearchResult searchResult = new MediaSearchResult(this.getId(), MediaType.MOVIE_SET);
                    searchResult.setId(Integer.toString(collection.id));
                    searchResult.setTitle(collection.name);
                    searchResult.setPosterUrl(this.artworkBaseUrl + "w342" + collection.poster_path);
                    searchResult.calculateScore(options);
                    if (!((double)searchResult.getScore() < 0.5 && Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("titleFallback")) && this.verifyMovieSetTitleLanguage(movieSetsFound, resultsPage, options))) {
                        movieSetsFound.add(searchResult);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.debug("failed to search: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
        }
        LOGGER.debug("found {} results ", (Object)movieSetsFound.size());
        return movieSetsFound;
    }

    @Override
    public MediaMetadata getMetadata(MovieSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        Exception savedException = null;
        int tmdbId = options.getTmdbId();
        String imdbId = options.getImdbId();
        if (tmdbId == 0 && !MediaIdUtil.isValidImdbId(imdbId)) {
            LOGGER.debug("not possible to scrape from TMDB - no tmdbId/imdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        String language = TmdbMovieMetadataProvider.getRequestLanguage(options.getLanguage());
        Movie movie = null;
        if (tmdbId == 0 && MediaIdUtil.isValidImdbId(imdbId)) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, options.getMediaType(), imdbId);
            }
            catch (Exception e) {
                LOGGER.debug("problem getting tmdbId from imdbId: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (tmdbId > 0) {
            try {
                Response httpResponse = this.api.moviesService().summary(tmdbId, language, new AppendToResponse(AppendToResponseItem.CREDITS, AppendToResponseItem.KEYWORDS, AppendToResponseItem.RELEASE_DATES, AppendToResponseItem.TRANSLATIONS, AppendToResponseItem.EXTERNAL_IDS)).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                movie = (Movie)httpResponse.body();
                this.injectTranslations(Locale.forLanguageTag(language), movie);
            }
            catch (Exception e) {
                LOGGER.debug("problem getting data from tmdb: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (movie == null && savedException != null) {
            throw new ScrapeException(savedException);
        }
        if (movie == null) {
            LOGGER.debug("no result found");
            throw new NothingFoundException();
        }
        MediaMetadata md = this.morphMovieToMediaMetadata(movie, options);
        return md;
    }

    @Override
    public MediaMetadata getMetadata(MovieSetSearchAndScrapeOptions options) throws ScrapeException {
        MediaArtwork ma;
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        int tmdbId = options.getIdAsInt("tmdbSet") > 0 ? options.getIdAsInt("tmdbSet") : options.getTmdbId();
        if (tmdbId == 0) {
            LOGGER.debug("not possible to scrape from TMDB - no tmdbId found");
            throw new MissingIdException(new String[]{"tmdbSet"});
        }
        String language = TmdbMovieMetadataProvider.getRequestLanguage(options.getLanguage());
        Collection collection = null;
        Collection collectionEnglish = null;
        try {
            Response collectionResponse = this.api.collectionService().summary(tmdbId, language).execute();
            if (!collectionResponse.isSuccessful()) {
                throw new HttpException(collectionResponse.code(), collectionResponse.message());
            }
            collection = (Collection)collectionResponse.body();
            if (language.startsWith("en")) {
                collectionEnglish = collection;
            } else {
                try {
                    Response response = this.api.collectionService().summary(tmdbId, "en").execute();
                    if (response.isSuccessful()) {
                        collectionEnglish = (Collection)response.body();
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("problem getting english collection data from tmdb - '{}'", (Object)e.getMessage());
                }
            }
            if (collection != null && StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{collection.name, collection.overview}) && this.getProviderInfo().getConfig().getValueAsBool("titleFallback")) {
                String fallbackLang = MediaLanguages.get(this.getProviderInfo().getConfig().getValue("titleFallbackLanguage")).name().replace("_", "-");
                Response collectionFallbackResponse = this.api.collectionService().summary(tmdbId, fallbackLang).execute();
                if (collectionFallbackResponse.isSuccessful()) {
                    Collection collectionInFallbackLanguage = (Collection)collectionFallbackResponse.body();
                    if (StringUtils.isBlank((CharSequence)collection.name) && StringUtils.isNotBlank((CharSequence)collectionInFallbackLanguage.name)) {
                        collection.name = collectionInFallbackLanguage.name;
                    }
                    if (StringUtils.isBlank((CharSequence)collection.overview) && StringUtils.isNotBlank((CharSequence)collectionInFallbackLanguage.overview)) {
                        collection.overview = collectionInFallbackLanguage.overview;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (collection == null) {
            throw new NothingFoundException();
        }
        md.setId("tmdbSet", collection.id);
        md.setTitle(collection.name);
        if (collectionEnglish != null) {
            md.setEnglishTitle(collectionEnglish.name);
        }
        md.setPlot(collection.overview);
        if (StringUtils.isNotBlank((CharSequence)collection.poster_path)) {
            ma = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.POSTER);
            ma.setPreviewUrl(this.artworkBaseUrl + "w185" + collection.poster_path);
            ma.setOriginalUrl(this.artworkBaseUrl + "original" + collection.poster_path);
            ma.setLanguage(options.getLanguage().getLanguage());
            ma.setTmdbId(tmdbId);
            ma.addImageSize(0, 0, this.artworkBaseUrl + "original" + collection.poster_path, 0);
            md.addMediaArt(ma);
        }
        if (StringUtils.isNotBlank((CharSequence)collection.backdrop_path)) {
            ma = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
            ma.setPreviewUrl(this.artworkBaseUrl + "w300" + collection.backdrop_path);
            ma.setOriginalUrl(this.artworkBaseUrl + "original" + collection.backdrop_path);
            ma.setLanguage(options.getLanguage().getLanguage());
            ma.setTmdbId(tmdbId);
            ma.addImageSize(0, 0, this.artworkBaseUrl + "original" + collection.backdrop_path, 0);
            md.addMediaArt(ma);
        }
        for (BaseMovie part : ListUtils.nullSafe(collection.parts)) {
            MediaArtwork ma2;
            MediaMetadata mdSubItem;
            if (part.release_date == null) continue;
            try {
                MovieSearchAndScrapeOptions movieSearchAndScrapeOptions = new MovieSearchAndScrapeOptions();
                movieSearchAndScrapeOptions.setTmdbId(MetadataUtil.unboxInteger(part.id));
                movieSearchAndScrapeOptions.setLanguage(options.getLanguage());
                movieSearchAndScrapeOptions.setCertificationCountry(options.getCertificationCountry());
                movieSearchAndScrapeOptions.setReleaseDateCountry(options.getReleaseDateCountry());
                mdSubItem = this.getMetadata(movieSearchAndScrapeOptions);
                if (StringUtils.isNotBlank((CharSequence)part.poster_path)) {
                    ma2 = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.POSTER);
                    ma2.setPreviewUrl(this.artworkBaseUrl + "w185" + part.poster_path);
                    ma2.setOriginalUrl(this.artworkBaseUrl + "original" + part.poster_path);
                    ma2.setLanguage(options.getLanguage().getLanguage());
                    ma2.setTmdbId(MetadataUtil.unboxInteger(part.id));
                    ma2.addImageSize(0, 0, this.artworkBaseUrl + "original" + part.poster_path, 0);
                    mdSubItem.addMediaArt(ma2);
                }
                if (StringUtils.isNotBlank((CharSequence)part.backdrop_path)) {
                    ma2 = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
                    ma2.setPreviewUrl(this.artworkBaseUrl + "w300" + part.backdrop_path);
                    ma2.setOriginalUrl(this.artworkBaseUrl + "original" + part.backdrop_path);
                    ma2.setLanguage(options.getLanguage().getLanguage());
                    ma2.setTmdbId(MetadataUtil.unboxInteger(part.id));
                    ma2.addImageSize(0, 0, this.artworkBaseUrl + "original" + part.backdrop_path, 0);
                    mdSubItem.addMediaArt(ma2);
                }
                md.addSubItem(mdSubItem);
            }
            catch (Exception e) {
                LOGGER.debug("could not get metadata for movie set movie - '{}'", (Object)e.getMessage());
                mdSubItem = new MediaMetadata(this.getId());
                mdSubItem.setScrapeOptions(options);
                mdSubItem.setId(this.getId(), part.id);
                mdSubItem.setTitle(part.title);
                mdSubItem.setOriginalTitle(part.original_title);
                mdSubItem.setPlot(part.overview);
                mdSubItem.setReleaseDate(part.release_date);
                if (part.release_date != null) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(part.release_date);
                    mdSubItem.setYear(calendar.get(1));
                }
                if (part.vote_average != null) {
                    mdSubItem.setRatings(Collections.singletonList(new MediaRating(this.getId(), part.vote_average.floatValue(), MetadataUtil.unboxInteger(part.vote_count))));
                }
                for (Genre genre : ListUtils.nullSafe(part.genres)) {
                    mdSubItem.addGenre(TmdbMovieMetadataProvider.getTmmGenre(genre));
                }
                if (StringUtils.isNotBlank((CharSequence)part.poster_path)) {
                    ma2 = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.POSTER);
                    ma2.setPreviewUrl(this.artworkBaseUrl + "w185" + part.poster_path);
                    ma2.setOriginalUrl(this.artworkBaseUrl + "original" + part.poster_path);
                    ma2.setLanguage(options.getLanguage().getLanguage());
                    ma2.setTmdbId(MetadataUtil.unboxInteger(part.id));
                    ma2.addImageSize(0, 0, this.artworkBaseUrl + "original" + part.poster_path, 0);
                    mdSubItem.addMediaArt(ma2);
                }
                if (StringUtils.isNotBlank((CharSequence)part.backdrop_path)) {
                    ma2 = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
                    ma2.setPreviewUrl(this.artworkBaseUrl + "w300" + part.backdrop_path);
                    ma2.setOriginalUrl(this.artworkBaseUrl + "original" + part.backdrop_path);
                    ma2.setLanguage(options.getLanguage().getLanguage());
                    ma2.setTmdbId(MetadataUtil.unboxInteger(part.id));
                    ma2.addImageSize(0, 0, this.artworkBaseUrl + "original" + part.backdrop_path, 0);
                    mdSubItem.addMediaArt(ma2);
                }
                md.addSubItem(mdSubItem);
            }
        }
        return md;
    }

    @Override
    public List<MediaRating> getRatings(Map<String, Object> ids, MediaType mediaType) throws ScrapeException {
        if (mediaType != MediaType.MOVIE) {
            return Collections.emptyList();
        }
        LOGGER.debug("getRatings(): {}", ids);
        this.initAPI();
        int tmdbId = MediaIdUtil.getIdAsInt(ids, "tmdb");
        String imdbId = MediaIdUtil.getIdAsString(ids, "imdb");
        if (tmdbId == 0 && !MediaIdUtil.isValidImdbId(imdbId)) {
            LOGGER.debug("not possible to scrape from TMDB - no tmdbId/imdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        Movie movie = null;
        if (tmdbId == 0 && MediaIdUtil.isValidImdbId(imdbId)) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, MediaType.MOVIE, imdbId);
            }
            catch (Exception e) {
                LOGGER.debug("problem getting tmdbId from imdbId: {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0) {
            LOGGER.debug("not possible to scrape from TMDB - no tmdbId/imdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        try {
            Response httpResponse = this.api.moviesService().summary(tmdbId, "en", null).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            movie = (Movie)httpResponse.body();
        }
        catch (Exception e) {
            LOGGER.debug("problem getting data from tmdb: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (movie == null) {
            throw new NothingFoundException();
        }
        MediaRating rating = new MediaRating("tmdb");
        rating.setRating(movie.vote_average.floatValue());
        rating.setVotes(movie.vote_count);
        rating.setMaxValue(10);
        return Collections.singletonList(rating);
    }

    @Override
    public Map<String, Object> getMediaIds(Map<String, Object> ids, MediaType mediaType) throws ScrapeException {
        Movie movie;
        if (mediaType != MediaType.MOVIE) {
            return Collections.emptyMap();
        }
        LOGGER.debug("getMediaIds(): {}", ids);
        this.initAPI();
        int tmdbId = MediaIdUtil.getIdAsInt(ids, "tmdb");
        String imdbId = MediaIdUtil.getIdAsString(ids, "imdb");
        if (tmdbId == 0 && !MediaIdUtil.isValidImdbId(imdbId)) {
            LOGGER.debug("not possible to scrape from TMDB - no tmdbId/imdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        HashMap<String, Object> scrapedIds = new HashMap<String, Object>();
        if (tmdbId == 0 && MediaIdUtil.isValidImdbId(imdbId)) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, MediaType.MOVIE, imdbId);
            }
            catch (Exception e) {
                LOGGER.debug("problem getting tmdbId from imdbId: {}", (Object)e.getMessage());
            }
            scrapedIds.put("imdb", imdbId);
            if (tmdbId > 0) {
                scrapedIds.put("tmdb", tmdbId);
            }
            return scrapedIds;
        }
        try {
            Response httpResponse = this.api.moviesService().summary(tmdbId, "en", new AppendToResponse(AppendToResponseItem.EXTERNAL_IDS)).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            movie = (Movie)httpResponse.body();
        }
        catch (Exception e) {
            LOGGER.debug("problem getting data from tmdb: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (movie == null) {
            throw new NothingFoundException();
        }
        scrapedIds.put("tmdb", movie.id);
        this.parseExternalIDs(movie.external_ids).forEach(scrapedIds::put);
        return scrapedIds;
    }

    private void injectTranslations(Locale language, Movie movie) {
        if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("titleFallback"))) {
            Locale fallbackLanguage = Locale.forLanguageTag(this.getProviderInfo().getConfig().getValue("titleFallbackLanguage"));
            String[] val = this.getValuesFromTranslation(movie.translations, language);
            if (StringUtils.isBlank((CharSequence)val[0]) && language.getLanguage().equals(movie.original_language)) {
                val[0] = movie.original_title;
            }
            String[] temp = this.getValuesFromTranslation(movie.translations, fallbackLanguage);
            if (StringUtils.isBlank((CharSequence)val[0])) {
                val[0] = temp[0];
            }
            if (StringUtils.isBlank((CharSequence)val[1])) {
                val[1] = temp[1];
            }
            if (StringUtils.isNotBlank((CharSequence)val[0])) {
                movie.title = val[0];
            }
            if (StringUtils.isNotBlank((CharSequence)val[1])) {
                movie.overview = val[1];
            }
        }
    }

    private MediaSearchResult morphMovieToSearchResult(BaseMovie movie, MovieSearchAndScrapeOptions query) {
        MediaSearchResult searchResult = new MediaSearchResult(this.getProviderInfo().getId(), MediaType.MOVIE);
        searchResult.setId(Integer.toString(movie.id));
        searchResult.setTitle(movie.title);
        searchResult.setOverview(movie.overview);
        searchResult.setOriginalTitle(movie.original_title);
        searchResult.setOriginalLanguage(movie.original_language);
        if (movie.poster_path != null && !movie.poster_path.isEmpty()) {
            searchResult.setPosterUrl(this.artworkBaseUrl + "w342" + movie.poster_path);
        }
        if (movie.release_date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(movie.release_date);
            searchResult.setYear(calendar.get(1));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getImdbId()) && query.getImdbId().equals(searchResult.getIMDBId()) || String.valueOf(query.getTmdbId()).equals(searchResult.getId())) {
            LOGGER.debug("perfect match by ID - set score to 1");
            searchResult.setScore(1.0f);
        } else {
            searchResult.calculateScore(query);
        }
        return searchResult;
    }

    private MediaMetadata morphMovieToMediaMetadata(Movie movie, MovieSearchAndScrapeOptions options) {
        MediaMetadata md = new MediaMetadata(this.getProviderInfo().getId());
        md.setScrapeOptions(options);
        md.setId(this.getProviderInfo().getId(), movie.id);
        md.setTitle(movie.title);
        md.setOriginalTitle(movie.original_title);
        String englishTitle = this.getValuesFromTranslation(movie.translations, MediaLanguages.en.toLocale())[0];
        if (StringUtils.isBlank((CharSequence)englishTitle) && "en".equals(movie.original_language)) {
            englishTitle = movie.original_title;
        }
        md.setEnglishTitle(englishTitle);
        md.setPlot(movie.overview);
        md.setTagline(movie.tagline);
        md.setRuntime(movie.runtime);
        MediaRating rating = new MediaRating("tmdb");
        rating.setRating(movie.vote_average.floatValue());
        rating.setVotes(movie.vote_count);
        rating.setMaxValue(10);
        md.addRating(rating);
        if (StringUtils.isNotBlank((CharSequence)movie.poster_path)) {
            Iterator<Object> ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.POSTER);
            ((MediaArtwork)((Object)ma)).setPreviewUrl(this.artworkBaseUrl + "w342" + movie.poster_path);
            ((MediaArtwork)((Object)ma)).setOriginalUrl(this.artworkBaseUrl + "original" + movie.poster_path);
            ((MediaArtwork)((Object)ma)).setLanguage(options.getLanguage().getLanguage());
            ((MediaArtwork)((Object)ma)).setTmdbId(movie.id);
            ((MediaArtwork)((Object)ma)).addImageSize(0, 0, this.artworkBaseUrl + "original" + movie.poster_path, 0);
            md.addMediaArt((MediaArtwork)((Object)ma));
        }
        for (SpokenLanguage lang : ListUtils.nullSafe(movie.spoken_languages)) {
            if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("scrapeLanguageNames"))) {
                md.addSpokenLanguage(LanguageUtils.getLocalizedLanguageNameFromLocalizedString(options.getLanguage().toLocale(), lang.name, lang.iso_639_1));
                continue;
            }
            md.addSpokenLanguage(lang.iso_639_1);
        }
        for (Country country : ListUtils.nullSafe(movie.production_countries)) {
            if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("scrapeLanguageNames"))) {
                md.addCountry(LanguageUtils.getLocalizedCountryForLanguage(options.getLanguage().toLocale(), country.name, country.iso_3166_1));
                continue;
            }
            md.addCountry(country.iso_3166_1);
        }
        this.parseExternalIDs(movie.external_ids).forEach(md::setId);
        for (BaseCompany company : ListUtils.nullSafe(movie.production_companies)) {
            md.addProductionCompany(company.name.strip());
        }
        if (movie.release_dates != null) {
            CountryCode countryCode = options.getCertificationCountry();
            String releaseDateCountry = options.getReleaseDateCountry();
            for (ReleaseDatesResult countries : ListUtils.nullSafe(movie.release_dates.results)) {
                if (StringUtils.isBlank((CharSequence)countries.iso_3166_1)) continue;
                if (countryCode != null && countries.iso_3166_1.equalsIgnoreCase(countryCode.getAlpha2())) {
                    for (ReleaseDate countryReleaseDate : ListUtils.nullSafe(countries.release_dates)) {
                        if (!StringUtils.isNotBlank((CharSequence)countryReleaseDate.certification)) continue;
                        md.addCertification(MediaCertification.getCertification(countries.iso_3166_1, countryReleaseDate.certification));
                    }
                }
                if (!Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("localReleaseDate")) || !StringUtils.isNotBlank((CharSequence)releaseDateCountry) || !releaseDateCountry.equalsIgnoreCase(countries.iso_3166_1)) continue;
                for (ReleaseDate countryReleaseDate : ListUtils.nullSafe(countries.release_dates)) {
                    int type;
                    if (countryReleaseDate.release_date == null || md.getReleaseDate() != null && countryReleaseDate.release_date.after(md.getReleaseDate()) || (type = MetadataUtil.unboxInteger(countryReleaseDate.type)) <= 1 && (type != 1 || !Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("includePremiereDate")))) continue;
                    md.setReleaseDate(countryReleaseDate.release_date);
                }
            }
        }
        if (md.getReleaseDate() == null) {
            md.setReleaseDate(movie.release_date);
        }
        if (movie.release_date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(movie.release_date);
            md.setYear(calendar.get(1));
        }
        if (movie.credits != null) {
            Person cm;
            for (CastMember castMember : ListUtils.nullSafe(movie.credits.cast)) {
                cm = new Person(Person.Type.ACTOR);
                cm.setId(this.getProviderInfo().getId(), castMember.id);
                cm.setName(castMember.name);
                cm.setRole(castMember.character);
                if (StringUtils.isNotBlank((CharSequence)castMember.profile_path)) {
                    cm.setThumbUrl(this.artworkBaseUrl + "h632" + castMember.profile_path);
                }
                if (castMember.id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + castMember.id);
                }
                md.addCastMember(cm);
            }
            for (CrewMember crewMember : ListUtils.nullSafe(movie.credits.crew)) {
                cm = new Person();
                if ("Director".equals(crewMember.job)) {
                    cm.setType(Person.Type.DIRECTOR);
                } else if ("Writing".equals(crewMember.department) && Strings.CS.containsAny((CharSequence)crewMember.job, new CharSequence[]{"Screenplay", "Writer", "Story"})) {
                    cm.setType(Person.Type.WRITER);
                } else if ("Production".equals(crewMember.department) && Strings.CS.containsAny((CharSequence)crewMember.job, new CharSequence[]{"Producer"})) {
                    cm.setType(Person.Type.PRODUCER);
                } else if ("Editing".equals(crewMember.department) && Strings.CS.containsAny((CharSequence)crewMember.job, new CharSequence[]{"Editor"})) {
                    cm.setType(Person.Type.EDITOR);
                } else if ("Sound".equals(crewMember.department) && Strings.CS.containsAny((CharSequence)crewMember.job, new CharSequence[]{"Original Music Composer"})) {
                    cm.setType(Person.Type.COMPOSER);
                } else {
                    if (!"Camera".equals(crewMember.department) || !Strings.CS.containsAny((CharSequence)crewMember.job, new CharSequence[]{"Director of Photography"})) continue;
                    cm.setType(Person.Type.CAMERA);
                }
                cm.setRole(crewMember.job);
                cm.setId(this.getProviderInfo().getId(), crewMember.id);
                cm.setName(crewMember.name);
                if (StringUtils.isNotBlank((CharSequence)crewMember.profile_path)) {
                    cm.setThumbUrl(this.artworkBaseUrl + "h632" + crewMember.profile_path);
                }
                if (crewMember.id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + crewMember.id);
                }
                md.addCastMember(cm);
            }
        }
        for (Genre genre : ListUtils.nullSafe(movie.genres)) {
            md.addGenre(TmdbMetadataProvider.getTmmGenre(genre));
        }
        if (Boolean.TRUE.equals(movie.adult)) {
            md.addGenre(MediaGenres.EROTIC);
        }
        if (movie.belongs_to_collection != null) {
            md.setId("tmdbSet", movie.belongs_to_collection.id);
            md.setCollectionName(movie.belongs_to_collection.name);
        }
        if (movie.keywords != null) {
            for (BaseKeyword kw : ListUtils.nullSafe(movie.keywords.keywords)) {
                md.addTag(kw.name);
            }
        }
        return md;
    }

    private boolean verifyMovieSetTitleLanguage(List<MediaSearchResult> movieSetsFound, CollectionResultsPage original, MovieSetSearchAndScrapeOptions query) throws Exception {
        String lang = MediaLanguages.get(this.getProviderInfo().getConfig().getValue("titleFallbackLanguage")).name().replace("_", "-");
        CollectionResultsPage fallBackResultsPage = (CollectionResultsPage)this.api.searchService().collection(query.getSearchQuery(), 1, lang).execute().body();
        if (fallBackResultsPage != null && original.results != null && fallBackResultsPage.results != null) {
            movieSetsFound.clear();
            for (int i = 0; i < original.results.size(); ++i) {
                BaseCollection originalCollection = (BaseCollection)original.results.get(i);
                BaseCollection fallbackCollection = (BaseCollection)fallBackResultsPage.results.get(i);
                MediaSearchResult searchResult = new MediaSearchResult(this.getId(), MediaType.MOVIE_SET);
                searchResult.setId(Integer.toString(originalCollection.id));
                if (MetadataUtil.calculateScore(query.getSearchQuery(), originalCollection.name) >= MetadataUtil.calculateScore(query.getSearchQuery(), fallbackCollection.name)) {
                    searchResult.setTitle(originalCollection.name);
                    searchResult.setPosterUrl(this.artworkBaseUrl + "w342" + originalCollection.poster_path);
                    searchResult.calculateScore(query);
                } else {
                    searchResult.setTitle(fallbackCollection.name);
                    searchResult.setPosterUrl(this.artworkBaseUrl + "w342" + fallbackCollection.poster_path);
                    searchResult.calculateScore(query);
                }
                movieSetsFound.add(searchResult);
            }
            return true;
        }
        return false;
    }
}

