/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.ofdb;

import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.OnDiskCachedUrl;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;
import org.tinymediamanager.scraper.interfaces.IMovieImdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.ofdb.OfdbMetadataProvider;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.StrgUtils;

public class OfdbMovieMetadataProvider
extends OfdbMetadataProvider
implements IMovieMetadataProvider,
IMovieImdbMetadataProvider,
IMovieArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfdbMovieMetadataProvider.class);

    @Override
    protected String getSubId() {
        return "movie";
    }

    @Override
    public MediaMetadata getMetadata(MovieSearchAndScrapeOptions options) throws ScrapeException {
        OnDiskCachedUrl u;
        Object imgUrl;
        Element el;
        LOGGER.debug("getMetadata() {}", (Object)options);
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        Object detailUrl = "";
        if (options.getSearchResult() != null) {
            detailUrl = options.getSearchResult().getUrl();
        }
        String ofdbId = options.getIdAsString(this.getId());
        if (((String)detailUrl).isBlank() && StringUtils.isNotBlank((CharSequence)ofdbId)) {
            try {
                detailUrl = this.getApiKey() + "film/" + ofdbId;
            }
            catch (Exception e) {
                throw new ScrapeException(e);
            }
        }
        if (((String)detailUrl).isBlank() && StringUtils.isNotBlank((CharSequence)options.getImdbId())) {
            try {
                SortedSet<MediaSearchResult> results = this.search(options);
                if (!results.isEmpty()) {
                    options.setSearchResult(results.first());
                    detailUrl = options.getSearchResult().getUrl();
                }
            }
            catch (Exception e) {
                LOGGER.debug("failed IMDB search: {}", (Object)e.getMessage());
            }
        }
        if (StringUtils.isBlank((CharSequence)detailUrl)) {
            LOGGER.debug("We did not get any useful movie url");
            throw new MissingIdException("imdb", this.getProviderInfo().getId());
        }
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        if (StringUtils.isBlank((CharSequence)ofdbId)) {
            ofdbId = StrgUtils.substr((String)detailUrl, "film\\/(\\d+),");
        }
        md.setId(this.getId(), ofdbId);
        Document doc = null;
        LOGGER.trace("get details page: {}", detailUrl);
        try {
            OnDiskCachedUrl u2 = new OnDiskCachedUrl((String)detailUrl, 1, TimeUnit.DAYS);
            doc = Jsoup.parse((InputStream)u2.getInputStream(), (String)"UTF-8", (String)"");
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.debug("could not fetch detail url: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (doc.getAllElements().size() < 10) {
            throw new ScrapeException(new Exception("we did not receive a valid web page"));
        }
        Elements els = doc.getElementsByAttributeValueContaining("href", "imdb.com");
        if (!els.isEmpty()) {
            md.setId("imdb", "tt" + StrgUtils.substr(els.first().attr("href"), "title/tt(\\d+)"));
        }
        if (!(els = doc.getElementsByAttributeValue("itemprop", "name")).isEmpty()) {
            String[] ty = this.parseTitle(els.first().text());
            md.setTitle(StrgUtils.removeCommonSortableName(ty[0]));
            md.setYear(MetadataUtil.parseInt(ty[1], 0));
        }
        if ((el = doc.getElementsByAttributeValue("itemprop", "image").first()) != null && !((String)(imgUrl = el.attr("src").replace("./", ""))).isBlank()) {
            imgUrl = this.getApiKey() + (String)imgUrl;
            MediaArtwork ma = new MediaArtwork("ofdb", MediaArtwork.MediaArtworkType.POSTER);
            int width = MetadataUtil.parseInt(StrgUtils.substr((String)imgUrl, "\\.(\\d+)px/"), 370);
            ma.setOriginalUrl(((String)imgUrl).replace("." + width + "px", ""));
            ma.addImageSize(0, 0, ((String)imgUrl).replace("." + width + "px", ""), MediaArtwork.PosterSizes.BIG.getOrder());
            md.addMediaArt(ma);
        }
        if ((el = doc.getElementById("HeaderFilmBild")) != null) {
            String style = el.attr("style").replace("./", "");
            String imgUrl2 = this.getApiKey() + StrgUtils.substr(style, "\\((.*?)\\)");
            MediaArtwork ma = new MediaArtwork("ofdb", MediaArtwork.MediaArtworkType.BACKGROUND);
            int width = MetadataUtil.parseInt(StrgUtils.substr(imgUrl2, "\\.(\\d+)px/"), 870);
            ma.setOriginalUrl(imgUrl2.replace("." + width + "px", ""));
            ma.addImageSize(0, 0, imgUrl2.replace("." + width + "px", ""), MediaArtwork.FanartSizes.LARGE.getOrder());
            md.addMediaArt(ma);
        }
        els = doc.getElementsByAttributeValue("itemprop", "genre");
        for (Element genre : els) {
            md.addGenre(this.getTmmGenre(genre.text()));
        }
        els = doc.getElementsByAttributeValue("itemprop", "countryOfOrigin");
        for (Element cntr : els) {
            md.addCountry(cntr.text());
        }
        Element dl = doc.getElementsByClass("dl-horizontal").first();
        String lastTagName = "";
        String key = "";
        String val = "";
        for (Element e : dl.children()) {
            if (!e.tagName().equals(lastTagName)) {
                if (e.tagName().equalsIgnoreCase("dt")) {
                    key = e.text();
                } else if (e.tagName().equalsIgnoreCase("dd")) {
                    val = e.text();
                    LOGGER.trace(" " + key + " | " + val);
                    if (key.equals("Originaltitel:")) {
                        md.setOriginalTitle(val);
                    } else if (key.equals("Erscheinungsjahr:") && md.getYear() == 0) {
                        md.setYear(MetadataUtil.parseInt(val, 0));
                    }
                }
            }
            lastTagName = e.tagName();
        }
        try {
            String r;
            MediaRating rating = new MediaRating("ofdb");
            el = doc.getElementsByAttributeValue("itemprop", "ratingValue").first();
            if (el != null && !(r = el.text()).isEmpty()) {
                rating.setRating(Float.parseFloat(r));
                rating.setMaxValue(10);
            }
            if ((el = doc.getElementsByAttributeValue("itemprop", "ratingCount").first()) != null) {
                r = el.attr("content");
                rating.setVotes(MetadataUtil.parseInt(r, 0));
            }
            md.addRating(rating);
        }
        catch (Exception e) {
            LOGGER.trace("could not parse rating: {}", (Object)e.getMessage());
        }
        el = doc.getElementsByAttributeValue("itemprop", "description").first();
        if (el != null) {
            md.setPlot(el.text());
        }
        LOGGER.trace("parse plot");
        el = doc.getElementsByAttributeValueMatching("href", "/plot/").first();
        if (el != null) {
            try {
                String plotUrl = el.attr("href");
                u = new OnDiskCachedUrl(plotUrl, 1, TimeUnit.DAYS);
                Document plot = Jsoup.parse((InputStream)u.getInputStream(), (String)"UTF-8", (String)"");
                el = plot.getElementsByTag("h4").first();
                Object text = el.text().replace("...", "");
                el = el.nextElementSibling();
                text = (String)text + el.text().replace("... ", "");
                md.setPlot((String)text);
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.debug("failed to get plot page: {}", (Object)e.getMessage());
            }
        }
        doc = null;
        try {
            if (((String)detailUrl).endsWith("/")) {
                detailUrl = ((String)detailUrl).substring(0, ((String)detailUrl).length() - 1);
            }
            String movieDetail = (String)detailUrl + "/details";
            LOGGER.trace("parse movie detail: {}", (Object)movieDetail);
            u = new OnDiskCachedUrl(movieDetail, 1, TimeUnit.DAYS);
            doc = Jsoup.parse((InputStream)u.getInputStream(), (String)"UTF-8", (String)"");
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.debug("failed to get detail page: {}", (Object)e.getMessage());
        }
        el = doc.getElementsByClass("flagline-lg").first();
        if (el != null) {
            el = el.parent();
            Person.Type type = Person.Type.OTHER;
            String crewRole = "";
            for (Element tag : el.children()) {
                if (tag.tagName().equals("h5")) {
                    if (tag.text().contains("Regie")) {
                        type = Person.Type.DIRECTOR;
                        crewRole = "Regie";
                        continue;
                    }
                    if (tag.text().contains("Darsteller") || tag.text().contains("Stimme/Sprecher")) {
                        type = Person.Type.ACTOR;
                        crewRole = "";
                        continue;
                    }
                    if (tag.text().contains("Drehbuchautor")) {
                        type = Person.Type.WRITER;
                        crewRole = "Drehbuchautor";
                        continue;
                    }
                    if (tag.text().contains("Produzent")) {
                        type = Person.Type.PRODUCER;
                        crewRole = "Produzent";
                        continue;
                    }
                    if (tag.text().contains("Komponist")) {
                        type = Person.Type.COMPOSER;
                        crewRole = "Komponist";
                        continue;
                    }
                    if (tag.text().contains("Cutter") || tag.text().contains("Schnitt")) {
                        type = Person.Type.EDITOR;
                        crewRole = "Schnitt";
                        continue;
                    }
                    type = Person.Type.OTHER;
                    continue;
                }
                if (!tag.tagName().equals("div") || !tag.attr("class").contains("row")) continue;
                Person p = new Person(type);
                el = tag.getElementsByTag("h4").first();
                if (el != null) {
                    p.setName(el.text());
                }
                if (!(el = el.parent()).attr("href").equals("#")) {
                    p.setProfileUrl(el.attr("href"));
                    String id = StrgUtils.substr(el.attr("href"), "person/(\\d+),");
                    p.setId("ofdb", id);
                }
                p.setRole(crewRole);
                el = el.nextElementSibling();
                if (el != null) {
                    p.setRole(el.ownText());
                }
                if ((el = tag.getElementsByTag("img").first()) != null && !el.attr("src").contains("platzhalter")) {
                    String imgUrl3 = this.getApiKey() + el.attr("src").replace("./", "");
                    p.setThumbUrl(imgUrl3);
                }
                md.addCastMember(p);
            }
        }
        return md;
    }

    @Override
    public SortedSet<MediaSearchResult> search(MovieSearchAndScrapeOptions options) throws ScrapeException {
        Document doc;
        OnDiskCachedUrl u;
        LOGGER.debug("search(): {}", (Object)options);
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        String searchQuery = options.getSearchQuery();
        String imdb = options.getImdbId();
        Exception savedException = null;
        String ofdbId = options.getIdAsString("ofdb");
        if (ofdbId != null) {
            LOGGER.debug("found ofdbId {} - getting direct", (Object)ofdbId);
            MediaMetadata md = this.getMetadata(options);
            MediaSearchResult msr = new MediaSearchResult("ofdb", MediaType.MOVIE);
            msr.mergeFrom(md);
            msr.setScore(1.0f);
            results.add(msr);
            return results;
        }
        int count = 0;
        Element tbody = null;
        if (StringUtils.isNotEmpty((CharSequence)options.getImdbId())) {
            try {
                LOGGER.debug("search with imdbId: {}", (Object)imdb);
                u = new OnDiskCachedUrl(this.getApiKey() + "suchergebnis/?" + imdb, 1, TimeUnit.DAYS);
                doc = Jsoup.parse((InputStream)u.getInputStream(), (String)"UTF-8", (String)"");
                tbody = doc.getElementById("TabelleBody");
                count = tbody == null ? 0 : tbody.getElementsByTag("tr").size();
                LOGGER.debug("found {} search result", (Object)count);
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.debug("failed to search for imdb Id {}: {}", (Object)imdb, (Object)e.getMessage());
                savedException = e;
            }
        }
        if (count == 0 && StringUtils.isNotBlank((CharSequence)options.getSearchQuery())) {
            try {
                LOGGER.debug("search for: {}", (Object)searchQuery);
                u = new OnDiskCachedUrl(this.getApiKey() + "suchergebnis/?" + URLEncoder.encode(this.cleanSearch(searchQuery), StandardCharsets.UTF_8), 1, TimeUnit.DAYS);
                doc = Jsoup.parse((InputStream)u.getInputStream(), (String)"UTF-8", (String)"");
                tbody = doc.getElementById("TabelleBody");
                count = tbody == null ? 0 : tbody.getElementsByTag("tr").size();
                LOGGER.debug("found {} search results", (Object)count);
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.debug("failed to search for: {} - {}", (Object)searchQuery, (Object)e.getMessage());
                savedException = e;
            }
        }
        if (count == 0 && savedException != null) {
            throw new ScrapeException(savedException);
        }
        if (count == 0) {
            LOGGER.debug("nothing found :(");
            return results;
        }
        for (Element row : tbody.getElementsByTag("tr")) {
            try {
                Elements cols = row.getElementsByTag("td");
                if (cols.size() == 3) {
                    MediaSearchResult sr = new MediaSearchResult("ofdb", MediaType.MOVIE);
                    String url = ((Element)cols.get(1)).getElementsByTag("a").first().attr("href");
                    sr.setUrl(url);
                    String id = StrgUtils.substr(url, "film/(\\d+),");
                    if (id.isBlank()) {
                        LOGGER.debug("ignoring non-movie result: {}", (Object)url);
                        continue;
                    }
                    sr.setId("ofdb", id);
                    String yearText = ((Element)cols.get(2)).text();
                    if (!yearText.isBlank()) {
                        int year = MetadataUtil.parseInt(yearText);
                        sr.setYear(year);
                    }
                    Element span = ((Element)cols.get(1)).getElementsByClass("tooltipster").first();
                    String title = span.text();
                    sr.setTitle(title);
                    String img = span.attr("title");
                    String imgUrl = StrgUtils.substr(img, "src='\\.\\/(.*?)\\'");
                    if (imgUrl != null && !imgUrl.isBlank()) {
                        sr.setPosterUrl(this.getApiKey() + imgUrl);
                    }
                    DecimalFormat defaultFormat = new DecimalFormat();
                    Number score = defaultFormat.parse(((Element)cols.get(0)).text());
                    sr.setScore(score.floatValue() / 100.0f);
                    results.add(sr);
                    continue;
                }
                LOGGER.trace("unexpected columns - {}", (Object)cols);
            }
            catch (Exception e) {
                LOGGER.debug("error parsing movie result: {}", (Object)e.getMessage());
            }
        }
        return results;
    }

    private String[] parseTitle(String title) {
        String[] v = new String[]{"", ""};
        if (title == null) {
            return v;
        }
        Pattern p = Pattern.compile("(.*)\\s+\\(?([0-9]{4})\\)?", 2);
        Matcher m = p.matcher(title);
        if (m.find()) {
            v[0] = m.group(1);
            v[1] = m.group(2);
        } else {
            v[0] = title;
        }
        return v;
    }

    private MediaGenres getTmmGenre(String genre) {
        MediaGenres g = null;
        if (genre.isEmpty()) {
            return g;
        }
        if (genre.equals("Abenteuer")) {
            g = MediaGenres.ADVENTURE;
        } else if (genre.equals("Action")) {
            g = MediaGenres.ACTION;
        } else if (genre.equals("Amateur")) {
            g = MediaGenres.INDIE;
        } else if (genre.equals("Animation")) {
            g = MediaGenres.ANIMATION;
        } else if (genre.equals("Anime")) {
            g = MediaGenres.ANIME;
        } else if (genre.equals("Biographie")) {
            g = MediaGenres.BIOGRAPHY;
        } else if (genre.equals("Dokumentation")) {
            g = MediaGenres.DOCUMENTARY;
        } else if (genre.equals("Drama")) {
            g = MediaGenres.DRAMA;
        } else if (genre.equals("Eastern")) {
            g = MediaGenres.EASTERN;
        } else if (genre.equals("Erotik")) {
            g = MediaGenres.EROTIC;
        } else if (genre.equals("Essayfilm")) {
            g = MediaGenres.INDIE;
        } else if (genre.equals("Experimentalfilm")) {
            g = MediaGenres.INDIE;
        } else if (genre.equals("Fantasy")) {
            g = MediaGenres.FANTASY;
        } else if (genre.equals("Grusel")) {
            g = MediaGenres.HORROR;
        } else if (genre.equals("Hardcore")) {
            g = MediaGenres.EROTIC;
        } else if (genre.equals("Heimatfilm")) {
            g = MediaGenres.TV_MOVIE;
        } else if (genre.equals("Historienfilm")) {
            g = MediaGenres.HISTORY;
        } else if (genre.equals("Horror")) {
            g = MediaGenres.HORROR;
        } else if (genre.equals("Kampfsport")) {
            g = MediaGenres.SPORT;
        } else if (genre.equals("Katastrophen")) {
            g = MediaGenres.DISASTER;
        } else if (genre.equals("Kinder-/Familienfilm")) {
            g = MediaGenres.FAMILY;
        } else if (genre.equals("Kom\u00f6die")) {
            g = MediaGenres.COMEDY;
        } else if (genre.equals("Krieg")) {
            g = MediaGenres.WAR;
        } else if (genre.equals("Krimi")) {
            g = MediaGenres.CRIME;
        } else if (genre.equals("Kurzfilm")) {
            g = MediaGenres.SHORT;
        } else if (genre.equals("Liebe/Romantik")) {
            g = MediaGenres.ROMANCE;
        } else if (genre.equals("Mondo")) {
            g = MediaGenres.DOCUMENTARY;
        } else if (genre.equals("Musikfilm")) {
            g = MediaGenres.MUSIC;
        } else if (genre.equals("Mystery")) {
            g = MediaGenres.MYSTERY;
        } else if (genre.equals("Science-Fiction")) {
            g = MediaGenres.SCIENCE_FICTION;
        } else if (genre.equals("Serial")) {
            g = MediaGenres.SERIES;
        } else if (genre.equals("Sex")) {
            g = MediaGenres.EROTIC;
        } else if (genre.equals("Splatter")) {
            g = MediaGenres.HORROR;
        } else if (genre.equals("Sportfilm")) {
            g = MediaGenres.SPORT;
        } else if (genre.equals("Stummfilm")) {
            g = MediaGenres.SILENT_MOVIE;
        } else if (genre.equals("TV-Film")) {
            g = MediaGenres.TV_MOVIE;
        } else if (genre.equals("TV-Mini-Serie")) {
            g = MediaGenres.SERIES;
        } else if (genre.equals("TV-Pilotfilm")) {
            g = MediaGenres.TV_MOVIE;
        } else if (genre.equals("TV-Serie")) {
            g = MediaGenres.SERIES;
        } else if (genre.equals("Thriller")) {
            g = MediaGenres.THRILLER;
        } else if (genre.equals("Tierfilm")) {
            g = MediaGenres.ANIMAL;
        } else if (genre.equals("Webminiserie")) {
            g = MediaGenres.SERIES;
        } else if (genre.equals("Webserie")) {
            g = MediaGenres.SERIES;
        } else if (genre.equals("Western")) {
            g = MediaGenres.WESTERN;
        }
        if (g == null) {
            g = MediaGenres.getGenre(genre);
        }
        return g;
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        try {
            MovieSearchAndScrapeOptions movie = new MovieSearchAndScrapeOptions();
            movie.setDataFromOtherOptions(options);
            MediaMetadata md = this.getMetadata(movie);
            return md.getMediaArt(options.getArtworkType());
        }
        catch (MissingIdException | NothingFoundException e) {
            return Collections.emptyList();
        }
        catch (ScrapeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScrapeException(e);
        }
    }
}

