/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.OnDiskCachedUrl;
import org.tinymediamanager.scraper.imdb.ImdbParser;
import org.tinymediamanager.scraper.imdb.entities.ImdbEpisodeList;
import org.tinymediamanager.scraper.imdb.entities.ImdbIdValueType;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.util.CacheMap;
import org.tinymediamanager.scraper.util.JsonUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class ImdbTvShowParser
extends ImdbParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImdbTvShowParser.class);
    private static final CacheMap<String, List<MediaMetadata>> EPISODE_LIST_CACHE_MAP = new CacheMap(60L, 10L);

    ImdbTvShowParser(IMediaProvider metadataProvider, ExecutorService executor) {
        super(metadataProvider, MediaType.TV_SHOW, executor);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected boolean isIncludeTvSeriesResults() {
        return true;
    }

    @Override
    protected MediaMetadata getMetadata(MediaSearchAndScrapeOptions options) throws ScrapeException {
        switch (options.getMediaType()) {
            case TV_SHOW: {
                return this.getTvShowMetadata((TvShowSearchAndScrapeOptions)options);
            }
            case TV_EPISODE: {
                return this.getEpisodeMetadata((TvShowEpisodeSearchAndScrapeOptions)options);
            }
        }
        return new MediaMetadata("imdb");
    }

    MediaMetadata getTvShowMetadata(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getMetadata(): {}", (Object)options);
        MediaMetadata md = new MediaMetadata("imdb");
        md.setScrapeOptions(options);
        String imdbId = "";
        if (options.getSearchResult() != null) {
            imdbId = options.getSearchResult().getIMDBId();
        }
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            imdbId = options.getImdbId();
        }
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            LOGGER.debug("not possible to scrape from IMDB - no imdbId found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        LOGGER.debug("IMDB: getMetadata(imdbId): {}", (Object)imdbId);
        md.setId("imdb", imdbId);
        md.addEpisodeGroup(MediaEpisodeGroup.DEFAULT_AIRED);
        Document doc = null;
        boolean json = false;
        ImdbParser.ImdbWorker worker = new ImdbParser.ImdbWorker(this.constructUrl("title/", imdbId), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2(), true);
        Future<Document> futureDetail = this.executor.submit(worker);
        worker = new ImdbParser.ImdbWorker(this.constructUrl("title/", imdbId, this.decode("L3JlZmVyZW5jZQ==")), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2(), true);
        Future<Document> futureReference = this.executor.submit(worker);
        worker = new ImdbParser.ImdbWorker(this.constructUrl("title/", imdbId, this.decode("L2Z1bGxjcmVkaXRz")), "en", "US", true);
        Future<Document> futureCredits = this.executor.submit(worker);
        Future<Document> futureKeywords = null;
        if (this.isScrapeKeywordsPage() && this.getMaxKeywordCount() > 5) {
            worker = new ImdbParser.ImdbWorker(this.constructUrl("title/", imdbId, this.decode("L2tleXdvcmRz")), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2(), true);
            futureKeywords = this.executor.submit(worker);
        }
        Future<Document> futureReleaseInfo = null;
        if (!this.isScrapeLocalReleaseDate()) {
            worker = new ImdbParser.ImdbWorker(this.constructUrl("title/", imdbId, this.decode("L3JlbGVhc2VpbmZv")), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2(), true);
            futureReleaseInfo = this.executor.submit(worker);
        }
        try {
            doc = futureDetail.get();
            this.parseDetailPageJson(doc, options, md);
            json = true;
        }
        catch (Exception e) {
            LOGGER.debug("Could not get detailpage for id '{}' - '{}'", (Object)imdbId, (Object)e.getMessage());
        }
        if (json) {
            try {
                MediaMetadata md2 = new MediaMetadata("imdb");
                doc = futureReference.get();
                if (doc != null) {
                    this.parseReferencePage(doc, options, md2);
                    md.setCastMembers(md2.getCastMembers());
                    md.setTop250(md2.getTop250());
                    md2.getCertifications().forEach(md::addCertification);
                }
                if (md.getCastMembers().isEmpty() && (doc = futureCredits.get()) != null) {
                    this.parseFullcreditsPage(doc, options, md);
                }
                if (this.isScrapeKeywordsPage() && this.getMaxKeywordCount() > 5 && futureKeywords != null && (doc = futureKeywords.get()) != null) {
                    this.parseKeywordsPage(doc, options, md2);
                    md.setTags(md2.getTags());
                }
                if (!this.isScrapeLocalReleaseDate() && futureReleaseInfo != null && (doc = futureReleaseInfo.get()) != null) {
                    this.parseReleaseinfoPageJson(doc, options, md2);
                    md.setReleaseDate(md2.getReleaseDate());
                }
            }
            catch (Exception e) {
                LOGGER.debug("Could not parse page: {}", (Object)e.getMessage());
            }
        } else {
            worker = new ImdbParser.ImdbWorker(this.constructUrl("title/", imdbId, this.decode("L3Bsb3RzdW1tYXJ5")), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2(), true);
            Future<Document> futurePlotsummary = this.executor.submit(worker);
            worker = new ImdbParser.ImdbWorker(this.constructUrl("title/", imdbId, this.decode("L3JlbGVhc2VpbmZv")), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2(), true);
            Future<Document> futureReleaseinfo = this.executor.submit(worker);
            try {
                Document releaseinfoDoc;
                doc = futureReference.get();
                if (doc != null) {
                    this.parseReferencePage(doc, options, md);
                }
                if ((doc = futurePlotsummary.get()) != null) {
                    this.parsePlotsummaryPage(doc, options, md);
                }
                if ((releaseinfoDoc = futureReleaseinfo.get()) != null) {
                    this.parseReleaseinfoPage(releaseinfoDoc, options, md);
                }
                if (futureKeywords != null && (doc = futureKeywords.get()) != null) {
                    this.parseKeywordsPage(doc, options, md);
                }
            }
            catch (Exception e) {
                LOGGER.debug("problem while scraping: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
            if (md.getIds().isEmpty()) {
                LOGGER.debug("nothing found");
                throw new NothingFoundException();
            }
        }
        md.setId("imdb", imdbId);
        return md;
    }

    MediaMetadata getEpisodeMetadata(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getEpisodeMetadata(): {}", (Object)options);
        MediaMetadata md = new MediaMetadata("imdb");
        md.setScrapeOptions(options);
        String showId = "" + options.getTvShowIds().get("imdb");
        String episodeId = options.getIdAsString("imdb");
        if (!MediaIdUtil.isValidImdbId(episodeId)) {
            episodeId = "";
        }
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        if ((seasonNr == -1 || episodeNr == -1) && StringUtils.isBlank((CharSequence)episodeId)) {
            throw new MissingIdException("episodeNr", "seasonNr");
        }
        md.setEpisodeNumber(new MediaEpisodeNumber(MediaEpisodeGroup.DEFAULT_AIRED, seasonNr, episodeNr));
        MediaMetadata wantedEpisode = null;
        if (episodeId.isEmpty() && seasonNr >= 0 && episodeNr > 0) {
            if (!MediaIdUtil.isValidImdbId(showId)) {
                LOGGER.debug("not possible to scrape from IMDB - no imdbId found");
                throw new MissingIdException(new String[]{"imdb"});
            }
            List<MediaMetadata> episodes = this.getEpisodeList(options.createTvShowSearchAndScrapeOptions());
            if (StringUtils.isNotBlank((CharSequence)episodeId)) {
                for (MediaMetadata episode : episodes) {
                    if (!episodeId.equals(episode.getId("imdb"))) continue;
                    wantedEpisode = episode;
                    break;
                }
            }
            if (wantedEpisode == null) {
                for (MediaMetadata episode : episodes) {
                    MediaEpisodeNumber episodeNumber = episode.getEpisodeNumber(MediaEpisodeGroup.EpisodeGroupType.AIRED);
                    if (episodeNumber == null || episodeNumber.season() != seasonNr || episodeNumber.episode() != episodeNr) continue;
                    wantedEpisode = episode;
                    break;
                }
            }
        }
        if (wantedEpisode == null && StringUtils.isBlank((CharSequence)episodeId)) {
            LOGGER.debug("episode not found");
            throw new NothingFoundException();
        }
        if (wantedEpisode != null && wantedEpisode.getId("imdb") instanceof String) {
            episodeId = (String)wantedEpisode.getId("imdb");
            md.setEpisodeNumbers(wantedEpisode.getEpisodeNumbers());
            md.setTitle(wantedEpisode.getTitle());
            md.setPlot(wantedEpisode.getPlot());
            md.setRatings(wantedEpisode.getRatings());
            md.setReleaseDate(wantedEpisode.getReleaseDate());
            md.setRuntime(wantedEpisode.getRuntime());
        }
        if (MediaIdUtil.isValidImdbId(episodeId)) {
            md.setId("imdb", episodeId);
            Document doc = null;
            boolean json = false;
            ImdbParser.ImdbWorker worker = new ImdbParser.ImdbWorker(this.constructUrl("title/", episodeId), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2(), true);
            Future<Document> futureDetail = this.executor.submit(worker);
            worker = new ImdbParser.ImdbWorker(this.constructUrl("title/", episodeId, this.decode("L3JlZmVyZW5jZQ==")), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2(), true);
            Future<Document> futureReference = this.executor.submit(worker);
            worker = new ImdbParser.ImdbWorker(this.constructUrl("title/", episodeId, this.decode("L2Z1bGxjcmVkaXRz")), "en", "US", true);
            Future<Document> futureCredits = this.executor.submit(worker);
            Future<Document> futureKeywords = null;
            if (this.isScrapeKeywordsPage() && this.getMaxKeywordCount() > 5) {
                worker = new ImdbParser.ImdbWorker(this.constructUrl("title/", episodeId, this.decode("L2tleXdvcmRz")), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2(), true);
                futureKeywords = this.executor.submit(worker);
            }
            Future<Document> futureReleaseInfo = null;
            if (!this.isScrapeLocalReleaseDate()) {
                worker = new ImdbParser.ImdbWorker(this.constructUrl("title/", episodeId, this.decode("L3JlbGVhc2VpbmZv")), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2(), true);
                futureReleaseInfo = this.executor.submit(worker);
            }
            try {
                doc = futureDetail.get();
                this.parseDetailPageJson(doc, options, md);
                json = true;
            }
            catch (Exception e1) {
                LOGGER.debug("Could not get detailpage for id '{}' - '{}'", (Object)episodeId, (Object)e1.getMessage());
            }
            if (json) {
                try {
                    MediaMetadata md2 = new MediaMetadata("imdb");
                    doc = futureReference.get();
                    if (doc != null) {
                        this.parseReferencePage(doc, options, md2);
                        md.setTagline(md2.getTagline());
                        md.setCastMembers(md2.getCastMembers());
                        md.setTop250(md2.getTop250());
                        md2.getCertifications().forEach(md::addCertification);
                    }
                    if (md.getCastMembers().isEmpty() && (doc = futureCredits.get()) != null) {
                        this.parseFullcreditsPage(doc, options, md);
                    }
                    if (this.isScrapeKeywordsPage() && this.getMaxKeywordCount() > 5 && futureKeywords != null && (doc = futureKeywords.get()) != null) {
                        this.parseKeywordsPage(doc, options, md2);
                        md.setTags(md2.getTags());
                    }
                    if (!this.isScrapeLocalReleaseDate() && futureReleaseInfo != null && (doc = futureReleaseInfo.get()) != null) {
                        this.parseReleaseinfoPageJson(doc, options, md2);
                        md.setReleaseDate(md2.getReleaseDate());
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Could not parse page: {}", (Object)e.getMessage());
                }
            } else {
                try {
                    Document docKeywords;
                    Document docReference;
                    if (futureReference != null && (docReference = futureReference.get()) != null) {
                        this.parseEpisodeReference(docReference, md, episodeId);
                    }
                    if (futureKeywords != null && (docKeywords = (Document)futureKeywords.get()) != null) {
                        this.parseKeywordsPage(docKeywords, options, md);
                    }
                }
                catch (Exception e) {
                    LOGGER.trace("problem parsing: {}", (Object)e.getMessage());
                }
            }
        }
        return md;
    }

    List<MediaMetadata> getEpisodeList(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        Document doc;
        OnDiskCachedUrl url;
        LOGGER.debug("getEpisodeList(): {}", (Object)options);
        String imdbId = options.getImdbId();
        if (StringUtils.isBlank((CharSequence)imdbId)) {
            throw new MissingIdException(new String[]{"imdb"});
        }
        List<MediaMetadata> episodes = EPISODE_LIST_CACHE_MAP.get(imdbId + "_" + options.getLanguage().getLanguage());
        if (ListUtils.isNotEmpty(episodes)) {
            return episodes;
        }
        episodes = new ArrayList<MediaMetadata>();
        try {
            url = new OnDiskCachedUrl(this.constructUrl("/title/", imdbId, "/episodes?season=1"), 1, TimeUnit.DAYS);
            url.addHeader("Accept-Language", ImdbTvShowParser.getAcceptLanguage(options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2()));
        }
        catch (Exception e) {
            LOGGER.debug("problem scraping: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        ArrayList<String> availableSeasons = new ArrayList<String>();
        try (InputStream is = url.getInputStream();){
            doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
            if (doc != null) {
                ImdbEpisodeList epList = this.parseEpisodeListJSON(doc);
                if (epList != null) {
                    episodes.addAll(epList.getEpisodes());
                    for (ImdbIdValueType imdbIdValueType : ListUtils.nullSafe(epList.seasons)) {
                        if ("1".equals(imdbIdValueType.value)) continue;
                        availableSeasons.add(imdbIdValueType.value);
                    }
                }
                if (availableSeasons.isEmpty() || episodes.isEmpty()) {
                    this.parseEpisodeList(1, episodes, doc);
                    Element select = doc.getElementById("bySeason");
                    if (select != null) {
                        for (Element option : select.getElementsByTag("option")) {
                            String value = option.attr("value");
                            if (!StringUtils.isNotBlank((CharSequence)value) || "1".equals(value)) continue;
                            availableSeasons.add(value);
                        }
                    }
                }
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.debug("problem scraping: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        for (String seasonAsString : availableSeasons) {
            OnDiskCachedUrl onDiskCachedUrl;
            int season = MetadataUtil.parseInt(seasonAsString, -1);
            if (season < 0) {
                LOGGER.debug("could not parse season number - {}", (Object)seasonAsString);
                continue;
            }
            try {
                onDiskCachedUrl = new OnDiskCachedUrl(this.constructUrl("/title/", imdbId, "/epdate?season=" + season), 1, TimeUnit.DAYS);
                onDiskCachedUrl.addHeader("Accept-Language", ImdbTvShowParser.getAcceptLanguage(options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2()));
            }
            catch (Exception e) {
                LOGGER.debug("problem scraping: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
            try {
                InputStream is = onDiskCachedUrl.getInputStream();
                try {
                    doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
                    ImdbEpisodeList epList = this.parseEpisodeListJSON(doc);
                    if (epList != null && !epList.getEpisodes().isEmpty()) {
                        episodes.addAll(epList.getEpisodes());
                        continue;
                    }
                    if (this.parseEpisodeList(season, episodes, doc)) continue;
                    break;
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.debug("problem parsing ep list: {}", (Object)e.getMessage());
            }
        }
        if (!episodes.isEmpty()) {
            EPISODE_LIST_CACHE_MAP.put(imdbId + "_" + options.getLanguage().getLanguage(), episodes);
        }
        return episodes;
    }

    private ImdbEpisodeList parseEpisodeListJSON(Document doc) {
        try {
            Element jsonNode = doc.getElementById("__NEXT_DATA__");
            if (jsonNode == null) {
                return null;
            }
            String json = jsonNode.data();
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(json);
            JsonNode epListNode = JsonUtils.at(node, "/props/pageProps/contentData/section");
            ImdbEpisodeList epList = JsonUtils.parseObject(mapper, epListNode, ImdbEpisodeList.class);
            return epList;
        }
        catch (Exception e) {
            this.getLogger().debug("Error parsing JSON: '{}'", (Throwable)e);
            return null;
        }
    }

    private boolean parseEpisodeList(int season, List<MediaMetadata> episodes, Document doc) {
        Pattern unknownPattern = Pattern.compile("Unknown");
        Pattern seasonEpisodePattern = Pattern.compile("S([0-9]*), Ep([0-9]*)");
        int specialEpisodeCounter = 0;
        Elements tables = doc.getElementsByClass("eplist");
        if (tables.isEmpty()) {
            return false;
        }
        for (Element table : tables) {
            Elements rows = table.getElementsByClass("list_item");
            for (Element row : rows) {
                Matcher matcher = season <= 0 ? unknownPattern.matcher(row.text()) : seasonEpisodePattern.matcher(row.text());
                if (!matcher.find() || season > 0 && matcher.groupCount() < 2) continue;
                try {
                    Element image;
                    Element releaseDate;
                    Element ratingElement;
                    Element plot;
                    MediaMetadata ep = new MediaMetadata("imdb");
                    if (season <= 0) {
                        ep.setEpisodeNumber(new MediaEpisodeNumber(MediaEpisodeGroup.DEFAULT_AIRED, 0, ++specialEpisodeCounter));
                    } else {
                        int s = Integer.parseInt(matcher.group(1));
                        int e = Integer.parseInt(matcher.group(2));
                        if (season != s) {
                            return false;
                        }
                        ep.setEpisodeNumber(MediaEpisodeGroup.DEFAULT_AIRED, s, e);
                    }
                    Elements anchors = row.getElementsByAttributeValueStarting("href", "/title/tt");
                    for (Element anchor : anchors) {
                        if (!"name".equals(anchor.attr("itemprop"))) continue;
                        ep.setTitle(anchor.text());
                        break;
                    }
                    String id = "";
                    Matcher idMatcher = IMDB_ID_PATTERN.matcher(((Element)anchors.get(0)).attr("href"));
                    while (idMatcher.find()) {
                        if (idMatcher.group(1) == null) continue;
                        id = idMatcher.group(1);
                    }
                    if (StringUtils.isNotBlank((CharSequence)id)) {
                        ep.setId("imdb", id);
                    }
                    if ((plot = row.getElementsByClass("item_description").first()) != null) {
                        ep.setPlot(plot.ownText());
                    }
                    if ((ratingElement = row.getElementsByClass("ipl-rating-star__rating").first()) != null) {
                        String ratingAsString = ratingElement.ownText().replace(",", ".");
                        Element votesElement = row.getElementsByClass("ipl-rating-star__total-votes").first();
                        if (votesElement != null) {
                            String countAsString = votesElement.ownText().replaceAll("[.,()]", "").strip();
                            try {
                                MediaRating rating = new MediaRating("imdb");
                                rating.setRating(Float.parseFloat(ratingAsString));
                                rating.setVotes(MetadataUtil.parseInt(countAsString));
                                ep.addRating(rating);
                            }
                            catch (Exception e) {
                                LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
                            }
                        }
                    }
                    if ((releaseDate = row.getElementsByClass("airdate").first()) != null) {
                        ep.setReleaseDate(this.parseDate(releaseDate.ownText()));
                    }
                    if ((image = row.getElementsByTag("img").first()) != null) {
                        String posterUrl;
                        String thumb = posterUrl = image.attr("src");
                        posterUrl = posterUrl.replaceAll("UX[0-9]{2,4}_", "");
                        posterUrl = posterUrl.replaceAll("UY[0-9]{2,4}_", "");
                        if (StringUtils.isNotBlank((CharSequence)(posterUrl = posterUrl.replaceAll("CR[0-9]{1,3},[0-9]{1,3},[0-9]{1,3},[0-9]{1,3}_", "")))) {
                            MediaArtwork ma = new MediaArtwork("imdb", MediaArtwork.MediaArtworkType.THUMB);
                            ma.setPreviewUrl(thumb);
                            ma.setOriginalUrl(posterUrl);
                            ep.addMediaArt(ma);
                        }
                    }
                    episodes.add(ep);
                }
                catch (Exception e) {
                    LOGGER.debug("failed parsing: {} for ep data - {}", (Object)row.text(), (Object)e.getMessage());
                }
            }
        }
        return true;
    }

    private void parseEpisodeReference(Document doc, MediaMetadata md, String imdbId) {
        Element writersElement;
        Element castTableElement;
        Element directorsElement;
        Element ratingElement;
        Element poster;
        Element releaseDateElement;
        Element titlereference;
        int yearStart;
        Element title;
        Object episodeTitle;
        Element year;
        Element header = doc.getElementsByClass("titlereference-header").first();
        if (header != null && (year = header.getElementsByClass("titlereference-title-year").first()) != null && StringUtils.isNotBlank((CharSequence)(episodeTitle = this.cleanString(year.parent().ownText())))) {
            md.setTitle((String)episodeTitle);
        }
        if (StringUtils.isBlank((CharSequence)md.getTitle()) && (title = doc.getElementsByAttributeValue("name", "title").first()) != null && (yearStart = ((String)(episodeTitle = this.cleanString(title.attr("content")))).lastIndexOf(40)) > 0) {
            episodeTitle = ((String)episodeTitle).substring(0, yearStart - 1).strip();
            md.setTitle((String)episodeTitle);
        }
        if ((titlereference = doc.getElementsByClass("titlereference-section-overview").first()) != null) {
            for (Element child : titlereference.children()) {
                if (!"div".equals(child.tagName()) || !child.classNames().isEmpty()) continue;
                String plot = child.text();
                if (!StringUtils.isBlank((CharSequence)md.getPlot()) || !StringUtils.isNotBlank((CharSequence)plot)) continue;
                md.setPlot(plot);
                break;
            }
        }
        if ((releaseDateElement = doc.getElementsByAttributeValue("href", "/title/" + imdbId + "/releaseinfo").first()) != null) {
            String releaseDateText = releaseDateElement.ownText();
            int startOfCountry = releaseDateText.indexOf(40);
            if (startOfCountry > 0) {
                releaseDateText = releaseDateText.substring(0, startOfCountry - 1).strip();
            }
            md.setReleaseDate(this.parseDate(releaseDateText));
        }
        if ((poster = doc.getElementsByAttributeValue("property", "og:image").first()) != null) {
            int startOfExtension;
            int parameterStart;
            Object posterUrl = poster.attr("content");
            int fileStart = ((String)posterUrl).lastIndexOf(47);
            if (fileStart > 0 && (parameterStart = ((String)posterUrl).indexOf(95, fileStart)) > 0 && (startOfExtension = ((String)posterUrl).lastIndexOf(46)) > parameterStart) {
                posterUrl = ((String)posterUrl).substring(0, parameterStart) + ((String)posterUrl).substring(startOfExtension);
            }
            this.processMediaArt(md, MediaArtwork.MediaArtworkType.THUMB, (String)posterUrl);
        }
        if ((ratingElement = doc.getElementsByClass("ipl-rating-star__rating").first()) != null) {
            String ratingAsString = ratingElement.ownText().replace(",", ".");
            Element votesElement = doc.getElementsByClass("ipl-rating-star__total-votes").first();
            if (votesElement != null) {
                String countAsString = votesElement.ownText().replaceAll("[.,()]", "").strip();
                try {
                    MediaRating rating = new MediaRating("imdb");
                    rating.setRating(Float.parseFloat(ratingAsString));
                    rating.setVotes(MetadataUtil.parseInt(countAsString));
                    md.addRating(rating);
                }
                catch (Exception e) {
                    this.getLogger().trace("could not parse rating/vote count: {}", (Object)e.getMessage());
                }
            }
        }
        for (directorsElement = doc.getElementById("directors"); directorsElement != null && !"header".equals(directorsElement.tag().getName()); directorsElement = directorsElement.parent()) {
        }
        if (directorsElement != null) {
            directorsElement = directorsElement.nextElementSibling();
        }
        if (directorsElement != null) {
            for (Element directorElement : directorsElement.getElementsByClass("name")) {
                Matcher matcher;
                String director = directorElement.text().strip();
                Person cm = new Person(Person.Type.DIRECTOR, director);
                Element anchor = directorElement.getElementsByAttributeValueStarting("href", "/name/").first();
                if (anchor != null && (matcher = PERSON_ID_PATTERN.matcher(anchor.attr("href"))).find()) {
                    if (matcher.group(0) != null) {
                        cm.setProfileUrl("https://www.imdb.com" + matcher.group(0));
                    }
                    if (matcher.group(1) != null) {
                        cm.setId("imdb", matcher.group(1));
                    }
                }
                md.addCastMember(cm);
            }
        }
        if ((castTableElement = doc.getElementsByClass("cast_list").first()) != null) {
            Elements castListLabel = castTableElement.getElementsByClass("castlist_label");
            Elements tr = castTableElement.getElementsByTag("tr");
            for (Element row : tr) {
                if (!this.isScrapeUncreditedActors() && castListLabel.size() > 1 && row.children().contains(castListLabel.get(1))) break;
                Person cm = this.parseCastMember(row);
                if (cm == null || !StringUtils.isNotEmpty((CharSequence)cm.getName())) continue;
                cm.setType(Person.Type.ACTOR);
                md.addCastMember(cm);
            }
        }
        for (writersElement = doc.getElementById("writers"); writersElement != null && !"header".equals(writersElement.tag().getName()); writersElement = writersElement.parent()) {
        }
        if (writersElement != null) {
            writersElement = writersElement.nextElementSibling();
        }
        if (writersElement != null) {
            Elements writersElements = writersElement.getElementsByAttributeValueStarting("href", "/name/");
            for (Element writerElement : writersElements) {
                Matcher matcher;
                String writer = this.cleanString(writerElement.ownText());
                Person cm = new Person(Person.Type.WRITER, writer);
                Element anchor = writerElement.getElementsByAttributeValueStarting("href", "/name/").first();
                if (anchor != null && (matcher = PERSON_ID_PATTERN.matcher(anchor.attr("href"))).find()) {
                    if (matcher.group(0) != null) {
                        cm.setProfileUrl("https://www.imdb.com" + matcher.group(0));
                    }
                    if (matcher.group(1) != null) {
                        cm.setId("imdb", matcher.group(1));
                    }
                }
                md.addCastMember(cm);
            }
        }
    }

    public List<MediaArtwork> getTvShowArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        String imdbId = options.getImdbId();
        if (!MediaIdUtil.isValidImdbId(imdbId) && options.getTmdbId() > 0) {
            imdbId = MediaIdUtil.getTvShowImdbIdViaTmdbId(options.getTmdbId());
        }
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            return Collections.emptyList();
        }
        try {
            if (options.getMediaType() == MediaType.TV_EPISODE) {
                TvShowEpisodeSearchAndScrapeOptions op = new TvShowEpisodeSearchAndScrapeOptions();
                op.setDataFromOtherOptions(options);
                if (options.getIds().get("tvShowIds") instanceof Map) {
                    Map tvShowIds = (Map)options.getIds().get("tvShowIds");
                    op.setTvShowIds(tvShowIds);
                }
                List<MediaArtwork> artworks = this.getMetadata(op).getMediaArt(options.getArtworkType());
                return artworks;
            }
            List<MediaArtwork> artworks = this.getMediaArt(options);
            if (options.getArtworkType() == MediaArtwork.MediaArtworkType.ALL) {
                return artworks;
            }
            return artworks.stream().filter(ma -> ma.getType() == options.getArtworkType()).toList();
        }
        catch (Exception e) {
            throw new ScrapeException(e);
        }
    }

    public Map<String, Integer> getTvShowTop250() {
        return this.parseTop250("/chart/toptv/");
    }
}

