/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.tinymediamanager.core.TmmResourceBundle;

public class MediaEpisodeGroup
implements Comparable<MediaEpisodeGroup> {
    public static final MediaEpisodeGroup DEFAULT_AIRED = new MediaEpisodeGroup(EpisodeGroupType.AIRED);
    public static final MediaEpisodeGroup DEFAULT_DVD = new MediaEpisodeGroup(EpisodeGroupType.DVD);
    public static final MediaEpisodeGroup DEFAULT_ABSOLUTE = new MediaEpisodeGroup(EpisodeGroupType.ABSOLUTE);
    public static final MediaEpisodeGroup DEFAULT_DISPLAY = new MediaEpisodeGroup(EpisodeGroupType.DISPLAY);
    @JsonProperty
    private final EpisodeGroupType episodeGroupType;
    @JsonProperty
    private final String name;

    public MediaEpisodeGroup(String name) {
        this(EpisodeGroupType.AIRED, name);
    }

    public MediaEpisodeGroup(EpisodeGroupType episodeGroupType) {
        this(episodeGroupType, "");
    }

    @JsonCreator
    public MediaEpisodeGroup(@JsonProperty(value="episodeGroupType") @NotNull EpisodeGroupType episodeGroupType, @JsonProperty(value="name") String name) {
        this.episodeGroupType = episodeGroupType;
        this.name = name != null ? name : "";
    }

    public EpisodeGroupType getEpisodeGroupType() {
        return this.episodeGroupType;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        if (this.episodeGroupType == null) {
            return TmmResourceBundle.getString("episodeGroup.aired");
        }
        String localizedEnumName = TmmResourceBundle.getString("episodeGroup." + this.episodeGroupType.name().toLowerCase(Locale.ROOT));
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            return this.name + " (" + localizedEnumName + ")";
        }
        return localizedEnumName;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaEpisodeGroup that = (MediaEpisodeGroup)o;
        boolean bl = result = this.episodeGroupType == that.episodeGroupType;
        if (this.episodeGroupType != EpisodeGroupType.AIRED && result) {
            result = Objects.equals(this.name, that.name);
        }
        return result;
    }

    public int hashCode() {
        if (this.episodeGroupType != EpisodeGroupType.AIRED) {
            return Objects.hash(new Object[]{this.episodeGroupType, this.name});
        }
        return Objects.hash(new Object[]{this.episodeGroupType});
    }

    @Override
    public int compareTo(@NotNull MediaEpisodeGroup o) {
        int result = Integer.compare(this.episodeGroupType.ordinal(), o.episodeGroupType.ordinal());
        if (this.episodeGroupType != EpisodeGroupType.AIRED && result == 0) {
            result = this.name.compareTo(o.name);
        }
        return result;
    }

    public static enum EpisodeGroupType {
        AIRED,
        DVD,
        ABSOLUTE,
        ALTERNATE,
        DISPLAY;

    }
}

