/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.filenaming;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.tvshow.ITvShowSeasonFileNaming;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TvShowSeasonThumbNaming implements ITvShowSeasonFileNaming
{
    SEASON_THUMB{

        @Override
        public String getFilename(TvShowSeason tvShowSeason, String extension, boolean forRenamer) {
            Object filename = tvShowSeason.getSeason() == -1 ? "season-all-thumb." + extension : (tvShowSeason.getSeason() == 0 && TvShowModuleManager.getInstance().getSettings().isSpecialSeason() ? "season-specials-thumb." + extension : (tvShowSeason.getSeason() > -1 ? String.format("season%02d-thumb.%s", tvShowSeason.getSeason(), extension) : ""));
            return filename;
        }
    }
    ,
    SEASON_LANDSCAPE{

        @Override
        public String getFilename(TvShowSeason tvShowSeason, String extension, boolean forRenamer) {
            Object filename = tvShowSeason.getSeason() == -1 ? "season-all-landscape." + extension : (tvShowSeason.getSeason() == 0 && TvShowModuleManager.getInstance().getSettings().isSpecialSeason() ? "season-specials-landscape." + extension : (tvShowSeason.getSeason() > -1 ? String.format("season%02d-landscape.%s", tvShowSeason.getSeason(), extension) : ""));
            return filename;
        }
    }
    ,
    SEASON_FOLDER{

        @Override
        public String getFilename(TvShowSeason tvShowSeason, String extension, boolean forRenamer) {
            TvShow tvShow = tvShowSeason.getTvShow();
            if (tvShow == null) {
                return "";
            }
            String seasonFoldername = this.getSeasonFolder(tvShowSeason, forRenamer);
            if (StringUtils.isBlank((CharSequence)seasonFoldername)) {
                return SEASON_THUMB.getFilename(tvShowSeason, extension, forRenamer);
            }
            Object filename = String.format("season%02d-thumb.%s", tvShowSeason.getSeason(), extension);
            if (tvShowSeason.getSeason() == 0 && TvShowModuleManager.getInstance().getSettings().isSpecialSeason()) {
                filename = "season-specials-thumb." + extension;
            }
            return seasonFoldername + File.separator + (String)filename;
        }
    }
    ,
    SEASON_FOLDER_LANDSCAPE{

        @Override
        public String getFilename(TvShowSeason tvShowSeason, String extension, boolean forRenamer) {
            TvShow tvShow = tvShowSeason.getTvShow();
            if (tvShow == null) {
                return "";
            }
            String seasonFoldername = this.getSeasonFolder(tvShowSeason, forRenamer);
            if (StringUtils.isBlank((CharSequence)seasonFoldername)) {
                return SEASON_LANDSCAPE.getFilename(tvShowSeason, extension, forRenamer);
            }
            return seasonFoldername + File.separator + String.format("season%02d-landscape.%s", tvShowSeason.getSeason(), extension);
        }
    };

}

