/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import com.fasterxml.jackson.databind.ObjectReader;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.h2.mvstore.MVMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.TmmOsUtils;
import org.tinymediamanager.UpgradeTasks;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.bus.Event;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowEpisodeAndSeasonParser;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;

public final class TvShowList
extends AbstractModelObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowList.class);
    private static TvShowList instance = null;
    private final List<TvShow> tvShows;
    private final CopyOnWriteArrayList<String> tagsInTvShows;
    private final CopyOnWriteArrayList<String> tagsInEpisodes;
    private final CopyOnWriteArrayList<String> videoCodecsInEpisodes;
    private final CopyOnWriteArrayList<String> videoContainersInEpisodes;
    private final CopyOnWriteArrayList<String> audioCodecsInEpisodes;
    private final CopyOnWriteArrayList<Integer> audioChannelsInEpisodes;
    private final CopyOnWriteArrayList<Double> frameRatesInEpisodes;
    private final CopyOnWriteArrayList<MediaCertification> certificationsInTvShows;
    private final CopyOnWriteArrayList<Integer> audioStreamsInEpisodes;
    private final CopyOnWriteArrayList<String> audioLanguagesInEpisodes;
    private final CopyOnWriteArrayList<Integer> subtitlesInEpisodes;
    private final CopyOnWriteArrayList<String> subtitleLanguagesInEpisodes;
    private final CopyOnWriteArrayList<String> subtitleFormatsInEpisodes;
    private final CopyOnWriteArrayList<String> hdrFormatInEpisodes;
    private final CopyOnWriteArrayList<String> audioTitlesInEpisodes;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    private TvShowList() {
        this.tvShows = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(TvShow.class));
        this.tagsInTvShows = new CopyOnWriteArrayList();
        this.tagsInEpisodes = new CopyOnWriteArrayList();
        this.videoCodecsInEpisodes = new CopyOnWriteArrayList();
        this.videoContainersInEpisodes = new CopyOnWriteArrayList();
        this.audioCodecsInEpisodes = new CopyOnWriteArrayList();
        this.audioChannelsInEpisodes = new CopyOnWriteArrayList();
        this.frameRatesInEpisodes = new CopyOnWriteArrayList();
        this.certificationsInTvShows = new CopyOnWriteArrayList();
        this.audioStreamsInEpisodes = new CopyOnWriteArrayList();
        this.audioLanguagesInEpisodes = new CopyOnWriteArrayList();
        this.subtitlesInEpisodes = new CopyOnWriteArrayList();
        this.subtitleLanguagesInEpisodes = new CopyOnWriteArrayList();
        this.hdrFormatInEpisodes = new CopyOnWriteArrayList();
        this.audioTitlesInEpisodes = new CopyOnWriteArrayList();
        this.subtitleFormatsInEpisodes = new CopyOnWriteArrayList();
        EventBus.registerListener(EventBus.TOPIC_TV_SHOWS, event -> {
            if (event.eventType().equals("remove") || event.eventType().equals("save")) {
                TmmTaskManager.getInstance().addUiTask(() -> {
                    if (event.sender() instanceof TvShow) {
                        this.updateTvShowTags();
                        this.updateCertification();
                    } else if (event.sender() instanceof TvShowEpisode) {
                        this.updateEpisodeTags();
                    }
                });
            }
        });
    }

    static synchronized TvShowList getInstance() {
        if (instance == null) {
            instance = new TvShowList();
        }
        return instance;
    }

    static void clearInstance() {
        instance = null;
    }

    public List<TvShow> getTvShows() {
        return this.tvShows;
    }

    public List<TvShowEpisode> getEpisodes() {
        ArrayList<TvShowEpisode> newEp = new ArrayList<TvShowEpisode>();
        for (TvShow show : this.tvShows) {
            newEp.addAll(show.getEpisodes());
        }
        return newEp;
    }

    public void debugListDuplicateEpisode() {
        int cnt = 0;
        for (TvShow show : this.tvShows) {
            List<int[]> dupes = show.getDuplicateEpisodes();
            cnt += dupes.size();
            if (dupes.isEmpty()) continue;
            System.out.println("---------------------");
            System.out.println("Dupes found! - " + show.getTitle());
            for (int[] se : dupes) {
                List<TvShowEpisode> eps = show.getEpisode(se[0], se[1]);
                for (TvShowEpisode ep : eps) {
                    System.out.println(Arrays.toString(se) + (String)(eps.size() > 2 ? " MULTI" + eps.size() : "") + " - " + Utils.relPath(show.getPathNIO(), ep.getMainFile().getFileAsPath()));
                }
            }
        }
        System.out.println("Found " + cnt + " episodes with same number!");
    }

    public void debugFindWronglyMatchedEpisodes() {
        for (TvShow show : this.tvShows) {
            boolean first = true;
            for (TvShowEpisode ep : show.getEpisodes()) {
                MediaFile mf = ep.getMainFile();
                String rel = show.getPathNIO().relativize(mf.getFileAsPath()).toString();
                TvShowEpisodeAndSeasonParser.EpisodeMatchingResult result = TvShowEpisodeAndSeasonParser.detectEpisodeFromFilename(rel, show.getTitle());
                if (result.episodes.contains(ep.getEpisode()) && result.season == ep.getSeason()) continue;
                if (first) {
                    System.out.println("---------------------");
                    System.out.println("Episode matching found some differences! - " + show.getTitle());
                    first = false;
                }
                System.out.println("S:" + ep.getSeason() + " E:" + ep.getEpisode() + " - " + rel + "   now detected as S:" + result.season + " E:" + result.episodes);
            }
        }
    }

    public List<MediaScraper> getTrailerScrapers(List<String> providerIds) {
        ArrayList<MediaScraper> trailerScrapers = new ArrayList<MediaScraper>();
        for (String providerId : providerIds) {
            MediaScraper trailerScraper;
            if (StringUtils.isBlank((CharSequence)providerId) || (trailerScraper = MediaScraper.getMediaScraperById(providerId, ScraperType.TVSHOW_TRAILER)) == null) continue;
            trailerScrapers.add(trailerScraper);
        }
        return trailerScrapers;
    }

    public List<MediaScraper> getAvailableTrailerScrapers() {
        return MediaScraper.getMediaScrapers(ScraperType.TVSHOW_TRAILER);
    }

    public List<TvShow> getUnscrapedTvShows() {
        return this.tvShows.parallelStream().filter(tvShow -> !tvShow.isScraped()).sorted().collect(Collectors.toList());
    }

    public void addTvShow(TvShow newValue) {
        this.readWriteLock.writeLock().lock();
        int oldValue = this.tvShows.size();
        this.tvShows.add(newValue);
        this.readWriteLock.writeLock().unlock();
        this.firePropertyChange("tvShows", null, this.tvShows);
        this.firePropertyChange("addedTvShow", null, newValue);
        this.firePropertyChange("tvShowCount", oldValue, this.tvShows.size());
    }

    public void removeDatasource(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return;
        }
        for (int i = this.tvShows.size() - 1; i >= 0; --i) {
            TvShow tvShow = this.tvShows.get(i);
            if (!Paths.get(path, new String[0]).equals(Paths.get(tvShow.getDataSource(), new String[0]))) continue;
            this.removeTvShow(tvShow);
        }
    }

    void exchangeDatasource(String oldDatasource, String newDatasource) {
        Path oldPath = Paths.get(oldDatasource, new String[0]);
        List<TvShow> tvShowsToChange = this.tvShows.stream().filter(tvShow -> oldPath.equals(Paths.get(tvShow.getDataSource(), new String[0]))).toList();
        ArrayList<MediaFile> imagesToCache = new ArrayList<MediaFile>();
        for (TvShow tvShow2 : tvShowsToChange) {
            Path newTvShowPath;
            Path oldTvShowPath = tvShow2.getPathNIO();
            try {
                newTvShowPath = Paths.get(newDatasource, Paths.get(tvShow2.getDataSource(), new String[0]).relativize(oldTvShowPath).toString());
            }
            catch (Exception e) {
                newTvShowPath = Paths.get(newDatasource, FilenameUtils.separatorsToSystem((String)tvShow2.getPath().replace(tvShow2.getDataSource(), "")));
            }
            tvShow2.setDataSource(newDatasource);
            tvShow2.setPath(newTvShowPath.toAbsolutePath().toString());
            tvShow2.updateMediaFilePath(oldTvShowPath, newTvShowPath);
            for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(tvShow2.getEpisodes())) {
                episode.setDataSource(newDatasource);
                episode.replacePathForRenamedTvShowRoot(oldTvShowPath, newTvShowPath);
                episode.updateMediaFilePath(oldTvShowPath, newTvShowPath);
                episode.saveToDb();
                imagesToCache.addAll(episode.getImagesToCache());
            }
            tvShow2.saveToDb();
            imagesToCache.addAll(tvShow2.getImagesToCache());
        }
        if (!imagesToCache.isEmpty()) {
            imagesToCache.forEach(ImageCache::cacheImageAsync);
        }
    }

    public void removeTvShow(TvShow tvShow) {
        this.readWriteLock.writeLock().lock();
        int oldValue = this.tvShows.size();
        this.tvShows.remove(tvShow);
        this.readWriteLock.writeLock().unlock();
        EventBus.publishEvent(EventBus.TOPIC_TV_SHOWS, Event.createRemoveEvent(tvShow));
        this.firePropertyChange("tvShows", null, this.tvShows);
        this.firePropertyChange("removedTvShow", null, tvShow);
        this.firePropertyChange("tvShowCount", oldValue, this.tvShows.size());
        for (TvShowEpisode episode : tvShow.getEpisodes()) {
            TvShowModuleManager.getInstance().getTvShowList().removeEpisodeFromDb(episode);
            for (MediaFile mf : episode.getMediaFiles()) {
                if (!mf.isGraphic()) continue;
                ImageCache.invalidateCachedImage(mf);
            }
        }
        for (TvShowSeason season : tvShow.getSeasons()) {
            try {
                TvShowModuleManager.getInstance().removeSeasonFromDb(season);
            }
            catch (Exception e) {
                LOGGER.error("Error removing season {} of '{}' from DB - '{}'", new Object[]{season.getSeason(), tvShow.getTitle(), e.getMessage()});
            }
        }
        try {
            TvShowModuleManager.getInstance().removeTvShowFromDb(tvShow);
            EventBus.publishEvent(EventBus.TOPIC_TV_SHOWS, Event.createRemoveEvent(tvShow));
        }
        catch (Exception e) {
            LOGGER.error("Error removing TV show '{}' from DB - '{}'", (Object)tvShow.getTitle(), (Object)e.getMessage());
        }
        for (MediaFile mf : tvShow.getMediaFiles()) {
            if (!mf.isGraphic()) continue;
            ImageCache.invalidateCachedImage(mf);
        }
    }

    public void deleteTvShow(TvShow tvShow) {
        this.readWriteLock.writeLock().lock();
        int oldValue = this.tvShows.size();
        this.tvShows.remove(tvShow);
        this.readWriteLock.writeLock().unlock();
        tvShow.deleteFilesSafely();
        for (TvShowEpisode episode : tvShow.getEpisodes()) {
            TvShowModuleManager.getInstance().getTvShowList().removeEpisodeFromDb(episode);
            for (MediaFile mf : episode.getMediaFiles()) {
                if (!mf.isGraphic()) continue;
                ImageCache.invalidateCachedImage(mf);
            }
        }
        for (TvShowSeason season : tvShow.getSeasons()) {
            try {
                TvShowModuleManager.getInstance().removeSeasonFromDb(season);
            }
            catch (Exception e) {
                LOGGER.error("Error removing season {} of '{}' from DB - '{}'", new Object[]{season.getSeason(), tvShow.getTitle(), e.getMessage()});
            }
        }
        try {
            TvShowModuleManager.getInstance().removeTvShowFromDb(tvShow);
            EventBus.publishEvent(EventBus.TOPIC_TV_SHOWS, Event.createRemoveEvent(tvShow));
        }
        catch (Exception e) {
            LOGGER.error("Error removing TV show '{}' from DB - '{}'", (Object)tvShow.getTitle(), (Object)e.getMessage());
        }
        for (MediaFile mf : tvShow.getMediaFiles()) {
            if (!mf.isGraphic()) continue;
            ImageCache.invalidateCachedImage(mf);
        }
        this.firePropertyChange("tvShows", null, this.tvShows);
        this.firePropertyChange("removedTvShow", null, tvShow);
        this.firePropertyChange("tvShowCount", oldValue, this.tvShows.size());
    }

    public int getTvShowCount() {
        return this.tvShows.size();
    }

    public int getEpisodeCount() {
        int count = 0;
        for (TvShow tvShow : this.tvShows) {
            count += tvShow.getEpisodeCount();
        }
        return count;
    }

    public int getDummyEpisodeCount() {
        int count = 0;
        for (TvShow tvShow : this.tvShows) {
            count += tvShow.getDummyEpisodeCount();
        }
        return count;
    }

    public boolean hasDummyEpisodes() {
        for (TvShow tvShow : this.tvShows) {
            if (tvShow.getDummyEpisodeCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public TvShow lookupTvShow(UUID uuid) {
        for (TvShow tvShow : this.tvShows) {
            if (!tvShow.getDbId().equals(uuid)) continue;
            return tvShow;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void loadTvShowsFromDatabase(MVMap<UUID, String> tvShowMap, MVMap<UUID, String> seasonMap, MVMap<UUID, String> episodesMap) {
        void var15_20;
        LOGGER.info("Loading TV shows from database...");
        TvShowModuleManager module = TvShowModuleManager.getInstance();
        HashSet tvShowsFromDb = new HashSet();
        ObjectReader tvShowObjectReader = TvShowModuleManager.getInstance().getTvShowObjectReader();
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        long start = System.nanoTime();
        new ArrayList<UUID>(tvShowMap.keyList()).forEach(uuid -> {
            String json = "";
            try {
                json = (String)tvShowMap.get(uuid);
                TvShow tvShow = (TvShow)tvShowObjectReader.readValue(json);
                tvShow.setDbId((UUID)uuid);
                if (this.isCorrupt(tvShow)) {
                    LOGGER.debug("Removing corrupt show: {}", (Object)json);
                    toRemove.add((UUID)uuid);
                    return;
                }
                if (module.getDbVersion() < 5002) {
                    tvShow.getDummyEpisodes().forEach(UpgradeTasks::upgradeEpisodeNumbers);
                }
                if (!tvShowsFromDb.add(tvShow)) {
                    LOGGER.debug("removed duplicate '{}'", (Object)tvShow.getTitle());
                    toRemove.add((UUID)uuid);
                }
            }
            catch (Exception e) {
                LOGGER.debug("problem decoding TV show json string: {}", (Object)json);
                LOGGER.warn("Dropping corrupt TV show from database because of - '{}'", (Object)e.getMessage());
                toRemove.add((UUID)uuid);
            }
        });
        long end = System.nanoTime();
        for (UUID uUID : toRemove) {
            tvShowMap.remove((Object)uUID);
        }
        LOGGER.debug("took {} ms", (Object)((end - start) / 1000000L));
        HashMap<UUID, TvShow> tvShowUuidMap = new HashMap<UUID, TvShow>();
        for (Object tvShow : tvShowsFromDb) {
            tvShowUuidMap.put(((MediaEntity)tvShow).getDbId(), (TvShow)tvShow);
        }
        LOGGER.info("Loading seasons from database...");
        toRemove.clear();
        ObjectReader objectReader = TvShowModuleManager.getInstance().getSeasonObjectReader();
        start = System.nanoTime();
        new ArrayList<UUID>(seasonMap.keyList()).forEach(uuid -> {
            String json = "";
            try {
                json = (String)seasonMap.get(uuid);
                TvShowSeason season = (TvShowSeason)seasonObjectReader.readValue(json);
                season.setDbId((UUID)uuid);
                TvShow tvShow = (TvShow)tvShowUuidMap.get(season.getTvShowDbId());
                if (tvShow != null) {
                    season.setTvShow(tvShow);
                    tvShow.addSeason(season);
                } else {
                    toRemove.add((UUID)uuid);
                }
            }
            catch (Exception e) {
                LOGGER.debug("problem decoding episode json string: '{}'", (Object)json);
                LOGGER.warn("Dropping corrupt episode from database because of - '{}'", (Object)e.getMessage());
                toRemove.add((UUID)uuid);
            }
        });
        end = System.nanoTime();
        for (UUID uUID : toRemove) {
            seasonMap.remove((Object)uUID);
        }
        LOGGER.debug("took {} ms", (Object)((end - start) / 1000000L));
        LOGGER.info("Loading episodes from database...");
        toRemove.clear();
        ObjectReader episodeObjectReader = TvShowModuleManager.getInstance().getEpisodeObjectReader();
        start = System.nanoTime();
        new ArrayList<UUID>(episodesMap.keyList()).forEach(uuid -> {
            String json = "";
            try {
                TvShow tvShow;
                json = (String)episodesMap.get(uuid);
                TvShowEpisode episode = (TvShowEpisode)episodeObjectReader.readValue(json);
                episode.setDbId((UUID)uuid);
                if (this.isCorrupt(episode)) {
                    LOGGER.debug("Removing corrupt episode: {}", (Object)json);
                    toRemove.add((UUID)uuid);
                    return;
                }
                if (episode.isDummy()) {
                    LOGGER.debug("Removing dummy episode from wrong storage: S{}E{} - {}", new Object[]{episode.getSeason(), episode.getEpisode(), episode.getTitle()});
                    toRemove.add((UUID)uuid);
                    return;
                }
                if (module.getDbVersion() < 5002) {
                    UpgradeTasks.upgradeEpisodeNumbers(episode);
                }
                if ((tvShow = (TvShow)tvShowUuidMap.get(episode.getTvShowDbId())) != null) {
                    episode.setTvShow(tvShow);
                    tvShow.addEpisode(episode);
                } else {
                    toRemove.add((UUID)uuid);
                }
            }
            catch (Exception e) {
                LOGGER.debug("problem decoding episode json string: '{}'", (Object)json);
                LOGGER.warn("Dropping corrupt episode from database because of - '{}'", (Object)e.getMessage());
                toRemove.add((UUID)uuid);
            }
        });
        end = System.nanoTime();
        for (UUID uuid4 : toRemove) {
            episodesMap.remove((Object)uuid4);
        }
        LOGGER.debug("took {} ms", (Object)((end - start) / 1000000L));
        toRemove.clear();
        for (TvShow tvShow : tvShowsFromDb) {
            if (tvShow.getEpisodeCount() != 0) continue;
            toRemove.add(tvShow.getDbId());
        }
        for (UUID uuid2 : toRemove) {
            tvShowMap.remove((Object)uuid2);
            TvShow tvShow = (TvShow)tvShowUuidMap.get(uuid2);
            tvShowsFromDb.remove(tvShow);
        }
        boolean bl = false;
        int seasonCount = 0;
        int episodeCount = 0;
        int dummyCount = 0;
        for (TvShow tvShow : tvShowsFromDb) {
            ++var15_20;
            seasonCount += tvShow.getSeasons().size();
            episodeCount += tvShow.getEpisodeCount();
            dummyCount += tvShow.getDummyEpisodes().size();
        }
        LOGGER.info("==> Loaded {} TV shows", (Object)((int)var15_20));
        LOGGER.info("==> Loaded {} seasons", (Object)seasonCount);
        LOGGER.info("==> Loaded {} episodes (+ {} dummy w/o physical file)", (Object)episodeCount, (Object)dummyCount);
        this.tvShows.addAll(tvShowsFromDb);
    }

    void initDataAfterLoading() {
        this.checkAndCleanupMediaFiles();
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>();
        for (TvShow tvShow : this.tvShows) {
            tvShow.initializeAfterLoading();
            for (TvShowSeason season : tvShow.getSeasons()) {
                season.initializeAfterLoading();
            }
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                episode.initializeAfterLoading();
                episodes.add(episode);
            }
        }
        this.updateTvShowLists(this.tvShows);
        this.updateEpisodeLists(episodes);
    }

    private boolean isCorrupt(TvShow show) {
        if (StringUtils.isBlank((CharSequence)show.getPath())) {
            LOGGER.debug("TvShow without path - dropping");
            return true;
        }
        if (StringUtils.isBlank((CharSequence)show.getDataSource())) {
            LOGGER.debug("TvShow without datasource - dropping");
            return true;
        }
        if (TmmOsUtils.hasInvalidCharactersForFilesystem(show.getPath())) {
            LOGGER.debug("TvShow with invalid characters for this OS - dropping");
            return true;
        }
        return false;
    }

    private boolean isCorrupt(TvShowEpisode episode) {
        if (episode.getMediaFiles(MediaFileType.VIDEO).isEmpty()) {
            LOGGER.debug("Episode S{} E{} without MediaFiles - dropping", (Object)episode.getSeason(), (Object)episode.getEpisode());
            return true;
        }
        if (StringUtils.isBlank((CharSequence)episode.getPath())) {
            LOGGER.debug("Episode S{} E{} without path - dropping", (Object)episode.getSeason(), (Object)episode.getEpisode());
            return true;
        }
        if (TmmOsUtils.hasInvalidCharactersForFilesystem(episode.getPath())) {
            LOGGER.debug("Episode S{} E{} with invalid characters for this OS - dropping", (Object)episode.getSeason(), (Object)episode.getEpisode());
            return true;
        }
        return false;
    }

    public void persistTvShow(TvShow tvShow) {
        try {
            if (!this.tvShows.contains(tvShow)) {
                throw new IllegalArgumentException(tvShow.getPathNIO().toString());
            }
        }
        catch (Exception e) {
            LOGGER.debug("not persisting TV show - not in tvShowList", (Throwable)e);
            return;
        }
        try {
            TvShowModuleManager.getInstance().persistTvShow(tvShow);
            EventBus.publishEvent(EventBus.TOPIC_TV_SHOWS, Event.createSaveEvent(tvShow));
            this.updateTvShowLists(Collections.singletonList(tvShow));
        }
        catch (Exception e) {
            LOGGER.error("Failed to persist TV show '{}' - '{}'", (Object)tvShow.getTitle(), (Object)e.getMessage());
        }
    }

    public void persistSeason(TvShowSeason season) {
        try {
            TvShowModuleManager.getInstance().persistSeason(season);
            EventBus.publishEvent(EventBus.TOPIC_TV_SHOWS, Event.createSaveEvent(season));
        }
        catch (Exception e) {
            LOGGER.error("Failed to persist season {} of '{}' - '{}'", new Object[]{season.getSeason(), season.getTvShow().getTitle(), e.getMessage()});
        }
    }

    public void persistEpisode(TvShowEpisode episode) {
        if (this.isCorrupt(episode)) {
            LOGGER.warn("Cannot persist episode S{} E{} of '{}' - dropping", new Object[]{episode.getSeason(), episode.getEpisode(), episode.getTvShow().getTitle()});
            this.removeEpisodeFromDb(episode);
        } else {
            try {
                TvShowModuleManager.getInstance().persistEpisode(episode);
                EventBus.publishEvent(EventBus.TOPIC_TV_SHOWS, Event.createSaveEvent(episode));
            }
            catch (Exception e) {
                LOGGER.error("Failed to persist episode S{} E{} of '{}' - '{}'", new Object[]{episode.getSeason(), episode.getEpisode(), episode.getTvShow().getTitle(), e.getMessage()});
            }
        }
    }

    public void removeEpisodeFromDb(TvShowEpisode episode) {
        try {
            TvShowModuleManager.getInstance().removeEpisodeFromDb(episode);
            EventBus.publishEvent(EventBus.TOPIC_TV_SHOWS, Event.createRemoveEvent(episode));
        }
        catch (Exception e) {
            LOGGER.error("Failed to remove episode S{} E{} of '{}' - '{}'", new Object[]{episode.getSeason(), episode.getEpisode(), episode.getTvShow().getTitle(), e.getMessage()});
        }
    }

    public MediaScraper getDefaultMediaScraper() {
        MediaScraper scraper = MediaScraper.getMediaScraperById(TvShowModuleManager.getInstance().getSettings().getScraper(), ScraperType.TV_SHOW);
        if (scraper == null || !scraper.isEnabled()) {
            scraper = MediaScraper.getMediaScraperById("tmdb", ScraperType.TV_SHOW);
        }
        return scraper;
    }

    public MediaScraper getMediaScraperById(String providerId) {
        return MediaScraper.getMediaScraperById(providerId, ScraperType.TV_SHOW);
    }

    public List<MediaScraper> getAvailableMediaScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.TV_SHOW);
        availableScrapers.sort(new TvShowMediaScraperComparator());
        return availableScrapers;
    }

    public List<MediaScraper> getAvailableArtworkScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.TVSHOW_ARTWORK);
        availableScrapers.sort(new TvShowMediaScraperComparator());
        return availableScrapers;
    }

    public List<MediaScraper> getArtworkScrapers(List<String> providerIds) {
        ArrayList<MediaScraper> artworkScrapers = new ArrayList<MediaScraper>();
        for (String providerId : providerIds) {
            MediaScraper artworkScraper;
            if (StringUtils.isBlank((CharSequence)providerId) || (artworkScraper = MediaScraper.getMediaScraperById(providerId, ScraperType.TVSHOW_ARTWORK)) == null) continue;
            artworkScrapers.add(artworkScraper);
        }
        return artworkScrapers;
    }

    public List<MediaScraper> getDefaultArtworkScrapers() {
        List<MediaScraper> defaultScrapers = this.getArtworkScrapers(TvShowModuleManager.getInstance().getSettings().getArtworkScrapers());
        return defaultScrapers.stream().filter(MediaScraper::isActive).toList();
    }

    public List<MediaSearchResult> searchTvShow(String searchTerm, int year, Map<String, Object> ids, MediaScraper mediaScraper) throws ScrapeException {
        return this.searchTvShow(searchTerm, year, ids, mediaScraper, TvShowModuleManager.getInstance().getSettings().getScraperLanguage());
    }

    public List<MediaSearchResult> searchTvShow(String searchTerm, int year, Map<String, Object> ids, MediaScraper mediaScraper, MediaLanguages language) throws ScrapeException {
        if (mediaScraper == null || !mediaScraper.isEnabled()) {
            return Collections.emptyList();
        }
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        ITvShowMetadataProvider provider = (ITvShowMetadataProvider)mediaScraper.getMediaProvider();
        Pattern tmdbPattern = Pattern.compile("https://www.themoviedb.org/tv/(.*?)-.*");
        TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions();
        options.setSearchQuery(searchTerm);
        options.setLanguage(language);
        options.setCertificationCountry(TvShowModuleManager.getInstance().getSettings().getCertificationCountry());
        options.setReleaseDateCountry(TvShowModuleManager.getInstance().getSettings().getReleaseDateCountry());
        if (ids != null) {
            options.setIds(ids);
        }
        if (!searchTerm.isEmpty()) {
            String query = searchTerm.toLowerCase(Locale.ROOT);
            if (MediaIdUtil.isValidImdbId(query)) {
                options.setImdbId(query);
            } else if (query.startsWith("imdb:")) {
                String imdbId = query.replace("imdb:", "");
                if (MediaIdUtil.isValidImdbId(imdbId)) {
                    options.setImdbId(imdbId);
                }
            } else if (query.startsWith("https://www.imdb.com/title/")) {
                String imdbId = query.split("/")[4];
                if (MediaIdUtil.isValidImdbId(imdbId)) {
                    options.setImdbId(imdbId);
                }
            } else if (query.startsWith("tmdb:")) {
                try {
                    int tmdbId = Integer.parseInt(query.replace("tmdb:", ""));
                    if (tmdbId > 0) {
                        options.setTmdbId(tmdbId);
                    }
                }
                catch (Exception tmdbId) {}
            } else if (tmdbPattern.matcher(query).matches()) {
                try {
                    int tmdbId = Integer.parseInt(tmdbPattern.matcher(query).replaceAll("$1"));
                    if (tmdbId > 0) {
                        options.setTmdbId(tmdbId);
                    }
                }
                catch (Exception tmdbId) {}
            } else if (query.startsWith("tvdb:")) {
                try {
                    int tvdbId = Integer.parseInt(query.replace("tvdb:", ""));
                    if (tvdbId > 0) {
                        options.setId("tvdb", tvdbId);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            options.setSearchQuery(searchTerm);
        }
        if (year > 0) {
            options.setSearchYear(year);
        }
        LOGGER.info("Search '{}' for TV show title '{}'", (Object)provider.getProviderInfo().getId(), (Object)searchTerm);
        LOGGER.debug("=====================================================");
        LOGGER.debug("Searching with scraper: {}", (Object)provider.getProviderInfo().getId());
        LOGGER.debug("options: {}", (Object)options);
        LOGGER.debug("=====================================================");
        results.addAll(provider.search(options).stream().filter(mediaSearchResult -> !mediaSearchResult.getIds().isEmpty() && StringUtils.isNotBlank((CharSequence)mediaSearchResult.getTitle())).toList());
        if (results.isEmpty() && options.getSearchQuery().matches("^\\d{4}.*")) {
            TvShowSearchAndScrapeOptions o = new TvShowSearchAndScrapeOptions(options);
            o.setSearchQuery(options.getSearchQuery().substring(4));
            LOGGER.debug("=====================================================");
            LOGGER.debug("Searching again without year in title: {}", (Object)provider.getProviderInfo().getId());
            LOGGER.debug("options: {}", (Object)o);
            LOGGER.debug("=====================================================");
            results.addAll(provider.search(o).stream().filter(mediaSearchResult -> !mediaSearchResult.getIds().isEmpty() && StringUtils.isNotBlank((CharSequence)mediaSearchResult.getTitle())).toList());
        }
        return new ArrayList<MediaSearchResult>(results);
    }

    private void updateTvShowLists(Collection<TvShow> tvShows) {
        TmmTaskManager.getInstance().addUiTask(() -> {
            this.updateTvShowTags(tvShows);
            this.updateCertification(tvShows);
            this.firePropertyChange("episodeCount", 0, 1);
        });
    }

    private void updateTvShowTags(Collection<TvShow> tvShows) {
        TreeSet tags = new TreeSet();
        tvShows.forEach(tvShow -> tags.addAll(tvShow.getTags()));
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.tagsInTvShows, tags)) {
            Utils.removeDuplicateStringFromCollectionIgnoreCase(this.tagsInTvShows);
            this.firePropertyChange("tags", null, this.tagsInTvShows);
        }
    }

    private void updateTvShowTags() {
        TreeSet tags = new TreeSet();
        this.tvShows.forEach(tvShow -> tags.addAll(tvShow.getTags()));
        if (tags.hashCode() != this.tagsInTvShows.hashCode()) {
            this.tagsInTvShows.clear();
            this.tagsInTvShows.addAll(tags);
            Utils.removeDuplicateStringFromCollectionIgnoreCase(this.tagsInTvShows);
            this.firePropertyChange("tags", null, this.tagsInTvShows);
        }
    }

    private void updateCertification(Collection<TvShow> tvShows) {
        TreeSet certifications = new TreeSet();
        tvShows.forEach(tvShow -> certifications.add(tvShow.getCertification()));
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.certificationsInTvShows, certifications)) {
            this.firePropertyChange("certification", null, this.certificationsInTvShows);
        }
    }

    private void updateCertification() {
        TreeSet certifications = new TreeSet();
        this.tvShows.forEach(tvShow -> certifications.add(tvShow.getCertification()));
        if (certifications.hashCode() != this.certificationsInTvShows.hashCode()) {
            this.certificationsInTvShows.clear();
            this.certificationsInTvShows.addAll(certifications);
            this.firePropertyChange("certification", null, this.certificationsInTvShows);
        }
    }

    public List<String> getTagsInTvShows() {
        return Collections.unmodifiableList(this.tagsInTvShows);
    }

    private void updateEpisodeLists(Collection<TvShowEpisode> episodes) {
        TmmTaskManager.getInstance().addUiTask(() -> {
            this.updateEpisodeTags(episodes);
            this.updateMediaInformationLists(episodes);
        });
    }

    private void updateEpisodeTags(Collection<TvShowEpisode> episodes) {
        TreeSet tags = new TreeSet();
        episodes.forEach(episode -> tags.addAll(episode.getTags()));
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.tagsInEpisodes, tags)) {
            Utils.removeDuplicateStringFromCollectionIgnoreCase(this.tagsInEpisodes);
            this.firePropertyChange("tags", null, this.tagsInEpisodes);
        }
    }

    private void updateEpisodeTags() {
        TreeSet<String> tags = new TreeSet<String>();
        for (TvShow tvShow : this.tvShows) {
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                tags.addAll(episode.getTags());
            }
        }
        if (tags.hashCode() != this.tagsInEpisodes.hashCode()) {
            this.tagsInEpisodes.clear();
            this.tagsInEpisodes.addAll(tags);
            Utils.removeDuplicateStringFromCollectionIgnoreCase(this.tagsInEpisodes);
            this.firePropertyChange("tags", null, this.tagsInEpisodes);
        }
    }

    public Collection<String> getTagsInEpisodes() {
        return Collections.unmodifiableList(this.tagsInEpisodes);
    }

    private void updateMediaInformationLists(Collection<TvShowEpisode> episodes) {
        HashSet<String> videoCodecs = new HashSet<String>();
        HashSet<Double> frameRates = new HashSet<Double>();
        HashMap<String, String> videoContainers = new HashMap<String, String>();
        HashSet<String> audioCodecs = new HashSet<String>();
        HashSet<Integer> audioChannels = new HashSet<Integer>();
        HashSet<Integer> audioStreamCount = new HashSet<Integer>();
        HashSet<String> audioLanguages = new HashSet<String>();
        HashSet<Integer> subtitleStreamCount = new HashSet<Integer>();
        HashSet<String> subtitleLanguages = new HashSet<String>();
        HashSet<String> hdrFormat = new HashSet<String>();
        HashSet<String> audioTitles = new HashSet<String>();
        HashSet<String> subtitleFormats = new HashSet<String>();
        for (TvShowEpisode episode : episodes) {
            int audioCount = 0;
            int subtitleCount = 0;
            boolean first = true;
            for (MediaFile mf : episode.getMediaFiles(MediaFileType.VIDEO)) {
                if (StringUtils.isNotBlank((CharSequence)mf.getVideoCodec())) {
                    videoCodecs.add(mf.getVideoCodec());
                }
                if (mf.getFrameRate() > 0.0) {
                    frameRates.add(mf.getFrameRate());
                }
                if (StringUtils.isNotBlank((CharSequence)mf.getContainerFormat())) {
                    videoContainers.putIfAbsent(mf.getContainerFormat().toLowerCase(Locale.ROOT), mf.getContainerFormat());
                }
                for (MediaFileAudioStream audio : mf.getAudioStreams()) {
                    if (StringUtils.isNotBlank((CharSequence)audio.getCodec())) {
                        audioCodecs.add(audio.getCodec());
                    }
                    audioChannels.add(audio.getAudioChannels());
                }
                if (first) {
                    audioCount = mf.getAudioStreams().size();
                    audioLanguages.addAll(mf.getAudioLanguagesList());
                    audioTitles.addAll(mf.getAudioTitleList());
                    subtitleCount = mf.getSubtitles().size();
                    if (!mf.getHdrFormat().isEmpty()) {
                        String[] hdrs = mf.getHdrFormat().split(", ");
                        hdrFormat.addAll(Arrays.asList(hdrs));
                    }
                }
                first = false;
            }
            for (MediaFile mf : episode.getMediaFiles(MediaFileType.VIDEO, MediaFileType.SUBTITLE)) {
                if (!mf.getSubtitleLanguages().isEmpty()) {
                    subtitleLanguages.addAll(mf.getSubtitleLanguages());
                }
                for (MediaFileSubtitle subtitle : mf.getSubtitles()) {
                    if (subtitle.getCodec().isEmpty()) continue;
                    subtitleFormats.add(subtitle.getCodec());
                }
            }
            for (MediaFile mf : episode.getMediaFiles(MediaFileType.AUDIO)) {
                ++audioCount;
                audioLanguages.addAll(mf.getAudioLanguagesList());
                audioTitles.addAll(mf.getAudioTitleList());
            }
            audioStreamCount.add(audioCount);
            subtitleStreamCount.add(subtitleCount);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.videoCodecsInEpisodes, videoCodecs)) {
            this.firePropertyChange("videoCodec", null, this.videoCodecsInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.frameRatesInEpisodes, frameRates)) {
            this.firePropertyChange("frameRate", null, this.frameRatesInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.videoContainersInEpisodes, videoContainers.values())) {
            this.firePropertyChange("videoContainer", null, this.videoContainersInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioCodecsInEpisodes, audioCodecs)) {
            this.firePropertyChange("audioCodec", null, this.audioCodecsInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioChannelsInEpisodes, audioChannels)) {
            this.firePropertyChange("audioChannel", null, this.audioChannelsInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioStreamsInEpisodes, audioStreamCount)) {
            this.firePropertyChange("audioStreams", null, this.audioStreamsInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioLanguagesInEpisodes, audioLanguages)) {
            this.firePropertyChange("audioLanugages", null, this.audioLanguagesInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.subtitlesInEpisodes, subtitleStreamCount)) {
            this.firePropertyChange("countSubtitles", null, this.subtitlesInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.subtitleLanguagesInEpisodes, subtitleLanguages)) {
            this.firePropertyChange("subtitleLanguages", null, this.subtitleLanguagesInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.subtitleFormatsInEpisodes, subtitleFormats)) {
            this.firePropertyChange("subtitleFormats", null, this.subtitleFormatsInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.hdrFormatInEpisodes, hdrFormat)) {
            this.firePropertyChange("hdrFormat", null, this.hdrFormatInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioTitlesInEpisodes, audioTitles)) {
            this.firePropertyChange("audioTitle", null, this.audioTitlesInEpisodes);
        }
    }

    public Collection<String> getVideoCodecsInEpisodes() {
        return Collections.unmodifiableList(this.videoCodecsInEpisodes);
    }

    public Collection<String> getVideoContainersInEpisodes() {
        return Collections.unmodifiableList(this.videoContainersInEpisodes);
    }

    public Collection<Double> getFrameRatesInEpisodes() {
        return Collections.unmodifiableList(this.frameRatesInEpisodes);
    }

    public Collection<String> getAudioCodecsInEpisodes() {
        return Collections.unmodifiableList(this.audioCodecsInEpisodes);
    }

    public Collection<Integer> getAudioChannelsInEpisodes() {
        return Collections.unmodifiableList(this.audioChannelsInEpisodes);
    }

    public Collection<MediaCertification> getCertification() {
        return Collections.unmodifiableList(this.certificationsInTvShows);
    }

    public Collection<Integer> getAudioStreamsInEpisodes() {
        return Collections.unmodifiableList(this.audioStreamsInEpisodes);
    }

    public Collection<Integer> getSubtitlesInEpisodes() {
        return Collections.unmodifiableList(this.subtitlesInEpisodes);
    }

    public Collection<String> getAudioLanguagesInEpisodes() {
        return Collections.unmodifiableList(this.audioLanguagesInEpisodes);
    }

    public Collection<String> getSubtitleLanguagesInEpisodes() {
        return Collections.unmodifiableList(this.subtitleLanguagesInEpisodes);
    }

    public Collection<String> getSubtitleFormatsInEpisodes() {
        return Collections.unmodifiableList(this.subtitleFormatsInEpisodes);
    }

    public Collection<String> getHdrFormatInEpisodes() {
        return Collections.unmodifiableList(this.hdrFormatInEpisodes);
    }

    public Collection<String> getAudioTitlesInEpisodes() {
        return Collections.unmodifiableList(this.audioTitlesInEpisodes);
    }

    public TvShow getTvShowByPath(Path path) {
        for (TvShow tvShow : this.tvShows) {
            if (tvShow.getPathNIO().compareTo(path.toAbsolutePath()) != 0) continue;
            return tvShow;
        }
        return null;
    }

    public static List<TvShowEpisode> getTvEpisodesByFile(TvShow tvShow, Path file) {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(1);
        if (file == null) {
            return episodes;
        }
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(tvShow.getEpisodes())) {
            for (MediaFile mediaFile : new ArrayList<MediaFile>(episode.getMediaFiles())) {
                if (!file.equals(mediaFile.getFile())) continue;
                episodes.add(episode);
            }
        }
        return episodes;
    }

    public void invalidateTitleSortable() {
        ((Stream)this.tvShows.stream().parallel()).forEach(tvShow -> {
            tvShow.clearTitleSortable();
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                episode.clearTitleSortable();
            }
        });
    }

    public List<TvShow> getNewTvShows() {
        return this.tvShows.parallelStream().filter(MediaEntity::isNewlyAdded).sorted().collect(Collectors.toList());
    }

    public List<TvShowEpisode> getNewEpisodes() {
        ArrayList<TvShowEpisode> newEp = new ArrayList<TvShowEpisode>();
        for (TvShow show : this.tvShows) {
            for (TvShowEpisode ep : show.getEpisodes()) {
                if (!ep.isNewlyAdded()) continue;
                newEp.add(ep);
            }
        }
        return newEp;
    }

    public List<TvShowEpisode> getUnscrapedEpisodes() {
        ArrayList<TvShowEpisode> newEp = new ArrayList<TvShowEpisode>();
        for (TvShow show : this.tvShows) {
            for (TvShowEpisode ep : show.getEpisodes()) {
                if (ep.isScraped()) continue;
                newEp.add(ep);
            }
        }
        return newEp;
    }

    private void checkAndCleanupMediaFiles() {
        boolean problemsDetected = false;
        for (TvShow tvShow : this.tvShows) {
            for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(tvShow.getEpisodes())) {
                List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO);
                if (!mfs.isEmpty()) continue;
                tvShow.removeEpisode(episode);
                problemsDetected = true;
            }
        }
        if (problemsDetected) {
            LOGGER.debug("episodes without VIDEOs detected");
            Thread thread = new Thread(() -> {
                try {
                    Thread.sleep(15000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Message message = new Message(Message.MessageLevel.SEVERE, "tmm.tvshows", "message.database.corrupteddata");
                MessageManager.getInstance().pushMessage(message);
            });
            thread.start();
        }
    }

    public List<MediaScraper> getAvailableSubtitleScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.TVSHOW_SUBTITLE);
        availableScrapers.sort(new TvShowMediaScraperComparator());
        return availableScrapers;
    }

    public List<MediaScraper> getDefaultSubtitleScrapers() {
        List<MediaScraper> defaultScrapers = this.getSubtitleScrapers(TvShowModuleManager.getInstance().getSettings().getSubtitleScrapers());
        return defaultScrapers.stream().filter(MediaScraper::isActive).toList();
    }

    public List<MediaScraper> getDefaultTrailerScrapers() {
        List<MediaScraper> defaultScrapers = this.getTrailerScrapers(TvShowModuleManager.getInstance().getSettings().getTrailerScrapers());
        return defaultScrapers.stream().filter(MediaScraper::isActive).toList();
    }

    public List<MediaScraper> getSubtitleScrapers(List<String> providerIds) {
        ArrayList<MediaScraper> subtitleScrapers = new ArrayList<MediaScraper>();
        for (String providerId : providerIds) {
            MediaScraper subtitleScraper;
            if (StringUtils.isBlank((CharSequence)providerId) || (subtitleScraper = MediaScraper.getMediaScraperById(providerId, ScraperType.TVSHOW_SUBTITLE)) == null) continue;
            subtitleScrapers.add(subtitleScraper);
        }
        return subtitleScrapers;
    }

    public void searchDuplicateEpisodes() {
        HashMap<CallSite, TvShow> showMap = new HashMap<CallSite, TvShow>();
        HashMap<String, TvShowEpisode> hashMap = new HashMap<String, TvShowEpisode>();
        for (TvShow tvShow : this.getTvShows()) {
            TvShowEpisode duplicate;
            tvShow.clearDuplicate();
            Map<String, Object> ids = tvShow.getIds();
            for (Map.Entry<String, Object> entry : ids.entrySet()) {
                if ("tmdbSet".equalsIgnoreCase(entry.getKey()) || "tmdbcol".equalsIgnoreCase(entry.getKey())) continue;
                String id = entry.getKey() + entry.getValue();
                if (showMap.containsKey(id)) {
                    tvShow.setDuplicate();
                    TvShow show2 = (TvShow)showMap.get(id);
                    show2.setDuplicate();
                    LOGGER.info("Duplicate check: TV shows have the same ID ({}): {} <=> {}", new Object[]{id, tvShow.getTitle(), show2.getTitle()});
                    continue;
                }
                showMap.put((CallSite)((Object)id), tvShow);
            }
            HashMap<CallSite, TvShowEpisode> episodeMap = new HashMap<CallSite, TvShowEpisode>();
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                episode.clearDuplicate();
                if (episode.getSeason() == -1 || episode.getEpisode() == -1) continue;
                String se = "S" + episode.getSeason() + "E" + episode.getEpisode();
                duplicate = (TvShowEpisode)episodeMap.get(se);
                if (duplicate != null) {
                    duplicate.setDuplicate();
                    episode.setDuplicate();
                    LOGGER.info("Duplicate check: episodes have the same number ({}) in show {}", (Object)se, (Object)tvShow.getTitle());
                    continue;
                }
                episodeMap.put((CallSite)((Object)se), episode);
            }
            episodeMap.clear();
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                String crc = episode.getCRC32();
                if (crc.isEmpty()) continue;
                duplicate = (TvShowEpisode)hashMap.get(crc);
                if (duplicate != null) {
                    duplicate.setDuplicate();
                    episode.setDuplicate();
                    LOGGER.info("Duplicate check: files have the same hash ({}): {} <=> {}", new Object[]{crc, episode.getMainFile().getFileAsPath().toAbsolutePath(), duplicate.getMainFile().getFileAsPath().toAbsolutePath()});
                    continue;
                }
                hashMap.put(crc, episode);
            }
        }
        hashMap.clear();
        showMap.clear();
    }

    public List<TvShowScraperMetadataConfig> detectMissingMetadata(TvShow tvShow) {
        return this.detectMissingFields(tvShow, TvShowModuleManager.getInstance().getSettings().getTvShowCheckMetadata());
    }

    public List<TvShowScraperMetadataConfig> detectMissingArtwork(TvShow tvShow) {
        return this.detectMissingFields(tvShow, TvShowModuleManager.getInstance().getSettings().getTvShowCheckArtwork());
    }

    public List<TvShowScraperMetadataConfig> detectMissingFields(TvShow tvshow, List<TvShowScraperMetadataConfig> toCheck) {
        ArrayList<TvShowScraperMetadataConfig> missingMetadata = new ArrayList<TvShowScraperMetadataConfig>();
        for (TvShowScraperMetadataConfig metadataConfig : toCheck) {
            Number number;
            String string;
            Object value = tvshow.getValueForMetadata(metadataConfig);
            if (value == null) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof String && StringUtils.isBlank((CharSequence)(string = (String)value))) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Number && (number = (Number)value).intValue() <= 0) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Collection && ((Collection)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Map && ((Map)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value != MediaCertification.UNKNOWN) continue;
            missingMetadata.add(metadataConfig);
        }
        return missingMetadata;
    }

    public List<TvShowScraperMetadataConfig> detectMissingMetadata(TvShowSeason season) {
        if (season.isDummy()) {
            return Collections.emptyList();
        }
        ArrayList<TvShowScraperMetadataConfig> seasonValues = new ArrayList<TvShowScraperMetadataConfig>();
        for (TvShowScraperMetadataConfig config : TvShowModuleManager.getInstance().getSettings().getTvShowCheckMetadata()) {
            if (!config.isMetaData() || !config.name().startsWith("SEASON")) continue;
            seasonValues.add(config);
        }
        return this.detectMissingFields(season, seasonValues);
    }

    public List<TvShowScraperMetadataConfig> detectMissingArtwork(TvShowSeason season) {
        return this.detectMissingFields(season, TvShowModuleManager.getInstance().getSettings().getSeasonCheckArtwork());
    }

    public List<TvShowScraperMetadataConfig> detectMissingFields(TvShowSeason season, List<TvShowScraperMetadataConfig> toCheck) {
        ArrayList<TvShowScraperMetadataConfig> missingMetadata = new ArrayList<TvShowScraperMetadataConfig>();
        for (TvShowScraperMetadataConfig metadataConfig : toCheck) {
            Number number;
            String string;
            Object value = season.getValueForMetadata(metadataConfig);
            if (value == null) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof String && StringUtils.isBlank((CharSequence)(string = (String)value))) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Number && (number = (Number)value).intValue() <= 0) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Collection && ((Collection)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Map && ((Map)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value != MediaCertification.UNKNOWN) continue;
            missingMetadata.add(metadataConfig);
        }
        return missingMetadata;
    }

    public List<TvShowEpisodeScraperMetadataConfig> detectMissingMetadata(TvShowEpisode episode) {
        if (episode.isDummy() || episode.getSeason() == 0 && !TvShowModuleManager.getInstance().getSettings().isEpisodeSpecialsCheckMissingMetadata()) {
            return Collections.emptyList();
        }
        return this.detectMissingFields(episode, TvShowModuleManager.getInstance().getSettings().getEpisodeCheckMetadata());
    }

    public List<TvShowEpisodeScraperMetadataConfig> detectMissingArtwork(TvShowEpisode episode) {
        if (episode.isDummy() || episode.getSeason() == 0 && !TvShowModuleManager.getInstance().getSettings().isEpisodeSpecialsCheckMissingArtwork()) {
            return Collections.emptyList();
        }
        return this.detectMissingFields(episode, TvShowModuleManager.getInstance().getSettings().getEpisodeCheckArtwork());
    }

    public List<TvShowEpisodeScraperMetadataConfig> detectMissingFields(TvShowEpisode episode, List<TvShowEpisodeScraperMetadataConfig> toCheck) {
        ArrayList<TvShowEpisodeScraperMetadataConfig> missingMetadata = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
        for (TvShowEpisodeScraperMetadataConfig metadataConfig : toCheck) {
            Number number;
            String string;
            Object value = episode.getValueForMetadata(metadataConfig);
            if (value == null) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof String && StringUtils.isBlank((CharSequence)(string = (String)value))) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Number && (number = (Number)value).intValue() <= 0) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Collection && ((Collection)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Map && ((Map)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value != MediaCertification.UNKNOWN) continue;
            missingMetadata.add(metadataConfig);
        }
        return missingMetadata;
    }

    private static class TvShowMediaScraperComparator
    implements Comparator<MediaScraper> {
        private TvShowMediaScraperComparator() {
        }

        @Override
        public int compare(MediaScraper o1, MediaScraper o2) {
            if (o1.getPriority() == o2.getPriority()) {
                return o1.getId().compareTo(o2.getId());
            }
            return Integer.compare(o2.getPriority(), o1.getPriority());
        }
    }
}

