/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieArtworkHelper;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.MovieSetSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieSetMetadataProvider;

public class MovieAssignMovieSetTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieAssignMovieSetTask.class);
    private final List<Movie> moviesToScrape;

    public MovieAssignMovieSetTask(List<Movie> moviesToScrape) {
        super(TmmResourceBundle.getString("movie.assignmovieset"));
        this.moviesToScrape = new ArrayList<Movie>(moviesToScrape);
    }

    @Override
    protected void doInBackground() {
        LOGGER.info("Assigning '{}' movies to movie sets", (Object)this.moviesToScrape.size());
        this.initThreadPool(1, "scrape");
        this.start();
        for (Movie movie : this.moviesToScrape) {
            this.submitTask(new Worker(movie));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Finished assigning movies to movie sets - took {} ms", (Object)this.getRuntime());
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }

    private static class Worker
    implements Runnable {
        private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();
        private final Movie movie;

        public Worker(Movie movie) {
            this.movie = movie;
        }

        @Override
        public void run() {
            block18: {
                if (this.movie.getMovieSet() != null) {
                    return;
                }
                try {
                    MediaScraper movieScraper = MediaScraper.getMediaScraperById("tmdb", ScraperType.MOVIE);
                    MediaScraper movieSetScraper = MediaScraper.getMediaScraperById("tmdb", ScraperType.MOVIE_SET);
                    MovieSearchAndScrapeOptions movieOptions = new MovieSearchAndScrapeOptions();
                    movieOptions.setLanguage(MovieModuleManager.getInstance().getSettings().getScraperLanguage());
                    movieOptions.setCertificationCountry(MovieModuleManager.getInstance().getSettings().getCertificationCountry());
                    movieOptions.setReleaseDateCountry(MovieModuleManager.getInstance().getSettings().getReleaseDateCountry());
                    for (Map.Entry<String, Object> entry : this.movie.getIds().entrySet()) {
                        movieOptions.setId(entry.getKey(), entry.getValue().toString());
                    }
                    MediaMetadata md = ((IMovieMetadataProvider)movieScraper.getMediaProvider()).getMetadata(movieOptions);
                    int collectionId = 0;
                    try {
                        collectionId = (Integer)md.getId("tmdbSet");
                    }
                    catch (Exception e) {
                        LOGGER.debug("Could not parse collection Id: {}", md.getId("tmdbSet"));
                    }
                    if (collectionId <= 0) break block18;
                    String collectionName = md.getCollectionName();
                    MovieSet movieSet = this.movieList.getMovieSet(collectionName, collectionId);
                    if (movieSet != null && movieSet.getTmdbId() == 0) {
                        movieSet.setTmdbId(collectionId);
                        try {
                            MovieSetSearchAndScrapeOptions movieSetOptions = new MovieSetSearchAndScrapeOptions();
                            movieSetOptions.setTmdbId(collectionId);
                            movieSetOptions.setLanguage(MovieModuleManager.getInstance().getSettings().getScraperLanguage());
                            MediaMetadata info = ((IMovieSetMetadataProvider)movieSetScraper.getMediaProvider()).getMetadata(movieSetOptions);
                            if (info != null && StringUtils.isNotBlank((CharSequence)info.getTitle())) {
                                int preferredSizeOrder;
                                movieSet.setTitle(info.getTitle());
                                movieSet.setPlot(info.getPlot());
                                if (!info.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).isEmpty()) {
                                    preferredSizeOrder = MovieModuleManager.getInstance().getSettings().getImagePosterSize().getOrder();
                                    List<MediaArtwork.ImageSizeAndUrl> sortedPosters = MovieArtworkHelper.sortArtworkUrls(info.getMediaArt(), MediaArtwork.MediaArtworkType.POSTER, preferredSizeOrder);
                                    if (!sortedPosters.isEmpty()) {
                                        movieSet.setArtworkUrl(sortedPosters.get(0).getUrl(), MediaFileType.POSTER);
                                    }
                                }
                                if (!info.getMediaArt(MediaArtwork.MediaArtworkType.BACKGROUND).isEmpty()) {
                                    preferredSizeOrder = MovieModuleManager.getInstance().getSettings().getImageFanartSize().getOrder();
                                    List<MediaArtwork.ImageSizeAndUrl> sortedFanarts = MovieArtworkHelper.sortArtworkUrls(info.getMediaArt(), MediaArtwork.MediaArtworkType.BACKGROUND, preferredSizeOrder);
                                    if (!sortedFanarts.isEmpty()) {
                                        movieSet.setArtworkUrl(sortedFanarts.get(0).getUrl(), MediaFileType.FANART);
                                    }
                                }
                            }
                        }
                        catch (MissingIdException | NothingFoundException e) {
                            LOGGER.warn("Could not fetch movie set data - {}", (Object)e.getMessage());
                        }
                        catch (ScrapeException e) {
                            LOGGER.error("getMovieSet", (Throwable)e);
                            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movie, "message.scrape.metadatamoviesetfailed", new String[]{":", e.getLocalizedMessage()}));
                        }
                    }
                    if (movieSet != null) {
                        this.movie.setMovieSet(null);
                        this.movie.setMovieSet(movieSet);
                        movieSet.insertMovie(this.movie);
                        this.movie.writeNFO();
                        this.movie.saveToDb();
                        movieSet.saveToDb();
                    }
                }
                catch (MissingIdException e) {
                    LOGGER.warn("Missing IDs for scraping '{}'", (Object)this.movie.getTitle());
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, this.movie, "scraper.error.missingid"));
                }
                catch (NothingFoundException e) {
                    LOGGER.info("No movie set data found for movie '{}'", (Object)this.movie.getTitle());
                }
                catch (ScrapeException e) {
                    LOGGER.error("Could not net movie set data for movie '{}' - '{}'", (Object)this.movie.getTitle(), (Object)e.getMessage());
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movie, "message.scrape.metadatamoviesetfailed", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        }
    }
}

