/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.movie.connector.MovieNfoParser;
import org.tinymediamanager.core.movie.connector.MovieToKodiConnector;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.w3c.dom.Element;

public class MovieToEmbyConnector
extends MovieToKodiConnector {
    public MovieToEmbyConnector(Movie movie) {
        super(movie);
    }

    @Override
    protected void addSet() {
        Element set = this.document.createElement("set");
        MovieSet movieSet = this.movie.getMovieSet();
        if (movieSet != null) {
            if (movieSet.getTmdbId() > 0) {
                set.setAttribute("tmdbcolid", String.valueOf(movieSet.getTmdbId()));
            }
            Element name = this.document.createElement("name");
            name.setTextContent(this.movie.getMovieSet().getTitle());
            set.appendChild(name);
            Element overview = this.document.createElement("overview");
            overview.setTextContent(this.movie.getMovieSet().getPlot());
            set.appendChild(overview);
        }
        this.root.appendChild(set);
        if (this.parser != null && !this.parser.sets.isEmpty()) {
            for (MovieNfoParser.Set parserSet : this.parser.sets) {
                if (movieSet != null && (StringUtils.equals((CharSequence)movieSet.getTitle(), (CharSequence)parserSet.name) || movieSet.getTmdbId() > 0 && movieSet.getTmdbId() == parserSet.tmdbId)) continue;
                set = this.document.createElement("set");
                if (parserSet.tmdbId > 0) {
                    set.setAttribute("tmdbcolid", String.valueOf(parserSet));
                }
                Element name = this.document.createElement("name");
                name.setTextContent(parserSet.name);
                set.appendChild(name);
                Element overview = this.document.createElement("overview");
                overview.setTextContent(parserSet.overview);
                set.appendChild(overview);
                this.root.appendChild(set);
            }
        }
    }

    @Override
    protected void addCredits() {
    }

    @Override
    protected void addDirectors() {
    }

    @Override
    protected void addActors() {
        super.addActors();
        super.addCredits();
        super.addDirectors();
    }
}

