/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.util;

import com.hdcookbook.grin.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class BitStreamIO {
    private int bitsProcessed = 0;
    private int buf = 0;
    private static final int[] maskArr = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};

    public int readBits(DataInputStream dataInputStream, int n) throws IOException {
        if (n < 0 || n > 32) {
            Debug.assertFail();
        }
        int n2 = 0;
        int n3 = 8 - (this.bitsProcessed & 7) & 7;
        this.bitsProcessed += n;
        while (n > 0) {
            int n4;
            if (n3 == 0) {
                this.buf = dataInputStream.readByte() & 0xFF;
                n3 = 8;
            }
            if (n >= n3) {
                n2 <<= n3;
                n4 = maskArr[n3];
                n2 |= this.buf & n4;
                n -= n3;
                n3 = 0;
                continue;
            }
            n2 <<= n;
            n4 = this.buf >> (n3 -= n);
            int n5 = maskArr[n];
            n2 |= n4 & n5;
            n = 0;
        }
        return n2;
    }

    public long readBitsLong(DataInputStream dataInputStream, int n) throws IOException {
        if (n < 0 || n > 64) {
            Debug.assertFail();
        }
        long l = 0L;
        int n2 = 8 - (this.bitsProcessed & 7) & 7;
        this.bitsProcessed += n;
        while (n > 0) {
            int n3;
            if (n2 == 0) {
                this.buf = dataInputStream.readByte() & 0xFF;
                n2 = 8;
            }
            if (n >= n2) {
                l <<= n2;
                n3 = maskArr[n2];
                l |= (long)(this.buf & n3);
                n -= n2;
                n2 = 0;
                continue;
            }
            l <<= n;
            n3 = this.buf >> (n2 -= n);
            int n4 = maskArr[n];
            l |= (long)(n3 & n4);
            n = 0;
        }
        return l;
    }

    public void writeBits(DataOutputStream dataOutputStream, int n, int n2) throws IOException {
        if (n < 0 || n > 32) {
            Debug.assertFail();
        }
        int n3 = this.bitsProcessed & 7;
        this.bitsProcessed += n;
        while (n > 0) {
            int n4;
            int n5;
            if (n3 > 0) {
                n5 = 8 - n3;
                if (n5 <= n) {
                    n4 = maskArr[n5];
                    this.buf |= n2 >> n - n5 & n4;
                    n -= n5;
                    n3 += n5;
                } else {
                    n4 = maskArr[n];
                    int n6 = n2 & n4;
                    this.buf |= n6 << n5 - n;
                    n3 += n;
                    n = 0;
                }
            } else if (n >= 8) {
                this.buf = n2 >> n - 8;
                n -= 8;
                n3 = 8;
            } else {
                n5 = maskArr[n];
                n4 = n2 & n5;
                this.buf |= n4 << 8 - n;
                n3 = n;
                n = 0;
            }
            if (n3 != 8) continue;
            dataOutputStream.write(this.buf);
            this.buf = 0;
            n3 = 0;
        }
    }

    public void writeBitsLong(DataOutputStream dataOutputStream, int n, long l) throws IOException {
        if (n < 0 || n > 64) {
            Debug.assertFail();
        }
        int n2 = this.bitsProcessed & 7;
        this.bitsProcessed += n;
        while (n > 0) {
            int n3;
            int n4;
            if (n2 > 0) {
                n4 = 8 - n2;
                if (n4 <= n) {
                    n3 = maskArr[n4];
                    this.buf = (int)((long)this.buf | l >> n - n4 & (long)n3);
                    n -= n4;
                    n2 += n4;
                } else {
                    long l2 = maskArr[n];
                    int n5 = (int)(l & l2);
                    this.buf |= n5 << n4 - n;
                    n2 += n;
                    n = 0;
                }
            } else if (n >= 8) {
                this.buf = (int)(l >> n - 8);
                n -= 8;
                n2 = 8;
            } else {
                n4 = maskArr[n];
                n3 = (int)(l & (long)n4);
                this.buf |= n3 << 8 - n;
                n2 = n;
                n = 0;
            }
            if (n2 != 8) continue;
            dataOutputStream.write(this.buf);
            this.buf = 0;
            n2 = 0;
        }
    }

    public void assertByteAligned(int n) {
        int n2 = n * 8;
        int n3 = this.bitsProcessed % n2;
        if (n3 != 0) {
            Debug.assertFail(n3 + " stray bits.");
        }
    }

    public int getBitsProcessed() {
        return this.bitsProcessed;
    }
}

