/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf;

import com.github.stephenc.javaisotools.loopfs.spi.AbstractBlockFileSystem;
import com.github.stephenc.javaisotools.loopfs.spi.SeekableInput;
import com.github.stephenc.javaisotools.loopfs.spi.SeekableInputFile;
import com.github.stephenc.javaisotools.loopfs.spi.VolumeDescriptorSet;
import com.github.stephenc.javaisotools.loopfs.udf.UDFEntryInputStream;
import com.github.stephenc.javaisotools.loopfs.udf.UDFEntryIterator;
import com.github.stephenc.javaisotools.loopfs.udf.UDFFileEntry;
import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.UDFVolumeDescriptorSet;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.AnchorDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ExtentAD;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.UnsupportedStandard;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class UDFFileSystem
extends AbstractBlockFileSystem<UDFFileEntry> {
    private AnchorDescriptor anchor;
    public long maxBlock = 0L;

    public UDFFileSystem(File file, boolean bl) throws IOException {
        this((SeekableInput)new SeekableInputFile(file), bl, 2048);
    }

    public UDFFileSystem(SeekableInput seekableInput, boolean bl, Integer n) throws IOException {
        super(seekableInput, bl, n.intValue(), 16);
        try {
            this.verifyStandard();
        }
        catch (UnsupportedStandard unsupportedStandard) {
            throw new IOException("Unsupported standard");
        }
        try {
            this.maxBlock = seekableInput.getFilesize() / 2048L - 1L;
            this.loadAnchor();
        }
        catch (InvalidDescriptor invalidDescriptor) {
            throw new IOException("Invalid Anchor Volume Pointer Descriptor");
        }
        this.setReservedBlocks(this.anchor.mainVolumeExtent.location.intValue());
    }

    public InputStream getInputStream(UDFFileEntry uDFFileEntry) {
        this.ensureOpen();
        return new UDFEntryInputStream(uDFFileEntry, this);
    }

    public int readBytes(long l, byte[] byArray, int n, int n2) throws IOException {
        return this.readData(l, byArray, n, n2);
    }

    public int readFileContent(UDFFileEntry uDFFileEntry, long l, byte[] byArray, int n, int n2) throws IOException {
        if (uDFFileEntry.isDirectory()) {
            throw new IOException("Entry is a directory");
        }
        int n3 = 2048;
        int n4 = 0;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = (long)n2 + l;
        for (ExtentAD extentAD : uDFFileEntry.getADs()) {
            if (extentAD.length == 0L) continue;
            long l5 = extentAD.length;
            long l6 = this.getPDStartPos() + extentAD.location;
            if ((l2 += l5) <= l) {
                l3 += l5;
                continue;
            }
            long l7 = l3 < l ? l - l3 : 0L;
            long l8 = l2 < l4 ? l2 - l : l4 - Math.max(l3, l);
            if (l8 == 0L) break;
            long l9 = (long)n3 * l6 + l7;
            int n5 = this.readData(l9, byArray, n, (int)l8);
            l3 += l5;
            if ((long)n5 < l8) {
                n4 += n5;
                break;
            }
            n4 = (int)((long)n4 + l8);
            n = (int)((long)n + l8);
            if (n4 == n2) break;
            if (n4 <= n2) continue;
            throw new IOException("byte array has been read is longer than expected");
        }
        return n4;
    }

    protected Iterator<UDFFileEntry> iterator(UDFFileEntry uDFFileEntry) {
        UDFVolumeDescriptorSet uDFVolumeDescriptorSet = this.getUDFDescriptorSet();
        UDFFileEntry uDFFileEntry2 = (UDFFileEntry)uDFVolumeDescriptorSet.getRootEntry();
        return new UDFEntryIterator(this, uDFFileEntry2);
    }

    protected VolumeDescriptorSet<UDFFileEntry> createVolumeDescriptorSet() {
        return new UDFVolumeDescriptorSet(this);
    }

    private void loadAnchor() throws IOException, InvalidDescriptor {
        byte[] byArray = new byte[2048];
        boolean bl = false;
        bl = this.readBlock(256L, byArray);
        int n = UDFUtil.getUInt16(byArray, 0);
        if (!bl || n != 2) {
            bl = this.readBlock(this.maxBlock - 256L, byArray);
            n = UDFUtil.getUInt16(byArray, 0);
        }
        if (!bl || n != 2) {
            bl = this.readBlock(this.maxBlock, byArray);
            n = UDFUtil.getUInt16(byArray, 0);
        }
        if (!bl || n != 2) {
            bl = this.readBlock(512L, byArray);
            n = UDFUtil.getUInt16(byArray, 0);
        }
        this.anchor = new AnchorDescriptor(byArray);
    }

    public AnchorDescriptor getAnchor() {
        return this.anchor;
    }

    public UDFVolumeDescriptorSet getUDFDescriptorSet() {
        if (null == this.volumeDescriptorSet) {
            try {
                this.loadVolumeDescriptors();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return (UDFVolumeDescriptorSet)this.getVolumeDescriptorSet();
    }

    public long getPDStartPos() {
        UDFVolumeDescriptorSet uDFVolumeDescriptorSet = this.getUDFDescriptorSet();
        return uDFVolumeDescriptorSet.getPDStartPos();
    }

    public long getFSDloc() {
        UDFVolumeDescriptorSet uDFVolumeDescriptorSet = this.getUDFDescriptorSet();
        return uDFVolumeDescriptorSet.getFSDloc();
    }

    private void verifyStandard() throws UnsupportedStandard {
    }
}

