/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.util.VersionUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SysProps {
    public static String appDir() {
        return System.getProperty("appdir");
    }

    public static String appId() {
        return System.getProperty("appid");
    }

    public static String appBase() {
        return System.getProperty("appbase");
    }

    public static boolean noLogRedir() {
        return System.getProperty("no_log_redir") != null;
    }

    public static boolean debug() {
        return System.getProperty("debug") != null;
    }

    public static String appbaseDomain() {
        return System.getProperty("appbase_domain");
    }

    public static String appbaseOverride() {
        return System.getProperty("appbase_override");
    }

    public static boolean silent() {
        return System.getProperty("silent") != null;
    }

    public static boolean launchInSilent() {
        return "launch".equals(System.getProperty("silent"));
    }

    public static boolean noUpdate() {
        return "noupdate".equals(System.getProperty("silent"));
    }

    public static boolean noInstall() {
        return System.getProperty("no_install") != null;
    }

    public static int startDelay() {
        return Math.min(Math.max(Integer.getInteger("delay", 0), 0), 1440);
    }

    public static boolean noUnpack() {
        return Boolean.getBoolean("no_unpack");
    }

    public static boolean direct() {
        return Boolean.getBoolean("direct");
    }

    public static boolean tryNoProxyFirst() {
        return Boolean.getBoolean("try_no_proxy");
    }

    public static int connectTimeout() {
        return Integer.getInteger("connect_timeout", 0);
    }

    public static int readTimeout() {
        return Integer.getInteger("read_timeout", 30);
    }

    public static int threadPoolSize() {
        int defaultSize = Math.max(Runtime.getRuntime().availableProcessors() - 1, 1);
        return Integer.getInteger("thread_pool_size", defaultSize);
    }

    public static long parseJavaVersion(String propName, String propRegex) {
        String verstr = System.getProperty(propName);
        if (verstr == null) {
            throw new IllegalArgumentException("No system property '" + propName + "'.");
        }
        long vers = VersionUtil.parseJavaVersion(propRegex, verstr);
        if (vers == 0L) {
            throw new IllegalArgumentException("Regexp '" + propRegex + "' does not match '" + verstr + "' (from " + propName + ")");
        }
        return vers;
    }

    public static String overrideAppbase(String appbase) {
        String appbaseOverride = SysProps.appbaseOverride();
        if (appbaseOverride != null) {
            return appbaseOverride;
        }
        return SysProps.replaceDomain(appbase);
    }

    public static String replaceDomain(String appbase) {
        String appbaseDomain = SysProps.appbaseDomain();
        if (appbaseDomain != null) {
            Matcher m = Pattern.compile("(https?://[^/]+)(.*)").matcher(appbase);
            appbase = m.replaceAll(appbaseDomain + "$2");
        }
        return appbase;
    }
}

