/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.spi;

import com.github.stephenc.javaisotools.loopfs.api.FileEntry;
import com.github.stephenc.javaisotools.loopfs.api.FileSystem;
import com.github.stephenc.javaisotools.loopfs.spi.SeekableInput;
import java.io.IOException;

public abstract class AbstractFileSystem<T extends FileEntry>
implements FileSystem<T> {
    private SeekableInput channel;

    protected AbstractFileSystem(SeekableInput seekableInput, boolean bl) throws IOException {
        if (!bl) {
            throw new IllegalArgumentException("Currently, only read-only is supported");
        }
        this.channel = seekableInput;
    }

    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.channel.close();
        }
        finally {
            this.channel = null;
        }
    }

    public synchronized boolean isClosed() {
        return null == this.channel;
    }

    protected final void ensureOpen() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("File has been closed");
        }
    }

    protected final void seek(long l) throws IOException {
        this.ensureOpen();
        this.channel.seek(l);
    }

    protected final int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        return this.readFully(byArray, n, n2);
    }

    private int readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n3 = n2; n3 != 0 && (n4 = this.channel.read(byArray, n, n3)) != -1; n3 -= n4) {
            n += n4;
        }
        int n5 = n2 - n3;
        return n5;
    }
}

