/*
 * Decompiled with CFR 0.152.
 */
package de.timroes.axmlrpc;

import de.timroes.axmlrpc.AuthenticationManager;
import de.timroes.axmlrpc.Call;
import de.timroes.axmlrpc.CookieManager;
import de.timroes.axmlrpc.ResponseParser;
import de.timroes.axmlrpc.XMLRPCCallback;
import de.timroes.axmlrpc.XMLRPCException;
import de.timroes.axmlrpc.XMLRPCRuntimeException;
import de.timroes.axmlrpc.XMLRPCServerException;
import de.timroes.axmlrpc.XMLRPCTimeoutException;
import de.timroes.axmlrpc.serializer.SerializerHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class XMLRPCClient {
    private static final String DEFAULT_USER_AGENT = "aXMLRPC";
    static final String USER_AGENT = "User-Agent";
    static final String CONTENT_TYPE = "Content-Type";
    static final String TYPE_XML = "text/xml; charset=utf-8";
    static final String HOST = "Host";
    static final String CONTENT_LENGTH = "Content-Length";
    static final String HTTP_POST = "POST";
    static final String METHOD_RESPONSE = "methodResponse";
    static final String PARAMS = "params";
    static final String PARAM = "param";
    public static final String VALUE = "value";
    static final String FAULT = "fault";
    static final String METHOD_CALL = "methodCall";
    static final String METHOD_NAME = "methodName";
    static final String STRUCT_MEMBER = "member";
    public static final int FLAGS_NONE = 0;
    public static final int FLAGS_STRICT = 1;
    public static final int FLAGS_8BYTE_INT = 2;
    public static final int FLAGS_ENABLE_COOKIES = 4;
    public static final int FLAGS_NIL = 8;
    public static final int FLAGS_IGNORE_STATUSCODE = 16;
    public static final int FLAGS_FORWARD = 32;
    public static final int FLAGS_SSL_IGNORE_INVALID_HOST = 64;
    public static final int FLAGS_SSL_IGNORE_INVALID_CERT = 128;
    public static final int FLAGS_DEFAULT_TYPE_STRING = 256;
    public static final int FLAGS_IGNORE_NAMESPACES = 512;
    public static final int FLAGS_USE_SYSTEM_PROXY = 1024;
    public static final int FLAGS_NO_STRING_DECODE = 2048;
    public static final int FLAGS_NO_STRING_ENCODE = 4096;
    public static final int FLAGS_DEBUG = 8192;
    public static final int FLAGS_ACCEPT_NULL_DATES = 16384;
    public static final int FLAGS_SSL_IGNORE_ERRORS = 192;
    public static final int FLAGS_APACHE_WS = 776;
    private final int flags;
    private URL url;
    private Map<String, String> httpParameters = new ConcurrentHashMap<String, String>();
    private Map<Long, Caller> backgroundCalls = new ConcurrentHashMap<Long, Caller>();
    private ResponseParser responseParser;
    private CookieManager cookieManager;
    private AuthenticationManager authManager;
    private TrustManager[] trustManagers;
    private KeyManager[] keyManagers;
    private Proxy proxy;
    private int timeout;
    private final SerializerHandler serializerHandler;

    public XMLRPCClient(URL url, String userAgent, int flags) {
        this.serializerHandler = new SerializerHandler(flags);
        this.url = url;
        this.flags = flags;
        this.responseParser = new ResponseParser();
        this.cookieManager = new CookieManager(flags);
        this.authManager = new AuthenticationManager();
        this.httpParameters.put(CONTENT_TYPE, TYPE_XML);
        this.httpParameters.put(USER_AGENT, userAgent);
        if (this.isFlagSet(128)) {
            this.trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
        }
        if (this.isFlagSet(1024)) {
            Properties prop = System.getProperties();
            String proxyHost = prop.getProperty("http.proxyHost");
            int proxyPort = Integer.parseInt(prop.getProperty("http.proxyPort", "0"));
            if (proxyPort > 0 && proxyHost.length() > 0 && !proxyHost.equals("null")) {
                this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            }
        }
    }

    public XMLRPCClient(URL url, int flags) {
        this(url, DEFAULT_USER_AGENT, flags);
    }

    public XMLRPCClient(URL url, String userAgent) {
        this(url, userAgent, 0);
    }

    public XMLRPCClient(URL url) {
        this(url, DEFAULT_USER_AGENT, 0);
    }

    public URL getURL() {
        return this.url;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setUserAgentString(String userAgent) {
        this.httpParameters.put(USER_AGENT, userAgent);
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setCustomHttpHeader(String headerName, String headerValue) {
        if (CONTENT_TYPE.equals(headerName) || HOST.equals(headerName) || CONTENT_LENGTH.equals(headerName)) {
            throw new XMLRPCRuntimeException("You cannot modify the Host, Content-Type or Content-Length header.");
        }
        this.httpParameters.put(headerName, headerValue);
    }

    public void setLoginData(String user, String pass) {
        this.authManager.setAuthData(user, pass);
    }

    public void clearLoginData() {
        this.authManager.clearAuthData();
    }

    public Map<String, String> getCookies() {
        return this.cookieManager.getCookies();
    }

    public void clearCookies() {
        this.cookieManager.clearCookies();
    }

    public void installCustomTrustManager(TrustManager trustManager) {
        if (!this.isFlagSet(128)) {
            this.trustManagers = new TrustManager[]{trustManager};
        }
    }

    public void installCustomTrustManagers(TrustManager[] trustManagers) {
        if (!this.isFlagSet(128)) {
            this.trustManagers = (TrustManager[])trustManagers.clone();
        }
    }

    public void installCustomKeyManager(KeyManager keyManager) {
        if (!this.isFlagSet(128)) {
            this.keyManagers = new KeyManager[]{keyManager};
        }
    }

    public void installCustomKeyManagers(KeyManager[] keyManagers) {
        if (!this.isFlagSet(128)) {
            this.keyManagers = (KeyManager[])keyManagers.clone();
        }
    }

    public Object call(String method, Object ... params) throws XMLRPCException {
        return new Caller().call(method, params);
    }

    public long callAsync(XMLRPCCallback listener, String methodName, Object ... params) {
        long id = System.currentTimeMillis();
        new Caller(listener, id, methodName, params).start();
        return id;
    }

    public void cancel(long id) {
        Caller cancel = this.backgroundCalls.get(id);
        if (cancel == null) {
            return;
        }
        cancel.cancel();
        try {
            cancel.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Call createCall(String method, Object[] params) {
        if (this.isFlagSet(1) && !method.matches("^[A-Za-z0-9\\._:/]*$")) {
            throw new XMLRPCRuntimeException("Method name must only contain A-Z a-z . : _ / ");
        }
        return new Call(this.serializerHandler, method, params);
    }

    private boolean isFlagSet(int flag) {
        return (this.flags & flag) != 0;
    }

    private class CancelException
    extends RuntimeException {
        private CancelException() {
        }
    }

    private class Caller
    extends Thread {
        private XMLRPCCallback listener;
        private long threadId;
        private String methodName;
        private Object[] params;
        private volatile boolean canceled;
        private HttpURLConnection http;

        public Caller(XMLRPCCallback listener, long threadId, String methodName, Object[] params) {
            this.listener = listener;
            this.threadId = threadId;
            this.methodName = methodName;
            this.params = params;
        }

        public Caller() {
        }

        @Override
        public void run() {
            if (this.listener == null) {
                return;
            }
            try {
                XMLRPCClient.this.backgroundCalls.put(this.threadId, this);
                Object o = this.call(this.methodName, this.params);
                this.listener.onResponse(this.threadId, o);
            }
            catch (CancelException o) {
            }
            catch (XMLRPCServerException ex) {
                this.listener.onServerError(this.threadId, ex);
            }
            catch (XMLRPCException ex) {
                this.listener.onError(this.threadId, ex);
            }
            finally {
                XMLRPCClient.this.backgroundCalls.remove(this.threadId);
            }
        }

        public void cancel() {
            this.canceled = true;
            this.http.disconnect();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object call(String methodName, Object[] params) throws XMLRPCException {
            try {
                InputStream istream;
                int statusCode;
                Call c = XMLRPCClient.this.createCall(methodName, params);
                URLConnection conn = XMLRPCClient.this.proxy != null ? XMLRPCClient.this.url.openConnection(XMLRPCClient.this.proxy) : XMLRPCClient.this.url.openConnection();
                this.http = this.verifyConnection(conn);
                this.http.setInstanceFollowRedirects(false);
                this.http.setRequestMethod(XMLRPCClient.HTTP_POST);
                this.http.setDoOutput(true);
                this.http.setDoInput(true);
                if (XMLRPCClient.this.timeout > 0) {
                    this.http.setConnectTimeout(XMLRPCClient.this.timeout * 1000);
                    this.http.setReadTimeout(XMLRPCClient.this.timeout * 1000);
                }
                for (Map.Entry param : XMLRPCClient.this.httpParameters.entrySet()) {
                    this.http.setRequestProperty((String)param.getKey(), (String)param.getValue());
                }
                XMLRPCClient.this.authManager.setAuthentication(this.http);
                XMLRPCClient.this.cookieManager.setCookies(this.http);
                OutputStreamWriter stream = new OutputStreamWriter(this.http.getOutputStream(), "UTF-8");
                stream.write(c.getXML(XMLRPCClient.this.isFlagSet(8192)));
                stream.flush();
                stream.close();
                try {
                    statusCode = this.http.getResponseCode();
                }
                catch (IOException ex) {
                    statusCode = this.http.getResponseCode();
                }
                if (statusCode == 403 || statusCode == 401) {
                    if (!XMLRPCClient.this.isFlagSet(16)) throw new XMLRPCException("Invalid status code '" + statusCode + "' returned from server.");
                    istream = this.http.getErrorStream();
                } else {
                    istream = this.http.getInputStream();
                }
                if (statusCode == 301 || statusCode == 302) {
                    if (!XMLRPCClient.this.isFlagSet(32)) throw new XMLRPCException("The server responded with a http 301 or 302 status code, but forwarding has not been enabled (FLAGS_FORWARD).");
                    boolean temporaryForward = statusCode == 302;
                    String newLocation = this.http.getHeaderField("Location");
                    if (newLocation == null || newLocation.length() <= 0) {
                        newLocation = this.http.getHeaderField("location");
                    }
                    URL oldURL = XMLRPCClient.this.url;
                    XMLRPCClient.this.url = new URL(newLocation);
                    this.http.disconnect();
                    Object forwardedResult = this.call(methodName, params);
                    if (!temporaryForward) return forwardedResult;
                    XMLRPCClient.this.url = oldURL;
                    return forwardedResult;
                }
                if (!XMLRPCClient.this.isFlagSet(16) && statusCode != 200) {
                    throw new XMLRPCException("The status code of the http response must be 200.");
                }
                if (XMLRPCClient.this.isFlagSet(1) && !this.http.getContentType().startsWith(XMLRPCClient.TYPE_XML)) {
                    throw new XMLRPCException("The Content-Type of the response must be text/xml.");
                }
                XMLRPCClient.this.cookieManager.readCookies(this.http);
                return XMLRPCClient.this.responseParser.parse(XMLRPCClient.this.serializerHandler, istream, XMLRPCClient.this.isFlagSet(8192));
            }
            catch (SocketTimeoutException ex) {
                throw new XMLRPCTimeoutException("The XMLRPC call timed out.");
            }
            catch (IOException ex) {
                if (this.canceled && this.threadId > 0L) throw new CancelException();
                throw new XMLRPCException(ex);
            }
        }

        private HttpURLConnection verifyConnection(URLConnection conn) throws XMLRPCException {
            if (!(conn instanceof HttpURLConnection)) {
                throw new IllegalArgumentException("The URL is not valid for a http connection.");
            }
            if (conn instanceof HttpsURLConnection) {
                HttpsURLConnection h = (HttpsURLConnection)conn;
                if (XMLRPCClient.this.isFlagSet(64)) {
                    h.setHostnameVerifier(new HostnameVerifier(){

                        @Override
                        public boolean verify(String host, SSLSession ssl) {
                            return true;
                        }
                    });
                }
                if (XMLRPCClient.this.trustManagers != null) {
                    try {
                        String[] sslContexts;
                        for (String ctx : sslContexts = new String[]{"TLS", "SSL"}) {
                            SSLContext sc = SSLContext.getInstance(ctx);
                            sc.init(XMLRPCClient.this.keyManagers, XMLRPCClient.this.trustManagers, new SecureRandom());
                            h.setSSLSocketFactory(sc.getSocketFactory());
                        }
                    }
                    catch (Exception ex) {
                        throw new XMLRPCException(ex);
                    }
                }
                return h;
            }
            return (HttpURLConnection)conn;
        }
    }
}

