/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.dbmigrator.mvstore;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import org.tinymediamanager.dbmigrator.mvstore.DataUtils;
import org.tinymediamanager.dbmigrator.mvstore.FileStore;
import org.tinymediamanager.dbmigrator.mvstore.WriteBuffer;

public class Chunk {
    public static final int MAX_ID = 0x3FFFFFF;
    static final int MAX_HEADER_LENGTH = 1024;
    static final int FOOTER_LENGTH = 128;
    private static final String ATTR_CHUNK = "chunk";
    private static final String ATTR_BLOCK = "block";
    private static final String ATTR_LEN = "len";
    private static final String ATTR_MAP = "map";
    private static final String ATTR_MAX = "max";
    private static final String ATTR_NEXT = "next";
    private static final String ATTR_PAGES = "pages";
    private static final String ATTR_ROOT = "root";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_LIVE_MAX = "liveMax";
    private static final String ATTR_LIVE_PAGES = "livePages";
    private static final String ATTR_UNUSED = "unused";
    private static final String ATTR_UNUSED_AT_VERSION = "unusedAtVersion";
    private static final String ATTR_PIN_COUNT = "pinCount";
    private static final String ATTR_FLETCHER = "fletcher";
    public final int id;
    public volatile long block;
    public int len;
    int pageCount;
    int pageCountLive;
    public long maxLen;
    public long maxLenLive;
    int collectPriority;
    long metaRootPos;
    public long version;
    public long time;
    public long unused;
    long unusedAtVersion;
    public int mapId;
    public long next;
    private int pinCount;

    Chunk(int n) {
        this.id = n;
    }

    static Chunk readChunkHeader(ByteBuffer byteBuffer, long l) {
        int n = byteBuffer.position();
        byte[] byArray = new byte[Math.min(byteBuffer.remaining(), 1024)];
        byteBuffer.get(byArray);
        try {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != 10) continue;
                byteBuffer.position(n + i + 1);
                String string = new String(byArray, 0, i, StandardCharsets.ISO_8859_1).trim();
                return Chunk.fromString(string);
            }
        }
        catch (Exception exception) {
            throw DataUtils.newIllegalStateException(6, "File corrupt reading chunk at position {0}", l, exception);
        }
        throw DataUtils.newIllegalStateException(6, "File corrupt reading chunk at position {0}", l);
    }

    void writeChunkHeader(WriteBuffer writeBuffer, int n) {
        long l = writeBuffer.position() + n - 1;
        writeBuffer.put(this.asString().getBytes(StandardCharsets.ISO_8859_1));
        while ((long)writeBuffer.position() < l) {
            writeBuffer.put((byte)32);
        }
        if (n != 0 && (long)writeBuffer.position() > l) {
            throw DataUtils.newIllegalStateException(3, "Chunk metadata too long", new Object[0]);
        }
        writeBuffer.put((byte)10);
    }

    static String getMetaKey(int n) {
        return "chunk." + Integer.toHexString(n);
    }

    public static Chunk fromString(String string) {
        HashMap<String, String> hashMap = DataUtils.parseMap(string);
        int n = DataUtils.readHexInt(hashMap, ATTR_CHUNK, 0);
        Chunk chunk = new Chunk(n);
        chunk.block = DataUtils.readHexLong(hashMap, ATTR_BLOCK, 0L);
        chunk.len = DataUtils.readHexInt(hashMap, ATTR_LEN, 0);
        chunk.pageCount = DataUtils.readHexInt(hashMap, ATTR_PAGES, 0);
        chunk.pageCountLive = DataUtils.readHexInt(hashMap, ATTR_LIVE_PAGES, chunk.pageCount);
        chunk.mapId = DataUtils.readHexInt(hashMap, ATTR_MAP, 0);
        chunk.maxLen = DataUtils.readHexLong(hashMap, ATTR_MAX, 0L);
        chunk.maxLenLive = DataUtils.readHexLong(hashMap, ATTR_LIVE_MAX, chunk.maxLen);
        chunk.metaRootPos = DataUtils.readHexLong(hashMap, ATTR_ROOT, 0L);
        chunk.time = DataUtils.readHexLong(hashMap, ATTR_TIME, 0L);
        chunk.unused = DataUtils.readHexLong(hashMap, ATTR_UNUSED, 0L);
        chunk.unusedAtVersion = DataUtils.readHexLong(hashMap, ATTR_UNUSED_AT_VERSION, 0L);
        chunk.version = DataUtils.readHexLong(hashMap, ATTR_VERSION, n);
        chunk.next = DataUtils.readHexLong(hashMap, ATTR_NEXT, 0L);
        chunk.pinCount = DataUtils.readHexInt(hashMap, ATTR_PIN_COUNT, 0);
        return chunk;
    }

    int getFillRate() {
        assert (this.maxLenLive <= this.maxLen) : this.maxLenLive + " > " + this.maxLen;
        if (this.maxLenLive <= 0L) {
            return 0;
        }
        if (this.maxLenLive == this.maxLen) {
            return 100;
        }
        return 1 + (int)(98L * this.maxLenLive / this.maxLen);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object object) {
        return object instanceof Chunk && ((Chunk)object).id == this.id;
    }

    public String asString() {
        StringBuilder stringBuilder = new StringBuilder(240);
        DataUtils.appendMap(stringBuilder, ATTR_CHUNK, this.id);
        DataUtils.appendMap(stringBuilder, ATTR_BLOCK, this.block);
        DataUtils.appendMap(stringBuilder, ATTR_LEN, this.len);
        if (this.maxLen != this.maxLenLive) {
            DataUtils.appendMap(stringBuilder, ATTR_LIVE_MAX, this.maxLenLive);
        }
        if (this.pageCount != this.pageCountLive) {
            DataUtils.appendMap(stringBuilder, ATTR_LIVE_PAGES, this.pageCountLive);
        }
        DataUtils.appendMap(stringBuilder, ATTR_MAP, this.mapId);
        DataUtils.appendMap(stringBuilder, ATTR_MAX, this.maxLen);
        if (this.next != 0L) {
            DataUtils.appendMap(stringBuilder, ATTR_NEXT, this.next);
        }
        DataUtils.appendMap(stringBuilder, ATTR_PAGES, this.pageCount);
        DataUtils.appendMap(stringBuilder, ATTR_ROOT, this.metaRootPos);
        DataUtils.appendMap(stringBuilder, ATTR_TIME, this.time);
        if (this.unused != 0L) {
            DataUtils.appendMap(stringBuilder, ATTR_UNUSED, this.unused);
        }
        if (this.unusedAtVersion != 0L) {
            DataUtils.appendMap(stringBuilder, ATTR_UNUSED_AT_VERSION, this.unusedAtVersion);
        }
        DataUtils.appendMap(stringBuilder, ATTR_VERSION, this.version);
        DataUtils.appendMap(stringBuilder, ATTR_PIN_COUNT, this.pinCount);
        return stringBuilder.toString();
    }

    byte[] getFooterBytes() {
        StringBuilder stringBuilder = new StringBuilder(128);
        DataUtils.appendMap(stringBuilder, ATTR_CHUNK, this.id);
        DataUtils.appendMap(stringBuilder, ATTR_BLOCK, this.block);
        DataUtils.appendMap(stringBuilder, ATTR_VERSION, this.version);
        byte[] byArray = stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1);
        int n = DataUtils.getFletcher32(byArray, 0, byArray.length);
        DataUtils.appendMap(stringBuilder, ATTR_FLETCHER, n);
        while (stringBuilder.length() < 127) {
            stringBuilder.append(' ');
        }
        stringBuilder.append('\n');
        return stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1);
    }

    boolean isSaved() {
        return this.block != Long.MAX_VALUE;
    }

    boolean isLive() {
        return this.pageCountLive > 0;
    }

    boolean isRewritable() {
        return this.isSaved() && this.isLive() && this.pageCountLive < this.pageCount && this.isEvacuatable();
    }

    private boolean isEvacuatable() {
        return this.pinCount == 0;
    }

    /*
     * Unable to fully structure code
     */
    ByteBuffer readBufferForPage(FileStore var1_1, long var2_2, int var4_3) {
        if (!Chunk.$assertionsDisabled && !this.isSaved()) {
            throw new AssertionError(this);
        }
        while (true) lbl-1000:
        // 3 sources

        {
            var5_4 = this.block;
            try {
                var7_5 = var5_4 * 4096L;
                var9_7 = var7_5 + (long)(this.len * 4096);
                if ((var7_5 += (long)DataUtils.getPageOffset(var2_2)) < 0L) {
                    throw DataUtils.newIllegalStateException(6, "Negative position {0}; p={1}, c={2}", new Object[]{var7_5, var2_2, this.toString()});
                }
                var11_8 = DataUtils.getPageMaxLength(var2_2);
                if (var11_8 == 0x200000) {
                    var11_8 = var1_1.readFully(var7_5, 128).getInt();
                }
                if ((var11_8 = (int)Math.min(var9_7 - var7_5, (long)var11_8)) < 0) {
                    throw DataUtils.newIllegalStateException(6, "Illegal page length {0} reading at {1}; max pos {2} ", new Object[]{var11_8, var7_5, var9_7});
                }
                var12_9 = var1_1.readFully(var7_5, var11_8);
                var13_10 = DataUtils.getPageOffset(var2_2);
                var14_11 = var12_9.position();
                var15_12 = var12_9.remaining();
                var16_13 = var12_9.getInt();
                if (var16_13 > var15_12 || var16_13 < 4) {
                    throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected page length 4..{1}, got {2}", new Object[]{this.id, var15_12, var16_13});
                }
                var12_9.limit(var14_11 + var16_13);
                var17_14 = var12_9.getShort();
                var18_15 = DataUtils.getCheckValue(this.id) ^ DataUtils.getCheckValue(var13_10) ^ DataUtils.getCheckValue(var16_13);
                if (var17_14 != (short)var18_15) {
                    throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected check value {1}, got {2}", new Object[]{this.id, var18_15, var17_14});
                }
                var19_16 = DataUtils.readVarInt(var12_9);
                if (var19_16 != var4_3) {
                    throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected map id {1}, got {2}", new Object[]{this.id, var4_3, var19_16});
                }
                if (var5_4 != this.block) ** GOTO lbl-1000
                return var12_9;
            }
            catch (IllegalStateException var7_6) {
                if (var5_4 != this.block) continue;
                throw var7_6;
            }
            break;
        }
    }

    void accountForWrittenPage(int n, boolean bl) {
        this.maxLen += (long)n;
        ++this.pageCount;
        this.maxLenLive += (long)n;
        ++this.pageCountLive;
        if (bl) {
            ++this.pinCount;
        }
    }

    boolean accountForRemovedPage(int n, boolean bl, long l, long l2) {
        assert (this.isSaved()) : this;
        this.maxLenLive -= (long)n;
        --this.pageCountLive;
        if (bl) {
            --this.pinCount;
        }
        if (this.unusedAtVersion < l2) {
            this.unusedAtVersion = l2;
        }
        assert (this.pinCount >= 0) : this;
        assert (this.pageCountLive >= 0) : this;
        assert (this.pinCount <= this.pageCountLive) : this;
        assert (this.maxLenLive >= 0L) : this;
        assert (this.pageCountLive == 0 == (this.maxLenLive == 0L)) : this;
        if (!this.isLive()) {
            assert (this.isEvacuatable()) : this;
            this.unused = l;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.asString();
    }

    public static final class PositionComparator
    implements Comparator<Chunk> {
        public static final Comparator<Chunk> INSTANCE = new PositionComparator();

        private PositionComparator() {
        }

        @Override
        public int compare(Chunk chunk, Chunk chunk2) {
            return Long.compare(chunk.block, chunk2.block);
        }
    }
}

