/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.RenamerPreviewContainer;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowComparator;
import org.tinymediamanager.core.tvshow.TvShowRenamerPreview;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowRenameTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.renderer.RenamerCellRenderer;

public class TvShowRenamerPreviewDialog
extends TmmDialog {
    private final EventList<RenamerPreviewContainer> results;
    private final ResultSelectionModel resultSelectionModel;
    private final EventList<RenamerPreviewContainer.MediaFileTypeContainer> mediaFileEventList = GlazedLists.eventList(new ArrayList());
    private final TmmTable tableTvShows;
    private final TmmTable tableMediaFiles;
    private final JLabel lblTitle;
    private final JLabel lblDatasource;
    private final JLabel lblFolderOld;
    private final JLabel lblFolderNew;
    private final JCheckBox cbFilter;
    private final TvShowPreviewWorker worker;

    public TvShowRenamerPreviewDialog(List<TvShow> selectedTvShows) {
        super(TmmResourceBundle.getString("movie.renamerpreview"), "tvShowRenamerPreview");
        this.results = GlazedListsSwing.swingThreadProxyList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()));
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[950lp,grow]", "[600lp,grow]"));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setName(this.getName() + ".splitPane");
        TmmUILayoutStore.getInstance().install(splitPane);
        splitPane.setResizeWeight(0.3);
        panelContent.add((Component)splitPane, "cell 0 0,grow");
        TmmTableModel<RenamerPreviewContainer> tableModel = new TmmTableModel<RenamerPreviewContainer>((EventList<RenamerPreviewContainer>)GlazedListsSwing.swingThreadProxyList(this.results), new ResultTableFormat());
        this.tableTvShows = new TmmTable((TableModel)((Object)tableModel));
        DefaultEventSelectionModel tableSelectionModel = new DefaultEventSelectionModel(this.results);
        this.resultSelectionModel = new ResultSelectionModel();
        tableSelectionModel.addListSelectionListener((ListSelectionListener)this.resultSelectionModel);
        this.resultSelectionModel.selectedResults = tableSelectionModel.getSelected();
        this.tableTvShows.setSelectionModel((ListSelectionModel)tableSelectionModel);
        tableModel.addTableModelListener(arg0 -> {
            ListSelectionModel selectionModel = this.tableTvShows.getSelectionModel();
            if (selectionModel.isSelectionEmpty() && tableModel.getRowCount() > 0) {
                selectionModel.setSelectionInterval(0, 0);
            }
            if (selectionModel.isSelectionEmpty() && tableModel.getRowCount() == 0) {
                this.resultSelectionModel.setSelectedResult(null);
            }
        });
        JScrollPane scrollPaneMovies = new JScrollPane();
        this.tableTvShows.configureScrollPane(scrollPaneMovies);
        splitPane.setLeftComponent(scrollPaneMovies);
        JPanel panelDetails = new JPanel();
        splitPane.setRightComponent(panelDetails);
        panelDetails.setLayout((LayoutManager)new MigLayout("", "[][][300lp,grow]", "[][][][][][][][grow]"));
        this.lblTitle = new JLabel("");
        TmmFontHelper.changeFont(this.lblTitle, 1.33, 1);
        panelDetails.add((Component)this.lblTitle, "cell 0 0 3 1,growx");
        TmmLabel lblDatasourceT = new TmmLabel(TmmResourceBundle.getString("metatag.datasource"));
        panelDetails.add((Component)lblDatasourceT, "cell 0 2");
        this.lblDatasource = new JLabel("");
        panelDetails.add((Component)this.lblDatasource, "cell 2 2,growx,aligny center");
        TmmLabel lblFolderOldT = new TmmLabel(TmmResourceBundle.getString("renamer.oldfolder"));
        panelDetails.add((Component)lblFolderOldT, "cell 0 4");
        this.lblFolderOld = new JLabel("");
        panelDetails.add((Component)this.lblFolderOld, "cell 2 4,growx,aligny center");
        TmmLabel lblFolderNewT = new TmmLabel(TmmResourceBundle.getString("renamer.newfolder"));
        panelDetails.add((Component)lblFolderNewT, "cell 0 5");
        this.lblFolderNew = new JLabel("");
        panelDetails.add((Component)this.lblFolderNew, "cell 2 5,growx,aligny center");
        JPanel panelMediaFiles = new JPanel();
        panelDetails.add((Component)panelMediaFiles, "cell 0 7 3 1,grow");
        panelMediaFiles.setLayout((LayoutManager)new MigLayout("", "[grow][grow]", "[15px][grow]"));
        this.tableMediaFiles = new TmmTable((TableModel)((Object)new TmmTableModel<RenamerPreviewContainer.MediaFileTypeContainer>((EventList<RenamerPreviewContainer.MediaFileTypeContainer>)GlazedListsSwing.swingThreadProxyList(this.mediaFileEventList), new RenamerTableFormat())));
        JScrollPane scrollPaneMediaFiles = new JScrollPane();
        this.tableMediaFiles.configureScrollPane(scrollPaneMediaFiles);
        panelMediaFiles.add((Component)scrollPaneMediaFiles, "cell 0 1 2 1,grow");
        this.cbFilter = new JCheckBox(TmmResourceBundle.getString("renamer.hideunchanged"));
        this.cbFilter.addActionListener(l -> this.resultSelectionModel.updateSelectedResult());
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("", "[]", "[]"));
        bottomPanel.add((Component)this.cbFilter, "cell 0 0");
        this.setBottomInformationPanel(bottomPanel);
        JButton btnRename = new JButton(TmmResourceBundle.getString("Button.rename"));
        btnRename.setToolTipText(TmmResourceBundle.getString("movie.rename"));
        btnRename.addActionListener(arg0 -> {
            ArrayList<TvShow> selectedTvShows1 = new ArrayList<TvShow>();
            ArrayList<TvShowEpisode> selectedEpisodes = new ArrayList<TvShowEpisode>();
            ArrayList<RenamerPreviewContainer> selectedResults = new ArrayList<RenamerPreviewContainer>(this.resultSelectionModel.selectedResults);
            for (RenamerPreviewContainer result : selectedResults) {
                selectedTvShows1.add((TvShow)result.get());
                selectedEpisodes.addAll(((TvShow)result.get()).getEpisodes());
            }
            TvShowRenameTask renameTask = new TvShowRenameTask(selectedTvShows1, selectedEpisodes);
            TmmTaskManager.getInstance().addMainTask(renameTask);
            this.results.removeAll(selectedResults);
        });
        this.addButton(btnRename);
        JButton btnClose = new JButton(TmmResourceBundle.getString("Button.close"));
        btnClose.addActionListener(arg0 -> this.setVisible(false));
        this.addDefaultButton(btnClose);
        this.tableMediaFiles.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TvShowRenamerPreviewDialog.this.tableMediaFiles.adjustRowHeights();
            }
        });
        this.tableMediaFiles.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                SwingUtilities.invokeLater(TvShowRenamerPreviewDialog.this.tableMediaFiles::adjustRowHeights);
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                SwingUtilities.invokeLater(TvShowRenamerPreviewDialog.this.tableMediaFiles::adjustRowHeights);
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                SwingUtilities.invokeLater(TvShowRenamerPreviewDialog.this.tableMediaFiles::adjustRowHeights);
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                SwingUtilities.invokeLater(TvShowRenamerPreviewDialog.this.tableMediaFiles::adjustRowHeights);
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
                SwingUtilities.invokeLater(TvShowRenamerPreviewDialog.this.tableMediaFiles::adjustRowHeights);
            }
        });
        this.worker = new TvShowPreviewWorker(selectedTvShows);
        this.worker.execute();
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        super.setVisible(visible);
    }

    private static class ResultTableFormat
    extends TmmTableFormat<RenamerPreviewContainer> {
        public ResultTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, "", "indicator", container -> container.renamerProblems ? IconManager.TABLE_ALERT : null, ImageIcon.class);
            col.setMinWidth(24);
            col.setMaxWidth(24);
            col.setColumnResizeable(false);
            col.setCellTooltip(container -> container.renamerProblems ? TmmResourceBundle.getString("renamer.problemfound") : null);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.tvshow"), "title", container -> ((TvShow)container.get()).getTitleSortable(), String.class);
            col.setCellTooltip(container -> ((TvShow)container.get()).getTitleSortable());
            this.addColumn(col);
        }
    }

    private class ResultSelectionModel
    extends AbstractModelObject
    implements ListSelectionListener {
        private final RenamerPreviewContainer emptyResult;
        private RenamerPreviewContainer selectedResult;
        private List<RenamerPreviewContainer> selectedResults;

        ResultSelectionModel() {
            this.selectedResult = this.emptyResult = new RenamerPreviewContainer(new TvShow());
        }

        void updateSelectedResult() {
            TvShowRenamerPreviewDialog.this.lblTitle.setText(((TvShow)this.selectedResult.get()).getTitleSortable());
            TvShowRenamerPreviewDialog.this.lblDatasource.setText(this.selectedResult.get().getDataSource());
            if (this.selectedResult != this.emptyResult) {
                TvShowRenamerPreviewDialog.this.lblFolderOld.setText(this.selectedResult.getOldPathRelative().toString());
                TvShowRenamerPreviewDialog.this.lblFolderNew.setText(this.selectedResult.getNewPathRelative().toString());
            } else {
                TvShowRenamerPreviewDialog.this.lblFolderOld.setText("");
                TvShowRenamerPreviewDialog.this.lblFolderNew.setText("");
            }
            try {
                TvShowRenamerPreviewDialog.this.mediaFileEventList.getReadWriteLock().writeLock().lock();
                TvShowRenamerPreviewDialog.this.mediaFileEventList.clear();
                for (RenamerPreviewContainer.MediaFileTypeContainer container : this.selectedResult.getFiles()) {
                    if (!container.duped && TvShowRenamerPreviewDialog.this.cbFilter.isSelected() && container.isUnchanged()) continue;
                    TvShowRenamerPreviewDialog.this.mediaFileEventList.add((Object)container);
                }
            }
            catch (Exception exception) {
            }
            finally {
                TvShowRenamerPreviewDialog.this.mediaFileEventList.getReadWriteLock().writeLock().unlock();
            }
            SwingUtilities.invokeLater(() -> {
                TvShowRenamerPreviewDialog.this.tableMediaFiles.adjustColumnPreferredWidths(5);
                TvShowRenamerPreviewDialog.this.tableMediaFiles.adjustRowHeights();
            });
        }

        synchronized void setSelectedResult(RenamerPreviewContainer newValue) {
            this.selectedResult = newValue == null ? this.emptyResult : newValue;
            this.updateSelectedResult();
        }

        @Override
        public void valueChanged(ListSelectionEvent arg0) {
            if (arg0.getValueIsAdjusting()) {
                return;
            }
            if (!this.selectedResults.isEmpty() && this.selectedResult != this.selectedResults.get(0)) {
                this.setSelectedResult(this.selectedResults.get(0));
            }
            if (this.selectedResults.isEmpty()) {
                this.setSelectedResult(this.emptyResult);
            }
        }
    }

    private static class RenamerTableFormat
    extends TmmTableFormat<RenamerPreviewContainer.MediaFileTypeContainer> {
        public RenamerTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, "", "indicator", container -> container.duped ? IconManager.TABLE_ALERT : null, ImageIcon.class);
            col.setMinWidth(24);
            col.setMaxWidth(24);
            col.setColumnResizeable(false);
            col.setCellTooltip(container -> container.duped ? TmmResourceBundle.getString("renamer.duplicate") : null);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("renamer.oldfiles"), "oldFilename", container -> container, RenamerPreviewContainer.MediaFileTypeContainer.class);
            col.setCellRenderer(RenamerCellRenderer.forOldFilenames());
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("renamer.newfiles"), "newFilename", container -> container, RenamerPreviewContainer.MediaFileTypeContainer.class);
            col.setCellRenderer(RenamerCellRenderer.forNewFilenames());
            this.addColumn(col);
        }
    }

    private class TvShowPreviewWorker
    extends SwingWorker<Void, Void> {
        private final List<TvShow> tvShowsToProcess;

        private TvShowPreviewWorker(List<TvShow> tvShows) {
            this.tvShowsToProcess = new ArrayList<TvShow>(tvShows);
        }

        @Override
        protected Void doInBackground() {
            this.tvShowsToProcess.sort(new TvShowComparator());
            for (TvShow tvShow : this.tvShowsToProcess) {
                if (this.isCancelled()) {
                    return null;
                }
                RenamerPreviewContainer container = new TvShowRenamerPreview(tvShow).generatePreview();
                if (!container.isNeedsRename() && !container.hasRenamerProblems()) continue;
                TvShowRenamerPreviewDialog.this.results.add((Object)container);
            }
            SwingUtilities.invokeLater(() -> {
                if (TvShowRenamerPreviewDialog.this.results.isEmpty()) {
                    JOptionPane.showMessageDialog(TvShowRenamerPreviewDialog.this, TmmResourceBundle.getString("movie.renamerpreview.nothingtorename"));
                    TvShowRenamerPreviewDialog.this.setVisible(false);
                }
            });
            return null;
        }
    }
}

