/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.stream.Collectors;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.dialogs.MovieEditorDialog;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class MovieSetEditMovieAction
extends TmmAction {
    public MovieSetEditMovieAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.edit"));
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovies();
        selectedMovies = selectedMovies.stream().filter(movie -> !(movie instanceof MovieSet.MovieSetMovie)).collect(Collectors.toList());
        int selectedCount = selectedMovies.size();
        int index = 0;
        int selectedTab = 0;
        if (selectedCount == 0) {
            return;
        }
        do {
            Movie movie2 = selectedMovies.get(index);
            MovieEditorDialog dialogMovieEditor = new MovieEditorDialog(movie2, index, selectedCount, selectedTab);
            dialogMovieEditor.setVisible(true);
            selectedTab = dialogMovieEditor.getSelectedTab();
            if (!dialogMovieEditor.isContinueQueue()) break;
            if (dialogMovieEditor.isNavigateBack()) {
                --index;
                continue;
            }
            ++index;
        } while (index < selectedCount);
    }
}

