/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.button.FlatButton;
import org.tinymediamanager.ui.components.button.JHintCheckBox;
import org.tinymediamanager.ui.components.label.LinkLabel;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.textfield.TmmRoundTextArea;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieJmteExplorerDialog;

public class MovieRenamerSettingsPanel
extends JPanel
implements HierarchyListener {
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private final List<String> spaceReplacement = new ArrayList<String>(Arrays.asList("_", ".", "-"));
    private final List<String> colonReplacement = new ArrayList<String>(Arrays.asList(" ", "-", "_", "\u2236"));
    private JTextArea tfMoviePath;
    private JTextArea tfMovieFilename;
    private LinkLabel lblExampleDatasource;
    private JLabel lblExampleFoldername;
    private JLabel lblExampleFilename;
    private JCheckBox chckbxFoldernameSpaceReplacement;
    private JComboBox cbFoldernameSpaceReplacement;
    private JCheckBox chckbxFilenameSpaceReplacement;
    private JComboBox cbFilenameSpaceReplacement;
    private JComboBox cbMovieForPreview;
    private JCheckBox chckbxRemoveOtherNfos;
    private JCheckBox chckbxCleanupUnwanted;
    private JCheckBox chckbxMoviesetSingleMovie;
    private ReadOnlyTextArea taWarning;
    private JComboBox cbColonReplacement;
    private JTextField tfFirstCharacter;
    private JCheckBox chckbxAllowMerge;
    private JCheckBox chckbxAutomaticRename;
    private JHintCheckBox chckbxAsciiReplacement;
    private JHintCheckBox chckbxUnicodeReplacement;

    public MovieRenamerSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }
        };
        this.tfFirstCharacter.getDocument().addDocumentListener(documentListener);
        this.settings.addPropertyChangeListener(e -> {
            switch (e.getPropertyName()) {
                case "renamerPathname": 
                case "renamerFilename": {
                    this.createRenamerExample();
                }
            }
        });
        String replacement = this.settings.getRenamerPathnameSpaceReplacement();
        int index = this.spaceReplacement.indexOf(replacement);
        if (index >= 0) {
            this.cbFoldernameSpaceReplacement.setSelectedIndex(index);
        }
        if ((index = this.spaceReplacement.indexOf(replacement = this.settings.getRenamerFilenameSpaceReplacement())) >= 0) {
            this.cbFilenameSpaceReplacement.setSelectedIndex(index);
        }
        if ((index = this.colonReplacement.indexOf(replacement = this.settings.getRenamerColonReplacement())) >= 0) {
            this.cbColonReplacement.setSelectedIndex(index);
        }
        if (this.settings.isAsciiReplacement()) {
            this.chckbxUnicodeReplacement.setEnabled(false);
            this.cbColonReplacement.removeItem(this.colonReplacement.get(this.colonReplacement.size() - 1));
        }
        this.cbFoldernameSpaceReplacement.addActionListener(arg0 -> {
            this.checkChanges();
            this.createRenamerExample();
        });
        this.cbFilenameSpaceReplacement.addActionListener(arg0 -> {
            this.checkChanges();
            this.createRenamerExample();
        });
        this.cbColonReplacement.addActionListener(arg0 -> {
            this.checkChanges();
            this.createRenamerExample();
        });
        this.chckbxAsciiReplacement.addActionListener(arg0 -> {
            if (this.chckbxAsciiReplacement.isSelected()) {
                this.cbColonReplacement.removeItem(ListUtils.getLast(this.colonReplacement));
                this.chckbxUnicodeReplacement.setSelected(false);
                this.chckbxUnicodeReplacement.setEnabled(false);
            } else {
                this.cbColonReplacement.addItem(ListUtils.getLast(this.colonReplacement));
                this.chckbxUnicodeReplacement.setEnabled(true);
            }
            this.checkChanges();
            this.createRenamerExample();
        });
        this.chckbxUnicodeReplacement.addActionListener(arg0 -> {
            this.checkChanges();
            this.createRenamerExample();
        });
        this.lblExampleFilename.putClientProperty("clipPosition", 2);
        ActionListener actionCreateRenamerExample = e -> this.createRenamerExample();
        this.cbMovieForPreview.addActionListener(actionCreateRenamerExample);
        this.chckbxMoviesetSingleMovie.addActionListener(actionCreateRenamerExample);
        this.chckbxAsciiReplacement.addActionListener(actionCreateRenamerExample);
        this.chckbxFilenameSpaceReplacement.addActionListener(actionCreateRenamerExample);
        this.chckbxFoldernameSpaceReplacement.addActionListener(actionCreateRenamerExample);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 1", "[grow]", "[][15lp!][][15lp!][][15lp!][]"));
        JPanel panelPatterns = new JPanel((LayoutManager)new MigLayout("insets 0, hidemode 1", "[20lp!][15lp][][400lp,grow][grow]", "[][][][][][]"));
        TmmLabel lblPatternsT = new TmmLabel(TmmResourceBundle.getString("Settings.movie.renamer.title"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelPatterns, lblPatternsT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#renamer-pattern"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        TmmLabel lblMoviePath = new TmmLabel(TmmResourceBundle.getString("Settings.renamer.folder"));
        panelPatterns.add((Component)lblMoviePath, "cell 1 0 2 1,alignx right");
        this.tfMoviePath = new TmmRoundTextArea();
        panelPatterns.add((Component)this.tfMoviePath, "cell 3 0, growx, wmin 0");
        FlatButton btnReset = new FlatButton(IconManager.UNDO_GREY);
        btnReset.setToolTipText(TmmResourceBundle.getString("Settings.renamer.reverttodefault"));
        btnReset.addActionListener(l -> this.tfMoviePath.setText("${title}${ - ,edition,} (${year})"));
        panelPatterns.add((Component)btnReset, "cell 3 0, aligny top");
        JLabel lblDefault = new JLabel(TmmResourceBundle.getString("Settings.default"));
        panelPatterns.add((Component)lblDefault, "cell 1 1 2 1,alignx right");
        TmmFontHelper.changeFont((JComponent)lblDefault, 0.83333);
        ReadOnlyTextArea tpDefaultFolderPattern = new ReadOnlyTextArea("${title}${ - ,edition,} (${year})");
        panelPatterns.add((Component)tpDefaultFolderPattern, "cell 3 1,growx,wmin 0");
        TmmFontHelper.changeFont((JComponent)tpDefaultFolderPattern, 0.83333);
        TmmLabel lblMovieFilename = new TmmLabel(TmmResourceBundle.getString("Settings.renamer.file"));
        panelPatterns.add((Component)lblMovieFilename, "cell 1 2 2 1,alignx right");
        this.tfMovieFilename = new TmmRoundTextArea();
        panelPatterns.add((Component)this.tfMovieFilename, "cell 3 2, growx, wmin 0");
        btnReset = new FlatButton(IconManager.UNDO_GREY);
        btnReset.setToolTipText(TmmResourceBundle.getString("Settings.renamer.reverttodefault"));
        btnReset.addActionListener(l -> this.tfMovieFilename.setText("${title}${ - ,edition,} (${year}) ${videoFormat} ${audioCodec}"));
        panelPatterns.add((Component)btnReset, "cell 3 2, aligny top");
        lblDefault = new JLabel(TmmResourceBundle.getString("Settings.default"));
        panelPatterns.add((Component)lblDefault, "cell 1 3 2 1,alignx right");
        TmmFontHelper.changeFont((JComponent)lblDefault, 0.83333);
        ReadOnlyTextArea tpDefaultFilePattern = new ReadOnlyTextArea("${title}${ - ,edition,} (${year}) ${videoFormat} ${audioCodec}");
        panelPatterns.add((Component)tpDefaultFilePattern, "cell 3 3,growx,wmin 0");
        TmmFontHelper.changeFont((JComponent)tpDefaultFilePattern, 0.83333);
        JLabel lblRenamerHintT = new JLabel(TmmResourceBundle.getString("Settings.movie.renamer.example"));
        panelPatterns.add((Component)lblRenamerHintT, "cell 1 4 3 1");
        JButton btnJmteExplorer = new JButton(TmmResourceBundle.getString("jmteexplorer.title"));
        btnJmteExplorer.addActionListener(e -> {
            MovieJmteExplorerDialog dialog = new MovieJmteExplorerDialog((Window)((JDialog)this.getTopLevelAncestor()));
            dialog.setVisible(true);
        });
        panelPatterns.add((Component)btnJmteExplorer, "cell 4 0");
        this.taWarning = new ReadOnlyTextArea();
        this.taWarning.setForeground(Color.red);
        panelPatterns.add((Component)this.taWarning, "cell 3 5,growx,wmin 0");
        JPanel panelAdvancedOptions = new JPanel();
        panelAdvancedOptions.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][]"));
        TmmLabel lblAdvancedOptions = new TmmLabel(TmmResourceBundle.getString("Settings.advancedoptions"), 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelAdvancedOptions, lblAdvancedOptions, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#advanced-options-4"));
        this.add((Component)collapsiblePanel, "cell 0 2,growx, wmin 0");
        this.chckbxAutomaticRename = new JCheckBox(TmmResourceBundle.getString("Settings.movie.automaticrename"));
        panelAdvancedOptions.add((Component)this.chckbxAutomaticRename, "cell 1 0 2 1");
        JLabel lblAutomaticRenameHint = new JLabel(IconManager.HINT);
        lblAutomaticRenameHint.setToolTipText(TmmResourceBundle.getString("Settings.movie.automaticrename.desc"));
        panelAdvancedOptions.add((Component)lblAutomaticRenameHint, "cell 1 0 2 1");
        this.chckbxMoviesetSingleMovie = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.moviesetsinglemovie"));
        panelAdvancedOptions.add((Component)this.chckbxMoviesetSingleMovie, "cell 1 1 2 1");
        this.chckbxRemoveOtherNfos = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.removenfo"));
        panelAdvancedOptions.add((Component)this.chckbxRemoveOtherNfos, "cell 1 2 2 1");
        this.chckbxCleanupUnwanted = new JCheckBox(TmmResourceBundle.getString("Settings.cleanupfiles"));
        panelAdvancedOptions.add((Component)this.chckbxCleanupUnwanted, "cell 1 3 2 1");
        this.chckbxAllowMerge = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.movie.allowmerge"));
        panelAdvancedOptions.add((Component)this.chckbxAllowMerge, "cell 1 4 2 1");
        JPanel panelReplacements = new JPanel();
        panelReplacements.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][][]"));
        TmmLabel lblReplacementsT = new TmmLabel(TmmResourceBundle.getString("Settings.renamer.replacements"), 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelReplacements, lblReplacementsT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#advanced-options-4"));
        this.add((Component)collapsiblePanel, "cell 0 4,growx, wmin 0");
        this.chckbxFoldernameSpaceReplacement = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.folderspacereplacement"));
        this.chckbxFoldernameSpaceReplacement.setToolTipText(TmmResourceBundle.getString("Settings.renamer.folderspacereplacement.hint"));
        panelReplacements.add((Component)this.chckbxFoldernameSpaceReplacement, "cell 1 0 2 1");
        this.cbFoldernameSpaceReplacement = new JComboBox<Object>(this.spaceReplacement.toArray());
        panelReplacements.add((Component)this.cbFoldernameSpaceReplacement, "cell 1 0 2 1");
        this.chckbxFilenameSpaceReplacement = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.spacereplacement"));
        this.chckbxFilenameSpaceReplacement.setToolTipText(TmmResourceBundle.getString("Settings.renamer.spacereplacement.hint"));
        panelReplacements.add((Component)this.chckbxFilenameSpaceReplacement, "cell 1 1 2 1");
        this.cbFilenameSpaceReplacement = new JComboBox<Object>(this.spaceReplacement.toArray());
        panelReplacements.add((Component)this.cbFilenameSpaceReplacement, "cell 1 1 2 1");
        JLabel lblFirstCharacterT = new JLabel(TmmResourceBundle.getString("Settings.renamer.firstnumbercharacterreplacement"));
        panelReplacements.add((Component)lblFirstCharacterT, "flowx,cell 1 2 2 1");
        this.tfFirstCharacter = new JTextField();
        panelReplacements.add((Component)this.tfFirstCharacter, "cell 1 2 2 1");
        this.tfFirstCharacter.setColumns(2);
        this.chckbxAsciiReplacement = new JHintCheckBox(TmmResourceBundle.getString("Settings.renamer.asciireplacement"));
        String examples = "<html>" + TmmResourceBundle.getString("Settings.renamer.examples") + "<br>";
        examples = examples + "\u00c4  \u2192  Ae<br>";
        examples = examples + "\u00d6  \u2192  Oe<br>";
        examples = examples + "\u00df  \u2192  ss<br>";
        examples = examples + "\u00c1  \u2192  A<br>";
        examples = examples + "\u00c6  \u2192  Ae<br>";
        examples = examples + "\u2026</html>";
        this.chckbxAsciiReplacement.setToolTipText(examples);
        panelReplacements.add((Component)this.chckbxAsciiReplacement, "cell 1 3 2 1");
        JLabel lblColonReplacement = new JLabel(TmmResourceBundle.getString("Settings.renamer.colonreplacement"));
        panelReplacements.add((Component)lblColonReplacement, "flowx,cell 1 4 2 1");
        lblColonReplacement.setToolTipText(TmmResourceBundle.getString("Settings.renamer.colonreplacement.hint"));
        this.cbColonReplacement = new JComboBox<Object>(this.colonReplacement.toArray());
        panelReplacements.add((Component)this.cbColonReplacement, "cell 1 4 2 1");
        this.chckbxUnicodeReplacement = new JHintCheckBox(TmmResourceBundle.getString("Settings.renamer.unicodereplacement"));
        examples = "<html>" + TmmResourceBundle.getString("Settings.renamer.examples") + "<br>";
        examples = examples + ":  \u2192  \u2236<br>";
        examples = examples + "/  \u2192  \u2044<br>";
        examples = examples + "&gt;  \u2192  \u203a<br>";
        examples = examples + "\u2026</html>";
        this.chckbxUnicodeReplacement.setToolTipText(examples);
        panelReplacements.add((Component)this.chckbxUnicodeReplacement, "cell 1 5 2 1");
        JPanel panelExample = new JPanel();
        panelExample.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][][300lp,grow]", "[]10lp![][][]"));
        TmmLabel lblExampleHeader = new TmmLabel(TmmResourceBundle.getString("Settings.example"), 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelExample, lblExampleHeader, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#example"));
        this.add((Component)collapsiblePanel, "cell 0 6, growx, wmin 0");
        TmmLabel lblExampleT = new TmmLabel(TmmResourceBundle.getString("tmm.movie"));
        panelExample.add((Component)lblExampleT, "cell 1 0");
        this.cbMovieForPreview = new JComboBox();
        panelExample.add((Component)this.cbMovieForPreview, "cell 2 0, wmin 0");
        TmmLabel lblDatasourceT = new TmmLabel(TmmResourceBundle.getString("metatag.datasource"));
        panelExample.add((Component)lblDatasourceT, "cell 1 1");
        this.lblExampleDatasource = new LinkLabel("");
        panelExample.add((Component)this.lblExampleDatasource, "cell 2 1, wmin 0");
        TmmLabel lblFoldernameT = new TmmLabel(TmmResourceBundle.getString("Settings.renamer.folder"));
        panelExample.add((Component)lblFoldernameT, "cell 1 2");
        this.lblExampleFoldername = new JLabel("");
        panelExample.add((Component)this.lblExampleFoldername, "cell 2 2, wmin 0");
        TmmLabel lblFilenameT = new TmmLabel(TmmResourceBundle.getString("Settings.renamer.file"));
        panelExample.add((Component)lblFilenameT, "cell 1 3");
        this.lblExampleFilename = new JLabel("");
        panelExample.add((Component)this.lblExampleFilename, "cell 2 3, wmin 0");
    }

    private void buildAndInstallMovieArray() {
        this.cbMovieForPreview.removeAllItems();
        ArrayList<Movie> allMovies = new ArrayList<Movie>(MovieModuleManager.getInstance().getMovieList().getMovies());
        Movie sel = MovieUIModule.getInstance().getSelectionModel().getSelectedMovie();
        allMovies.sort(new MovieComparator());
        for (Movie movie : allMovies) {
            MoviePreviewContainer container = new MoviePreviewContainer();
            container.movie = movie;
            this.cbMovieForPreview.addItem(container);
            if (sel == null || !movie.equals(sel)) continue;
            this.cbMovieForPreview.setSelectedItem(container);
        }
    }

    private void createRenamerExample() {
        Movie movie = null;
        String warning = "";
        if (!this.tfMoviePath.getText().isEmpty() && !MovieRenamer.isFolderPatternUnique(this.tfMoviePath.getText())) {
            warning = TmmResourceBundle.getString("Settings.renamer.folder.warning");
        }
        if (!warning.isEmpty()) {
            this.taWarning.setVisible(true);
            this.taWarning.setText(warning);
        } else {
            this.taWarning.setVisible(false);
        }
        Object object = this.cbMovieForPreview.getSelectedItem();
        if (object instanceof MoviePreviewContainer) {
            MoviePreviewContainer container = (MoviePreviewContainer)object;
            movie = container.movie;
        }
        if (movie != null) {
            String path = "";
            Object filename = "";
            if (StringUtils.isNotBlank((CharSequence)this.tfMoviePath.getText())) {
                path = MovieRenamer.createDestinationForFoldername(this.tfMoviePath.getText(), movie);
                try {
                    path = Paths.get(movie.getDataSource(), path).toString();
                }
                catch (Exception exception) {}
            } else {
                path = movie.getPathNIO().toString();
            }
            if (StringUtils.isNotBlank((CharSequence)this.tfMovieFilename.getText())) {
                List<MediaFile> mediaFiles = movie.getMediaFiles(MediaFileType.VIDEO);
                if (!mediaFiles.isEmpty()) {
                    String extension = FilenameUtils.getExtension((String)mediaFiles.get(0).getFilename());
                    filename = MovieRenamer.createDestinationForFilename(this.tfMovieFilename.getText(), movie);
                    if (!((String)filename).endsWith(extension)) {
                        filename = (String)filename + "." + extension;
                    }
                }
            } else {
                filename = movie.getMediaFiles(MediaFileType.VIDEO).get(0).getFilename();
            }
            this.lblExampleDatasource.setText(movie.getDataSource());
            this.lblExampleFoldername.setText(path.replace(movie.getDataSource() + File.separator, ""));
            this.lblExampleFilename.setText((String)filename);
        } else {
            this.lblExampleDatasource.setText(TmmResourceBundle.getString("Settings.movie.renamer.nomovie"));
            this.lblExampleFoldername.setText(TmmResourceBundle.getString("Settings.movie.renamer.nomovie"));
            this.lblExampleFilename.setText(TmmResourceBundle.getString("Settings.movie.renamer.nomovie"));
        }
    }

    private void checkChanges() {
        String replacement = (String)this.cbFoldernameSpaceReplacement.getSelectedItem();
        this.settings.setRenamerPathnameSpaceReplacement(replacement);
        replacement = (String)this.cbFilenameSpaceReplacement.getSelectedItem();
        this.settings.setRenamerFilenameSpaceReplacement(replacement);
        replacement = (String)this.cbColonReplacement.getSelectedItem();
        this.settings.setRenamerColonReplacement(replacement);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent arg0) {
        if (this.isShowing()) {
            this.buildAndInstallMovieArray();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addHierarchyListener(this);
    }

    @Override
    public void removeNotify() {
        this.removeHierarchyListener(this);
        super.removeNotify();
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_11 = BeanProperty.create((String)"renamerPathname");
        BeanProperty jTextFieldBeanProperty_3 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_11, (Object)this.tfMoviePath, (Property)jTextFieldBeanProperty_3);
        autoBinding_10.bind();
        BeanProperty settingsBeanProperty_12 = BeanProperty.create((String)"renamerFilename");
        BeanProperty jTextFieldBeanProperty_4 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_12, (Object)this.tfMovieFilename, (Property)jTextFieldBeanProperty_4);
        autoBinding_11.bind();
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"renamerPathnameSpaceSubstitution");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.chckbxFoldernameSpaceReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"renamerFilenameSpaceSubstitution");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, (Object)this.chckbxFilenameSpaceReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"renamerNfoCleanup");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.chckbxRemoveOtherNfos, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_5 = BeanProperty.create((String)"renamerCreateMoviesetForSingleMovie");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_5, (Object)this.chckbxMoviesetSingleMovie, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty settingsBeanProperty_7 = BeanProperty.create((String)"asciiReplacement");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_7, (Object)this.chckbxAsciiReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"renamerFirstCharacterNumberReplacement");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, (Object)this.tfFirstCharacter, (Property)jTextFieldBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSettingsBeanProperty_1 = BeanProperty.create((String)"allowMultipleMoviesInSameDir");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_1, (Object)this.chckbxAllowMerge, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
        BeanProperty movieSettingsBeanProperty_2 = BeanProperty.create((String)"renameAfterScrape");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_2, (Object)this.chckbxAutomaticRename, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty movieSettingsBeanProperty_3 = BeanProperty.create((String)"renamerCleanupUnwanted");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_3, (Object)this.chckbxCleanupUnwanted, (Property)jCheckBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty movieSettingsBeanProperty_4 = BeanProperty.create((String)"unicodeReplacement");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_4, (Object)this.chckbxUnicodeReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_9.bind();
    }

    private static class MovieComparator
    implements Comparator<Movie> {
        private MovieComparator() {
        }

        @Override
        public int compare(Movie arg0, Movie arg1) {
            return arg0.getTitle().compareTo(arg1.getTitle());
        }
    }

    private static class MoviePreviewContainer {
        Movie movie;

        private MoviePreviewContainer() {
        }

        public String toString() {
            return this.movie.getTitle();
        }
    }
}

