/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.renderer.BorderTableCellRenderer;

public class MovieBorderTableCellRenderer
extends BorderTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof Movie) {
            Movie movie = (Movie)value;
            if (movie.isLocked()) {
                this.setIcon(IconManager.LOCK_BLUE);
            } else {
                this.setIcon(null);
            }
            TableColumn tableColumn = table.getColumnModel().getColumn(column);
            String text = "originalTitle".equals(tableColumn.getIdentifier()) ? movie.getOriginalTitleSortable() : movie.getTitleSortable();
            return super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

