/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.datepicker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

class DayPanel
extends JPanel {
    private final Calendar today;
    private final JLabel[] dayNames;
    private final JLabel[] days;
    private final Color transparentBackgroundColor;
    private final Color selectedColor;
    private final Color sundayForeground;
    private final Color weekdayForeground;
    private int day;
    private Calendar calendar;
    private Locale locale;
    private JLabel selectedDay;

    DayPanel() {
        this.setBackground(Color.blue);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JLabel label = (JLabel)e.getSource();
                String buttonText = label.getText();
                DayPanel.this.setDay(Integer.parseInt(buttonText));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                DayPanel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DayPanel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        this.locale = Locale.getDefault();
        this.dayNames = new JLabel[7];
        this.days = new JLabel[42];
        this.selectedDay = null;
        this.calendar = Calendar.getInstance(this.locale);
        this.today = (Calendar)this.calendar.clone();
        this.setLayout(new BorderLayout());
        JPanel dayPanel = new JPanel();
        dayPanel.setLayout(new GridLayout(7, 7));
        this.sundayForeground = new Color(164, 0, 0);
        this.weekdayForeground = UIManager.getColor("Component.linkColor");
        Color decorationBackgroundColor = UIManager.getColor("DatePicker.headerBackground");
        this.selectedColor = UIManager.getColor("Component.focusColor");
        this.transparentBackgroundColor = new Color(255, 255, 255, 0);
        for (int i = 0; i < 7; ++i) {
            this.dayNames[i] = new JLabel("");
            this.dayNames[i].setHorizontalAlignment(0);
            this.dayNames[i].setOpaque(true);
            this.dayNames[i].setBackground(decorationBackgroundColor);
            this.dayNames[i].setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            dayPanel.add(this.dayNames[i]);
        }
        for (int row = 0; row < 6; ++row) {
            for (int column = 0; column < 7; ++column) {
                int index = column + 7 * row;
                this.days[index] = new JLabel("");
                this.days[index].setHorizontalAlignment(0);
                this.days[index].addMouseListener(mouseAdapter);
                this.days[index].setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
                dayPanel.add(this.days[index]);
            }
        }
        this.init();
        this.setDay(Calendar.getInstance().get(5));
        this.add((Component)dayPanel, "Center");
        this.updateUI();
    }

    protected void init() {
        Date date = this.calendar.getTime();
        this.calendar = Calendar.getInstance(this.locale);
        this.calendar.setTime(date);
        this.drawDayNames();
        this.drawDays();
    }

    private void drawDayNames() {
        int firstDayOfWeek = this.calendar.getFirstDayOfWeek();
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        String[] dayNames = dateFormatSymbols.getShortWeekdays();
        int day = firstDayOfWeek;
        for (int i = 0; i < 7; ++i) {
            this.dayNames[i].setText(dayNames[day]);
            if (day == 1) {
                this.dayNames[i].setForeground(this.sundayForeground);
            } else {
                this.dayNames[i].setForeground(this.weekdayForeground);
            }
            if (day < 7) {
                ++day;
                continue;
            }
            day -= 6;
        }
    }

    private void drawDays() {
        int i;
        Calendar tmpCalendar = (Calendar)this.calendar.clone();
        tmpCalendar.set(11, 0);
        tmpCalendar.set(12, 0);
        tmpCalendar.set(13, 0);
        tmpCalendar.set(14, 0);
        int firstDayOfWeek = tmpCalendar.getFirstDayOfWeek();
        tmpCalendar.set(5, 1);
        int firstDay = tmpCalendar.get(7) - firstDayOfWeek;
        if (firstDay < 0) {
            firstDay += 7;
        }
        tmpCalendar.add(2, -1);
        int lastDayOfPreviousMonth = tmpCalendar.getActualMaximum(5);
        tmpCalendar.add(2, 1);
        for (i = 0; i < firstDay; ++i) {
            this.days[i].setEnabled(false);
            this.days[i].setText(Integer.toString(lastDayOfPreviousMonth - firstDay + i + 1));
            this.days[i].setVisible(true);
        }
        tmpCalendar.add(2, 1);
        Date firstDayInNextMonth = tmpCalendar.getTime();
        tmpCalendar.add(2, -1);
        Date day = tmpCalendar.getTime();
        int n = 0;
        Color foregroundColor = this.getForeground();
        while (day.before(firstDayInNextMonth)) {
            this.days[i + n].setText(Integer.toString(n + 1));
            this.days[i + n].setVisible(true);
            if (tmpCalendar.get(6) == this.today.get(6) && tmpCalendar.get(1) == this.today.get(1)) {
                this.days[i + n].setForeground(this.sundayForeground);
            } else if (n + 1 == this.day) {
                this.days[i + n].setForeground(this.selectedColor);
                this.selectedDay = this.days[i + n];
            } else {
                this.days[i + n].setForeground(foregroundColor);
            }
            this.days[i + n].setEnabled(true);
            ++n;
            tmpCalendar.add(5, 1);
            day = tmpCalendar.getTime();
        }
        int actualDays = n;
        while ((n + i) % 7 != 0) {
            this.days[i + n].setText(Integer.toString(n + 1 - actualDays));
            this.days[i + n].setEnabled(false);
            this.days[i + n].setVisible(true);
            ++n;
        }
        for (int k = n + i; k < 42; ++k) {
            this.days[k].setVisible(false);
            this.days[k].setText("");
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
        super.setLocale(locale);
        this.init();
    }

    public void setDay(int newDay) {
        if (newDay < 1) {
            newDay = 1;
        }
        Calendar tmpCalendar = (Calendar)this.calendar.clone();
        tmpCalendar.set(5, 1);
        tmpCalendar.add(2, 1);
        tmpCalendar.add(5, -1);
        int maxDaysInMonth = tmpCalendar.get(5);
        if (newDay > maxDaysInMonth) {
            newDay = maxDaysInMonth;
        }
        this.day = newDay;
        if (this.selectedDay != null) {
            this.selectedDay.setBackground(this.transparentBackgroundColor);
            this.selectedDay.repaint();
        }
        for (int i = 0; i < 42; ++i) {
            if (!this.days[i].getText().equals(Integer.toString(this.day))) continue;
            this.selectedDay = this.days[i];
            this.selectedDay.setForeground(this.selectedColor);
            break;
        }
        this.firePropertyChange("day", 0, this.day);
    }

    public int getDay() {
        return this.day;
    }

    void setMonth(int month) {
        this.calendar.set(2, month);
        int maxDays = this.calendar.getActualMaximum(5);
        if (this.day > maxDays) {
            this.day = maxDays;
        }
        this.drawDays();
    }

    public void setYear(int year) {
        this.calendar.set(1, year);
        this.drawDays();
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.drawDays();
    }
}

