/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import jakarta.xml.bind.annotation.XmlType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.tinymediamanager.library.bluray.playlist.UnsignedIntHelper;

@XmlType(propOrder={"pipMetadataTimeStamp", "pipHorizontalPosition", "pipVerticalPosition", "pipScale"})
public class PIPMetadataEntry {
    private long pipMetadataTimeStamp;
    private int pipHorizontalPosition;
    private int pipVerticalPosition;
    private PIPScaleType pipScale;

    public void readObject(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[4];
        dataInputStream.readFully(byArray);
        this.setPipMetadataTimeStamp(UnsignedIntHelper.convertToLong(byArray));
        dataInputStream.readFully(byArray2);
        long l = UnsignedIntHelper.convertToLong(byArray2);
        int n = (int)((l & 0xFFFFFFFFFFF00000L) >> 20);
        int n2 = (int)((l & 0xFFF00L) >> 8);
        int n3 = (int)((l & 0xF0L) >> 4);
        this.setPipHorizontalPosition(n);
        this.setPipVerticalPosition(n2);
        PIPScaleType[] pIPScaleTypeArray = PIPScaleType.values();
        for (int i = 0; i < pIPScaleTypeArray.length; ++i) {
            if (pIPScaleTypeArray[i].ordinal() != n3) continue;
            this.setPipScale(pIPScaleTypeArray[i]);
            break;
        }
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(UnsignedIntHelper.convertToBytes(this.getPipMetadataTimeStamp()));
        long l = 0L;
        l |= (long)(this.getPipHorizontalPosition() << 20);
        l |= (long)(this.getPipVerticalPosition() << 8);
        dataOutputStream.write(UnsignedIntHelper.convertToBytes(l |= (long)(this.getPipScale().ordinal() << 4)));
    }

    public long getPipMetadataTimeStamp() {
        return this.pipMetadataTimeStamp;
    }

    public void setPipMetadataTimeStamp(long l) {
        this.pipMetadataTimeStamp = l;
    }

    public int getPipHorizontalPosition() {
        return this.pipHorizontalPosition;
    }

    public void setPipHorizontalPosition(int n) {
        this.pipHorizontalPosition = n;
    }

    public int getPipVerticalPosition() {
        return this.pipVerticalPosition;
    }

    public void setPipVerticalPosition(int n) {
        this.pipVerticalPosition = n;
    }

    public PIPScaleType getPipScale() {
        return this.pipScale;
    }

    public void setPipScale(PIPScaleType pIPScaleType) {
        this.pipScale = pIPScaleType;
    }

    static enum PIPScaleType {
        reserved,
        NO_SCALING,
        HALF_SCALING,
        QUARTER_SCALING,
        ONE_AND_HALF_SCALING,
        FULL_SCREEN_SCALING;


        public byte getEncoding() {
            return (byte)this.ordinal();
        }
    }
}

