/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.id;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import org.tinymediamanager.library.bluray.id.HexStringBinaryAdapter;
import org.tinymediamanager.library.bluray.id.HexStringIntegerAdapter;
import org.tinymediamanager.library.bluray.id.IdWriter;

@XmlRootElement
public class Id {
    String version;
    byte[] discId;
    int orgId;

    public Id() {
    }

    public Id(String string, int n, String string2) {
        this.setVersion(string);
        this.setOrgId(n);
        try {
            this.setDiscId(new HexStringBinaryAdapter().unmarshal(string2));
        }
        catch (Exception exception) {
            throw new RuntimeException("disc ID format error: " + string2, exception);
        }
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setDiscId(byte[] byArray) {
        this.discId = byArray;
    }

    @XmlJavaTypeAdapter(value=HexStringBinaryAdapter.class)
    public byte[] getDiscId() {
        return this.discId;
    }

    public void setOrgId(Integer n) {
        this.orgId = n;
    }

    @XmlJavaTypeAdapter(value=HexStringIntegerAdapter.class)
    public Integer getOrgId() {
        return this.orgId;
    }

    public String toXML() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(byteArrayOutputStream));
            new IdWriter().writeXml(this, dataOutputStream);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toString();
    }
}

