/*
 * Decompiled with CFR 0.152.
 */
package de.timroes.axmlrpc.serializer;

import de.timroes.axmlrpc.XMLRPCException;
import de.timroes.axmlrpc.XMLRPCRuntimeException;
import de.timroes.axmlrpc.XMLUtil;
import de.timroes.axmlrpc.serializer.Serializer;
import de.timroes.axmlrpc.serializer.SerializerHandler;
import de.timroes.axmlrpc.xmlcreator.XmlElement;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StructSerializer
implements Serializer {
    private static final String STRUCT_MEMBER = "member";
    private static final String STRUCT_NAME = "name";
    private static final String STRUCT_VALUE = "value";
    private final SerializerHandler serializerHandler;

    public StructSerializer(SerializerHandler serializerHandler) {
        this.serializerHandler = serializerHandler;
    }

    @Override
    public Object deserialize(Element content) throws XMLRPCException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < content.getChildNodes().getLength(); ++i) {
            Node n = content.getChildNodes().item(i);
            if (n.getNodeType() == 3 && n.getNodeValue().trim().length() <= 0 || n.getNodeType() == 8) continue;
            if (n.getNodeType() != 1 || !STRUCT_MEMBER.equals(n.getNodeName())) {
                throw new XMLRPCException("Only struct members allowed within a struct.");
            }
            String s = null;
            Object o = null;
            for (int j = 0; j < n.getChildNodes().getLength(); ++j) {
                Node m = n.getChildNodes().item(j);
                if (m.getNodeType() == 3 && m.getNodeValue().trim().length() <= 0 || m.getNodeType() == 8) continue;
                if (STRUCT_NAME.equals(m.getNodeName())) {
                    if (s != null) {
                        throw new XMLRPCException("Name of a struct member cannot be set twice.");
                    }
                    s = XMLUtil.getOnlyTextContent(m.getChildNodes());
                    continue;
                }
                if (m.getNodeType() == 1 && STRUCT_VALUE.equals(m.getNodeName())) {
                    if (o != null) {
                        throw new XMLRPCException("Value of a struct member cannot be set twice.");
                    }
                    o = this.serializerHandler.deserialize((Element)m);
                    continue;
                }
                throw new XMLRPCException("A struct member must only contain one name and one value.");
            }
            map.put(s, o);
        }
        return map;
    }

    @Override
    public XmlElement serialize(Object object) {
        XmlElement struct = new XmlElement("struct");
        try {
            Map map = (Map)object;
            for (Map.Entry member : map.entrySet()) {
                XmlElement entry = new XmlElement(STRUCT_MEMBER);
                XmlElement name = new XmlElement(STRUCT_NAME);
                XmlElement value = new XmlElement(STRUCT_VALUE);
                name.setContent((String)member.getKey());
                value.addChildren(this.serializerHandler.serialize(member.getValue()));
                entry.addChildren(name);
                entry.addChildren(value);
                struct.addChildren(entry);
            }
        }
        catch (XMLRPCException ex) {
            throw new XMLRPCRuntimeException(ex);
        }
        return struct;
    }
}

