/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.dbmigrator.mvstore.tx;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.tinymediamanager.dbmigrator.engine.IsolationLevel;
import org.tinymediamanager.dbmigrator.mvstore.Cursor;
import org.tinymediamanager.dbmigrator.mvstore.DataUtils;
import org.tinymediamanager.dbmigrator.mvstore.MVMap;
import org.tinymediamanager.dbmigrator.mvstore.Page;
import org.tinymediamanager.dbmigrator.mvstore.RootReference;
import org.tinymediamanager.dbmigrator.mvstore.tx.Snapshot;
import org.tinymediamanager.dbmigrator.mvstore.tx.Transaction;
import org.tinymediamanager.dbmigrator.mvstore.tx.TransactionStore;
import org.tinymediamanager.dbmigrator.mvstore.tx.TxDecisionMaker;
import org.tinymediamanager.dbmigrator.mvstore.tx.VersionedValueCommitted;
import org.tinymediamanager.dbmigrator.mvstore.tx.VersionedValueUncommitted;
import org.tinymediamanager.dbmigrator.mvstore.type.DataType;
import org.tinymediamanager.dbmigrator.value.VersionedValue;

public class TransactionMap<K, V>
extends AbstractMap<K, V> {
    public final MVMap<K, VersionedValue> map;
    private final Transaction transaction;

    TransactionMap(Transaction transaction, MVMap<K, VersionedValue> mVMap) {
        this.transaction = transaction;
        this.map = mVMap;
    }

    public TransactionMap<K, V> getInstance(Transaction transaction) {
        return new TransactionMap<K, V>(transaction, this.map);
    }

    @Override
    public final int size() {
        long l = this.sizeAsLong();
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    public long sizeAsLongMax() {
        return this.map.sizeAsLong();
    }

    public long sizeAsLong() {
        long l;
        RootReference[] rootReferenceArray;
        Snapshot snapshot;
        if (this.transaction.isolationLevel != IsolationLevel.READ_COMMITTED) {
            return this.sizeAsLongSlow();
        }
        do {
            snapshot = this.getSnapshot();
            rootReferenceArray = this.getTransaction().getUndoLogRootReferences();
        } while (!snapshot.equals(this.getSnapshot()));
        RootReference rootReference = snapshot.root;
        BitSet bitSet = snapshot.committingTransactions;
        Page page = rootReference.root;
        long l2 = rootReference.getTotalCount();
        long l3 = l = rootReferenceArray == null ? l2 : TransactionStore.calculateUndoLogsTotalSize(rootReferenceArray);
        if (l == 0L) {
            return l2;
        }
        if (2L * l > l2) {
            Cursor cursor = new Cursor(page, null);
            while (cursor.hasNext()) {
                cursor.next();
                VersionedValue versionedValue = (VersionedValue)cursor.getValue();
                assert (versionedValue != null);
                long l4 = versionedValue.getOperationId();
                if (l4 == 0L || !this.isIrrelevant(l4, versionedValue, bitSet)) continue;
                --l2;
            }
        } else {
            assert (rootReferenceArray != null);
            for (RootReference rootReference2 : rootReferenceArray) {
                if (rootReference2 == null) continue;
                Cursor cursor = new Cursor(rootReference2.root, null);
                while (cursor.hasNext()) {
                    VersionedValue versionedValue;
                    cursor.next();
                    Object[] objectArray = (Object[])cursor.getValue();
                    if (((Integer)objectArray[0]).intValue() != this.map.getId() || (versionedValue = this.map.get(page, objectArray[1])) == null) continue;
                    long l5 = cursor.getKey();
                    assert (l5 != 0L);
                    if (versionedValue.getOperationId() != l5 || !this.isIrrelevant(l5, versionedValue, bitSet)) continue;
                    --l2;
                }
            }
        }
        return l2;
    }

    private long sizeAsLongSlow() {
        long l = 0L;
        Iterator<Object> iterator = this.keyIterator(null, null);
        while (iterator.hasNext()) {
            iterator.next();
            ++l;
        }
        return l;
    }

    private boolean isIrrelevant(long l, VersionedValue versionedValue, BitSet bitSet) {
        int n = TransactionStore.getTransactionId(l);
        boolean bl = n == this.transaction.transactionId || bitSet.get(n);
        Object object = bl ? versionedValue.getCurrentValue() : versionedValue.getCommittedValue();
        return object == null;
    }

    @Override
    public V remove(Object object) {
        return (V)this.set(object, (Object)null);
    }

    @Override
    public V put(K k, V v) {
        DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
        return this.set(k, v);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
        TxDecisionMaker.PutIfAbsentDecisionMaker putIfAbsentDecisionMaker = new TxDecisionMaker.PutIfAbsentDecisionMaker(this.map.getId(), k, v, this.transaction);
        return this.set((Object)k, putIfAbsentDecisionMaker);
    }

    public void append(K k, V v) {
        this.map.append(k, VersionedValueUncommitted.getInstance(this.transaction.log(this.map.getId(), k, null), v, null));
    }

    public V lock(K k) {
        TxDecisionMaker.LockDecisionMaker lockDecisionMaker = new TxDecisionMaker.LockDecisionMaker(this.map.getId(), k, this.transaction);
        return this.set((Object)k, lockDecisionMaker);
    }

    public V putCommitted(K k, V v) {
        DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
        VersionedValue versionedValue = VersionedValueCommitted.getInstance(v);
        VersionedValue versionedValue2 = this.map.put(k, versionedValue);
        Object object = versionedValue2 == null ? null : versionedValue2.getCurrentValue();
        return (V)object;
    }

    private V set(Object object, V v) {
        TxDecisionMaker txDecisionMaker = new TxDecisionMaker(this.map.getId(), object, v, this.transaction);
        return this.set(object, txDecisionMaker);
    }

    private V set(Object object, TxDecisionMaker txDecisionMaker) {
        VersionedValue versionedValue;
        long l;
        Transaction transaction;
        TransactionStore transactionStore = this.transaction.store;
        do {
            l = transactionStore.openTransactions.get().getVersion();
            assert (this.transaction.getBlockerId() == 0);
            Object object2 = object;
            versionedValue = this.map.operate(object2, VersionedValue.DUMMY, txDecisionMaker);
            MVMap.Decision decision = txDecisionMaker.getDecision();
            assert (decision != null);
            assert (decision != MVMap.Decision.REPEAT);
            transaction = txDecisionMaker.getBlockingTransaction();
            if (decision != MVMap.Decision.ABORT || transaction == null) {
                Object object3 = versionedValue == null ? null : versionedValue.getCurrentValue();
                return (V)object3;
            }
            txDecisionMaker.reset();
        } while (transaction.sequenceNum > l || this.transaction.waitFor(transaction, this.map, object));
        throw DataUtils.newIllegalStateException(101, "Map entry <{0}> with key <{1}> and value {2} is locked by tx {3} and can not be updated by tx {4} within allocated time interval {5} ms.", this.map.getName(), object, versionedValue, transaction.transactionId, this.transaction.transactionId, this.transaction.timeoutMillis);
    }

    public boolean tryRemove(K k) {
        return this.trySet(k, null);
    }

    public boolean tryPut(K k, V v) {
        DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
        return this.trySet(k, v);
    }

    public boolean trySet(K k, V v) {
        try {
            this.set(k, v);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    @Override
    public V get(Object object) {
        return this.getImmediate(object);
    }

    public V getFromSnapshot(Object object) {
        int n;
        long l;
        VersionedValue versionedValue;
        Snapshot snapshot;
        switch (this.transaction.isolationLevel) {
            case READ_UNCOMMITTED: {
                Snapshot snapshot2 = this.getStatementSnapshot();
                VersionedValue versionedValue2 = this.map.get(snapshot2.root.root, object);
                if (versionedValue2 != null) {
                    return (V)versionedValue2.getCurrentValue();
                }
                return null;
            }
            case REPEATABLE_READ: 
            case SNAPSHOT: 
            case SERIALIZABLE: {
                if (!this.transaction.hasChanges()) break;
                snapshot = this.getStatementSnapshot();
                versionedValue = this.map.get(snapshot.root.root, object);
                if (versionedValue == null || (l = versionedValue.getOperationId()) == 0L || this.transaction.transactionId != TransactionStore.getTransactionId(l)) break;
                return (V)versionedValue.getCurrentValue();
            }
        }
        snapshot = this.getSnapshot();
        versionedValue = this.map.get(snapshot.root.root, object);
        if (versionedValue == null) {
            return null;
        }
        l = versionedValue.getOperationId();
        if (l != 0L && (n = TransactionStore.getTransactionId(l)) != this.transaction.transactionId && !snapshot.committingTransactions.get(n)) {
            return (V)versionedValue.getCommittedValue();
        }
        return (V)versionedValue.getCurrentValue();
    }

    public V getImmediate(Object object) {
        VersionedValue versionedValue = this.map.get(object);
        if (versionedValue == null) {
            return null;
        }
        long l = versionedValue.getOperationId();
        if (l == 0L) {
            return (V)versionedValue.getCurrentValue();
        }
        int n = TransactionStore.getTransactionId(l);
        if (n == this.transaction.transactionId || this.transaction.store.committingTransactions.get().get(n)) {
            return (V)versionedValue.getCurrentValue();
        }
        return (V)versionedValue.getCommittedValue();
    }

    Snapshot getSnapshot() {
        return this.transaction.getSnapshot(this.map.getId());
    }

    Snapshot getStatementSnapshot() {
        return this.transaction.getStatementSnapshot(this.map.getId());
    }

    Snapshot createSnapshot() {
        return this.transaction.createSnapshot(this.map.getId());
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getImmediate(object) != null;
    }

    public boolean isSameTransaction(K k) {
        VersionedValue versionedValue = this.map.get(k);
        if (versionedValue == null) {
            return false;
        }
        int n = TransactionStore.getTransactionId(versionedValue.getOperationId());
        return n == this.transaction.transactionId;
    }

    public boolean isClosed() {
        return this.map.isClosed();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return TransactionMap.this.entryIterator(null, null);
            }

            @Override
            public int size() {
                return TransactionMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return TransactionMap.this.containsKey(object);
            }
        };
    }

    public K firstKey() {
        Iterator<Object> iterator = this.keyIterator(null);
        return (K)(iterator.hasNext() ? iterator.next() : null);
    }

    public K lastKey() {
        RootReference rootReference = this.getSnapshot().root;
        K k = this.map.lastKey(rootReference.root);
        while (k != null && this.getFromSnapshot(k) == null) {
            k = this.map.lowerKey(rootReference.root, k);
        }
        return k;
    }

    public K higherKey(K k) {
        RootReference rootReference = this.getSnapshot().root;
        while ((k = this.map.higherKey(rootReference.root, k)) != null && this.getFromSnapshot(k) == null) {
        }
        return k;
    }

    public K ceilingKey(K k) {
        Iterator<K> iterator = this.keyIterator(k);
        return iterator.hasNext() ? (K)iterator.next() : null;
    }

    public K floorKey(K k) {
        RootReference rootReference = this.getSnapshot().root;
        k = this.map.floorKey(rootReference.root, k);
        while (k != null && this.getFromSnapshot(k) == null) {
            k = this.map.lowerKey(rootReference.root, k);
        }
        return k;
    }

    public K lowerKey(K k) {
        RootReference rootReference = this.getSnapshot().root;
        while ((k = this.map.lowerKey(rootReference.root, k)) != null && this.getFromSnapshot(k) == null) {
        }
        return k;
    }

    public Iterator<K> keyIterator(K k) {
        return this.keyIterator(k, null);
    }

    public Iterator<K> keyIterator(K k, K k2) {
        return this.chooseIterator(k, k2, false);
    }

    public Iterator<K> keyIteratorUncommitted(K k, K k2) {
        return new ValidationIterator(this, k, k2);
    }

    public Iterator<Map.Entry<K, V>> entryIterator(K k, K k2) {
        return this.chooseIterator(k, k2, true);
    }

    private <X> Iterator<X> chooseIterator(K k, K k2, boolean bl) {
        switch (this.transaction.isolationLevel) {
            case READ_UNCOMMITTED: {
                return new UncommittedIterator(this, k, k2, bl);
            }
            case REPEATABLE_READ: 
            case SNAPSHOT: 
            case SERIALIZABLE: {
                if (!this.transaction.hasChanges()) break;
                return new RepeatableIterator(this, k, k2, bl);
            }
        }
        return new CommittedIterator(this, k, k2, bl);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public DataType getKeyType() {
        return this.map.getKeyType();
    }

    private static abstract class TMIterator<K, X>
    implements Iterator<X> {
        final int transactionId;
        final BitSet committingTransactions;
        protected final Cursor<K, VersionedValue> cursor;
        private final boolean forEntries;
        X current;

        TMIterator(TransactionMap<K, ?> transactionMap, K k, K k2, Snapshot snapshot, boolean bl) {
            Transaction transaction = transactionMap.getTransaction();
            this.transactionId = transaction.transactionId;
            this.forEntries = bl;
            this.cursor = new Cursor(snapshot.root.root, k, k2);
            this.committingTransactions = snapshot.committingTransactions;
        }

        final void registerCurrent(K k, Object object) {
            this.current = this.forEntries ? new AbstractMap.SimpleImmutableEntry<K, Object>(k, object) : k;
        }

        abstract void fetchNext();

        @Override
        public final boolean hasNext() {
            return this.current != null;
        }

        @Override
        public final X next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            X x = this.current;
            this.fetchNext();
            return x;
        }

        @Override
        public final void remove() {
            throw DataUtils.newUnsupportedOperationException("Removal is not supported");
        }
    }

    private static final class RepeatableIterator<K, X>
    extends TMIterator<K, X> {
        private final DataType keyType;
        private K snapshotKey;
        private Object snapshotValue;
        private final Cursor<K, VersionedValue> uncommittedCursor;
        private K uncommittedKey;
        private Object uncommittedValue;

        RepeatableIterator(TransactionMap<K, ?> transactionMap, K k, K k2, boolean bl) {
            super(transactionMap, k, k2, transactionMap.getSnapshot(), bl);
            this.keyType = transactionMap.map.getKeyType();
            Snapshot snapshot = transactionMap.getStatementSnapshot();
            this.uncommittedCursor = new Cursor(snapshot.root.root, k, k2);
            this.fetchNext();
        }

        @Override
        void fetchNext() {
            this.current = null;
            do {
                int n;
                if (this.snapshotKey == null) {
                    this.fetchSnapshot();
                }
                if (this.uncommittedKey == null) {
                    this.fetchUncommitted();
                }
                if (this.snapshotKey == null && this.uncommittedKey == null) break;
                int n2 = this.snapshotKey == null ? 1 : (n = this.uncommittedKey == null ? -1 : this.keyType.compare(this.snapshotKey, this.uncommittedKey));
                if (n < 0) {
                    this.registerCurrent(this.snapshotKey, this.snapshotValue);
                    this.snapshotKey = null;
                    break;
                }
                if (this.uncommittedValue != null) {
                    this.registerCurrent(this.uncommittedKey, this.uncommittedValue);
                }
                if (n == 0) {
                    this.snapshotKey = null;
                }
                this.uncommittedKey = null;
            } while (this.current == null);
        }

        private void fetchSnapshot() {
            while (this.cursor.hasNext()) {
                int n;
                Object k = this.cursor.next();
                VersionedValue versionedValue = (VersionedValue)this.cursor.getValue();
                if (versionedValue == null) continue;
                Object object = versionedValue.getCommittedValue();
                long l = versionedValue.getOperationId();
                if (l != 0L && ((n = TransactionStore.getTransactionId(l)) == this.transactionId || this.committingTransactions.get(n))) {
                    object = versionedValue.getCurrentValue();
                }
                if (object == null) continue;
                this.snapshotKey = k;
                this.snapshotValue = object;
                return;
            }
        }

        private void fetchUncommitted() {
            while (this.uncommittedCursor.hasNext()) {
                long l;
                K k = this.uncommittedCursor.next();
                VersionedValue versionedValue = this.uncommittedCursor.getValue();
                if (versionedValue == null || (l = versionedValue.getOperationId()) == 0L || this.transactionId != TransactionStore.getTransactionId(l)) continue;
                this.uncommittedKey = k;
                this.uncommittedValue = versionedValue.getCurrentValue();
                return;
            }
        }
    }

    private static final class CommittedIterator<K, X>
    extends TMIterator<K, X> {
        CommittedIterator(TransactionMap<K, ?> transactionMap, K k, K k2, boolean bl) {
            super(transactionMap, k, k2, transactionMap.getSnapshot(), bl);
            this.fetchNext();
        }

        @Override
        void fetchNext() {
            while (this.cursor.hasNext()) {
                int n;
                Object k = this.cursor.next();
                VersionedValue versionedValue = (VersionedValue)this.cursor.getValue();
                if (versionedValue == null) continue;
                long l = versionedValue.getOperationId();
                if (l != 0L && (n = TransactionStore.getTransactionId(l)) != this.transactionId && !this.committingTransactions.get(n)) {
                    Object object = versionedValue.getCommittedValue();
                    if (object == null) continue;
                    this.registerCurrent(k, object);
                    return;
                }
                Object object = versionedValue.getCurrentValue();
                if (object == null) continue;
                this.registerCurrent(k, object);
                return;
            }
            this.current = null;
        }
    }

    private static final class ValidationIterator<K, X>
    extends UncommittedIterator<K, X> {
        ValidationIterator(TransactionMap<K, ?> transactionMap, K k, K k2) {
            super(transactionMap, k, k2, transactionMap.createSnapshot(), false);
        }

        @Override
        boolean isApplicable(VersionedValue versionedValue) {
            long l = versionedValue.getOperationId();
            if (l != 0L) {
                int n = TransactionStore.getTransactionId(l);
                return this.transactionId != n && !this.committingTransactions.get(n);
            }
            return false;
        }
    }

    private static class UncommittedIterator<K, X>
    extends TMIterator<K, X> {
        UncommittedIterator(TransactionMap<K, ?> transactionMap, K k, K k2, boolean bl) {
            super(transactionMap, k, k2, transactionMap.getStatementSnapshot(), bl);
            this.fetchNext();
        }

        UncommittedIterator(TransactionMap<K, ?> transactionMap, K k, K k2, Snapshot snapshot, boolean bl) {
            super(transactionMap, k, k2, snapshot, bl);
            this.fetchNext();
        }

        @Override
        final void fetchNext() {
            while (this.cursor.hasNext()) {
                Object object;
                Object k = this.cursor.next();
                VersionedValue versionedValue = (VersionedValue)this.cursor.getValue();
                if (versionedValue == null || (object = versionedValue.getCurrentValue()) == null && !this.isApplicable(versionedValue)) continue;
                this.registerCurrent(k, object);
                return;
            }
            this.current = null;
        }

        boolean isApplicable(VersionedValue versionedValue) {
            return false;
        }
    }
}

