/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Protocol {
    ALL("*"),
    HTTP_GET("http-get"),
    RTSP_RTP_UDP("rtsp-rtp-udp"),
    INTERNAL("internal"),
    IEC61883("iec61883"),
    XBMC_GET("xbmc-get"),
    OTHER("other");

    private static final Logger LOGGER;
    private final String protocolString;

    private Protocol(String protocolString) {
        this.protocolString = protocolString;
    }

    public String toString() {
        return this.protocolString;
    }

    public static Protocol value(String s) {
        for (Protocol protocol : Protocol.values()) {
            if (!protocol.toString().equals(s)) continue;
            return protocol;
        }
        LOGGER.info("Unsupported OTHER protocol string: {}", (Object)s);
        return OTHER;
    }

    static {
        LOGGER = LoggerFactory.getLogger(Protocol.class);
    }
}

