/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.renderer.RightAlignTableCellRenderer;

public class TvShowMissingEpisodeListDialog
extends TmmDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowMissingEpisodeListDialog.class);
    private final JButton btnClose;
    private final JCheckBox chckbxShowMissingSpecials;
    private final JCheckBox chckbxIncludeNotAired;
    private final JProgressBar pbListEpisodes;
    private final EventList<EpisodeContainer> results = new SortedList((EventList)GlazedListsSwing.swingThreadProxyList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList())), (Comparator)new EpisodeContainerComparator());
    private final TmmTable tblMissingEpisodeList;
    private SwingWorker<Void, Void> episodeListWorker = null;

    public TvShowMissingEpisodeListDialog(List<TvShow> tvShows) {
        super(TmmResourceBundle.getString("tvshow.missingepisodelist"), "missingepisodelist");
        TmmTableModel<EpisodeContainer> missingEpisodeListModel = new TmmTableModel<EpisodeContainer>((EventList<EpisodeContainer>)GlazedListsSwing.swingThreadProxyList(this.results), new MissingEpisodeListTableFormat());
        JPanel panelContent = new JPanel();
        panelContent.setLayout((LayoutManager)new MigLayout("", "[700lp,grow]", "[grow]"));
        this.getContentPane().add((Component)panelContent, "Center");
        this.tblMissingEpisodeList = new TmmTable((TableModel)((Object)missingEpisodeListModel));
        JScrollPane scrollPane = new JScrollPane();
        this.tblMissingEpisodeList.configureScrollPane(scrollPane);
        panelContent.add((Component)scrollPane, "cell 0 0, grow");
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[]"));
        this.chckbxShowMissingSpecials = new JCheckBox(TmmResourceBundle.getString("Settings.tvshow.missingespecials"));
        this.chckbxShowMissingSpecials.setSelected(TvShowModuleManager.getInstance().getSettings().isDisplayMissingSpecials());
        this.chckbxShowMissingSpecials.addItemListener(e -> {
            if (this.episodeListWorker != null && !this.episodeListWorker.isDone()) {
                this.episodeListWorker.cancel(true);
            }
            this.results.clear();
            this.episodeListWorker = new EpisodeListWorker(tvShows);
            this.episodeListWorker.execute();
        });
        infoPanel.add((Component)this.chckbxShowMissingSpecials, "cell 0 0");
        this.chckbxIncludeNotAired = new JCheckBox(TmmResourceBundle.getString("Settings.tvshow.missingnotaired"));
        this.chckbxIncludeNotAired.setSelected(TvShowModuleManager.getInstance().getSettings().isDisplayMissingNotAired());
        this.chckbxIncludeNotAired.addItemListener(e -> {
            if (this.episodeListWorker != null && !this.episodeListWorker.isDone()) {
                this.episodeListWorker.cancel(true);
            }
            this.results.clear();
            this.episodeListWorker = new EpisodeListWorker(tvShows);
            this.episodeListWorker.execute();
        });
        infoPanel.add((Component)this.chckbxIncludeNotAired, "cell 1 0");
        this.pbListEpisodes = new JProgressBar();
        infoPanel.add((Component)this.pbListEpisodes, "cell 1 0");
        this.setBottomInformationPanel(infoPanel);
        this.btnClose = new JButton(TmmResourceBundle.getString("Button.close"));
        this.btnClose.addActionListener(e -> this.setVisible(false));
        this.addDefaultButton(this.btnClose);
        this.episodeListWorker = new EpisodeListWorker(tvShows);
        this.episodeListWorker.execute();
    }

    private void startProgressBar() {
        SwingUtilities.invokeLater(() -> {
            this.pbListEpisodes.setVisible(true);
            this.pbListEpisodes.setIndeterminate(true);
        });
    }

    private void stopProgressBar() {
        SwingUtilities.invokeLater(() -> {
            this.pbListEpisodes.setVisible(false);
            this.pbListEpisodes.setIndeterminate(false);
        });
    }

    private static class EpisodeContainerComparator
    implements Comparator<EpisodeContainer> {
        private EpisodeContainerComparator() {
        }

        @Override
        public int compare(EpisodeContainer o1, EpisodeContainer o2) {
            if (!o1.tvShowTitle.equals(o2.tvShowTitle)) {
                return o1.tvShowTitle.compareTo(o2.tvShowTitle);
            }
            if (o1.season != o2.season) {
                return o1.season - o2.season;
            }
            return o1.episode - o2.episode;
        }
    }

    private static class MissingEpisodeListTableFormat
    extends TmmTableFormat<EpisodeContainer> {
        MissingEpisodeListTableFormat() {
            TmmTableFormat.StringComparator stringComparator = new TmmTableFormat.StringComparator();
            TmmTableFormat.IntegerComparator integerComparator = new TmmTableFormat.IntegerComparator();
            TmmTableFormat.DateComparator dateComparator = new TmmTableFormat.DateComparator();
            FontMetrics fontMetrics = this.getFontMetrics();
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.tvshow"), "title", container -> container.tvShowTitle, String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.season"), "season", container -> container.season, Integer.class);
            col.setColumnComparator(integerComparator);
            col.setCellRenderer(new RightAlignTableCellRenderer());
            col.setColumnResizeable(false);
            int seasonWidth = fontMetrics.stringWidth(TmmResourceBundle.getString("metatag.season"));
            col.setMinWidth((int)((float)seasonWidth * 1.2f));
            col.setMaxWidth((int)((float)seasonWidth * 1.5f));
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.episode"), "episode", container -> container.episode, Integer.class);
            col.setColumnComparator(integerComparator);
            col.setCellRenderer(new RightAlignTableCellRenderer());
            col.setColumnResizeable(false);
            int episodeWidth = fontMetrics.stringWidth(TmmResourceBundle.getString("metatag.episode"));
            col.setMinWidth((int)((float)episodeWidth * 1.2f));
            col.setMaxWidth((int)((float)episodeWidth * 1.5f));
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.aired"), "airedDate", container -> container.airedDate, Date.class);
            col.setColumnComparator(dateComparator);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.title"), "episodeTitle", container -> container.episodeTitle, String.class);
            col.setColumnComparator(stringComparator);
            col.setColumnResizeable(true);
            this.addColumn(col);
        }
    }

    private class EpisodeListWorker
    extends SwingWorker<Void, Void> {
        private final List<TvShow> tvShows;

        EpisodeListWorker(List<TvShow> tvShows) {
            this.tvShows = tvShows;
        }

        @Override
        protected Void doInBackground() {
            TvShowMissingEpisodeListDialog.this.btnClose.setEnabled(false);
            TvShowMissingEpisodeListDialog.this.chckbxShowMissingSpecials.setEnabled(false);
            TvShowMissingEpisodeListDialog.this.chckbxIncludeNotAired.setEnabled(false);
            TvShowMissingEpisodeListDialog.this.startProgressBar();
            this.compareTvShows();
            return null;
        }

        private List<MediaMetadata> getEpisodes(TvShow tvShow) {
            TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions();
            options.setLanguage(TvShowModuleManager.getInstance().getSettings().getScraperLanguage());
            options.setCertificationCountry(TvShowModuleManager.getInstance().getSettings().getCertificationCountry());
            options.setReleaseDateCountry(TvShowModuleManager.getInstance().getSettings().getReleaseDateCountry());
            MediaScraper mediaScraper = TvShowModuleManager.getInstance().getTvShowList().getDefaultMediaScraper();
            MediaMetadata md = new MediaMetadata(mediaScraper.getMediaProvider().getProviderInfo().getId());
            options.setMetadata(md);
            for (Map.Entry<String, Object> entry : tvShow.getIds().entrySet()) {
                options.setId(entry.getKey(), entry.getValue().toString());
            }
            try {
                return ((ITvShowMetadataProvider)mediaScraper.getMediaProvider()).getEpisodeList(options);
            }
            catch (MissingIdException e) {
                LOGGER.warn("Missing IDs for scraping TV show '{}' with '{}'", (Object)tvShow.getTitle(), (Object)mediaScraper.getId());
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, tvShow, "scraper.error.missingid"));
            }
            catch (NothingFoundException e) {
                LOGGER.debug("nothing found");
            }
            catch (ScrapeException e) {
                LOGGER.error("Could not scrape TV show '{}' with '{}' - '{}'", new Object[]{tvShow.getTitle(), mediaScraper.getId(), e.getMessage()});
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvShow, "message.scrape.metadataepisodefailed", new String[]{":", e.getLocalizedMessage()}));
            }
            catch (Exception e) {
                LOGGER.error("Unforeseen error while scraping TV show '{}' with '{}'", new Object[]{tvShow.getTitle(), mediaScraper.getId(), e});
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvShow, "message.scrape.episodelistfailed", new String[]{":", e.getLocalizedMessage()}));
            }
            return null;
        }

        private void compareTvShows() {
            for (TvShow tvshow : this.tvShows) {
                if (tvshow.getIds().isEmpty()) {
                    LOGGER.info("Cannot get episode list (no ID available) for '{}'", (Object)tvshow.getTitle());
                    continue;
                }
                List<TvShowEpisode> scrapedEpisodes = tvshow.getEpisodes();
                List<MediaMetadata> mediaEpisodes = this.getEpisodes(tvshow);
                for (MediaMetadata mediaEpisode : ListUtils.nullSafe(mediaEpisodes)) {
                    boolean alreadyAired;
                    boolean entryFound = false;
                    EpisodeContainer container = new EpisodeContainer();
                    container.tvShowTitle = tvshow.getTitle();
                    container.episodeTitle = mediaEpisode.getTitle();
                    MediaEpisodeNumber episodeNumber = mediaEpisode.getEpisodeNumber(tvshow.getEpisodeGroup());
                    if (episodeNumber != null) {
                        container.season = episodeNumber.season();
                        container.episode = episodeNumber.episode();
                    }
                    container.airedDate = mediaEpisode.getReleaseDate();
                    boolean bl = alreadyAired = mediaEpisode.getReleaseDate() != null && mediaEpisode.getReleaseDate().compareTo(new Date()) <= 0;
                    if (!alreadyAired && !TvShowMissingEpisodeListDialog.this.chckbxIncludeNotAired.isSelected()) continue;
                    block2: for (TvShowEpisode scrapedEpisode : scrapedEpisodes) {
                        boolean showMissingSpecials = TvShowMissingEpisodeListDialog.this.chckbxShowMissingSpecials.isSelected();
                        if (!showMissingSpecials && container.season <= 0) {
                            entryFound = true;
                            break;
                        }
                        if (scrapedEpisode.getEpisode() == container.episode && scrapedEpisode.getSeason() == container.season) {
                            entryFound = true;
                            break;
                        }
                        for (Map.Entry<String, Object> entry : scrapedEpisode.getIds().entrySet()) {
                            if (!entry.getValue().equals(mediaEpisode.getId(entry.getKey()))) continue;
                            entryFound = true;
                            continue block2;
                        }
                    }
                    if (entryFound) continue;
                    TvShowMissingEpisodeListDialog.this.results.add((Object)container);
                }
            }
        }

        @Override
        protected void done() {
            TvShowMissingEpisodeListDialog.this.stopProgressBar();
            TvShowMissingEpisodeListDialog.this.btnClose.setEnabled(true);
            TvShowMissingEpisodeListDialog.this.chckbxShowMissingSpecials.setEnabled(true);
            TvShowMissingEpisodeListDialog.this.chckbxIncludeNotAired.setEnabled(true);
            TvShowMissingEpisodeListDialog.this.tblMissingEpisodeList.adjustColumnPreferredWidths(3);
        }
    }

    private static class EpisodeContainer {
        String tvShowTitle;
        int season;
        int episode;
        String episodeTitle;
        Date airedDate;

        private EpisodeContainer() {
        }
    }
}

