/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.renderer;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.tinymediamanager.core.RenamerPreviewContainer;
import org.tinymediamanager.ui.IconManager;

public class RenamerCellRenderer
extends JTextPane
implements TableCellRenderer {
    private final StyledDocument document = this.getStyledDocument();
    private final Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
    private boolean forOldFilenames;

    public static RenamerCellRenderer forOldFilenames() {
        RenamerCellRenderer instance = new RenamerCellRenderer();
        instance.forOldFilenames = true;
        return instance;
    }

    public static RenamerCellRenderer forNewFilenames() {
        RenamerCellRenderer instance = new RenamerCellRenderer();
        instance.forOldFilenames = false;
        return instance;
    }

    private RenamerCellRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof RenamerPreviewContainer.MediaFileTypeContainer) {
            RenamerPreviewContainer.MediaFileTypeContainer container = (RenamerPreviewContainer.MediaFileTypeContainer)value;
            this.setText(null);
            if (this.forOldFilenames) {
                boolean first = true;
                for (String filename : container.oldFiles) {
                    try {
                        if (!first) {
                            this.document.insertString(this.document.getLength(), "\n", this.defaultStyle);
                        }
                        if (container.newFiles.contains(filename)) {
                            this.insertIcon(IconManager.RENAMER_SPACER);
                        } else {
                            this.insertIcon(IconManager.RENAMER_REMOVED);
                        }
                        this.document.insertString(this.document.getLength(), "  " + filename, this.defaultStyle);
                        first = false;
                    }
                    catch (BadLocationException e) {
                        throw new RuntimeException(e);
                    }
                }
            } else {
                boolean first = true;
                for (String filename : container.newFiles) {
                    try {
                        if (!first) {
                            this.document.insertString(this.document.getLength(), "\n", this.defaultStyle);
                        }
                        if (container.oldFiles.contains(filename)) {
                            this.insertIcon(IconManager.RENAMER_SPACER);
                        } else {
                            this.insertIcon(IconManager.RENAMER_ADDED);
                        }
                        this.document.insertString(this.document.getLength(), "  " + filename, this.defaultStyle);
                        first = false;
                    }
                    catch (BadLocationException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        } else {
            this.setText(value != null ? value.toString() : "");
            this.setFont(table.getFont());
        }
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.width += 5;
        return preferredSize;
    }
}

