/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class MovieSetRemoveAction
extends TmmAction {
    public MovieSetRemoveAction() {
        this.putValue("Name", TmmResourceBundle.getString("movieset.remove.desc"));
        this.putValue("SwingLargeIconKey", IconManager.DELETE);
        this.putValue("SmallIcon", IconManager.DELETE);
        this.putValue("ShortDescription", TmmResourceBundle.getString("movieset.remove.desc"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<MovieSet> selectedMovieSets = MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovieSets();
        if (selectedMovieSets.isEmpty()) {
            return;
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        for (MovieSet movieSet : selectedMovieSets) {
            MovieModuleManager.getInstance().getMovieList().removeMovieSet(movieSet);
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

