/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.toast;

import java.awt.Component;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.tinymediamanager.ui.components.toast.TmmToast;

public class TmmToastManager {
    private TmmToastManager() {
        throw new IllegalAccessError();
    }

    public static void showToast(Component component, String message, TmmToast.ToastType type, int durationMs) {
        if (component == null) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window != null) {
            TmmToast toast = TmmToast.install(window);
            toast.showToast(message, type, durationMs);
        }
    }

    public static void showToast(Component component, String title, String message, TmmToast.ToastType type, int durationMs) {
        if (component == null) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window != null) {
            TmmToast toast = TmmToast.install(window);
            toast.showToast(title, message, type, durationMs);
        }
    }

    public static void showToast(Component component, String message) {
        TmmToastManager.showToast(component, message, TmmToast.ToastType.INFO, 3000);
    }

    public static void showToast(Component component, String title, String message) {
        TmmToastManager.showToast(component, title, message, TmmToast.ToastType.INFO, 3000);
    }

    public static void showSuccessToast(Component component, String message) {
        TmmToastManager.showToast(component, message, TmmToast.ToastType.SUCCESS, 3000);
    }

    public static void showSuccessToast(Component component, String title, String message) {
        TmmToastManager.showToast(component, title, message, TmmToast.ToastType.SUCCESS, 3000);
    }

    public static void showWarningToast(Component component, String message) {
        TmmToastManager.showToast(component, message, TmmToast.ToastType.WARNING, 4000);
    }

    public static void showWarningToast(Component component, String title, String message) {
        TmmToastManager.showToast(component, title, message, TmmToast.ToastType.WARNING, 4000);
    }

    public static void showErrorToast(Component component, String message) {
        TmmToastManager.showToast(component, message, TmmToast.ToastType.ERROR, 5000);
    }

    public static void showErrorToast(Component component, String title, String message) {
        TmmToastManager.showToast(component, title, message, TmmToast.ToastType.ERROR, 5000);
    }

    public static TmmToast getToast(Component component) {
        if (component == null) {
            return null;
        }
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window != null) {
            return TmmToast.install(window);
        }
        return null;
    }
}

