/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.Component;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class NumberCellEditor
extends DefaultCellEditor {
    private int maxIntegerDigits;
    private int maxFractionDigits;

    public NumberCellEditor(int maxIntegerDigits, int maxFractionDigits) {
        super(new JFormattedTextField());
        this.maxIntegerDigits = maxIntegerDigits;
        this.maxFractionDigits = maxFractionDigits;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JFormattedTextField editor = (JFormattedTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        if (value instanceof Number) {
            Locale myLocale = Locale.getDefault();
            NumberFormat numberFormat = NumberFormat.getInstance(myLocale);
            numberFormat.setMinimumFractionDigits(0);
            numberFormat.setMaximumFractionDigits(this.maxFractionDigits);
            numberFormat.setMinimumIntegerDigits(1);
            numberFormat.setMaximumIntegerDigits(this.maxIntegerDigits);
            editor.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(numberFormat)));
            editor.setHorizontalAlignment(4);
            editor.setValue(value);
        }
        return editor;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.getCellEditorValue();
            return super.stopCellEditing();
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public Object getCellEditorValue() {
        String str = (String)super.getCellEditorValue();
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return null;
        }
        try {
            ParsePosition pos = new ParsePosition(0);
            Number n = NumberFormat.getInstance().parse(str, pos);
            if (pos.getIndex() != str.length()) {
                throw new ParseException("parsing incomplete", pos.getIndex());
            }
            if (this.maxFractionDigits > 0) {
                return Float.valueOf(n.floatValue());
            }
            return n.intValue();
        }
        catch (ParseException pex) {
            throw new RuntimeException(pex);
        }
    }
}

