/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.opensubtitles;

import de.timroes.axmlrpc.Call;
import de.timroes.axmlrpc.XMLRPCException;
import de.timroes.axmlrpc.XMLRPCServerException;
import de.timroes.axmlrpc.XMLUtil;
import de.timroes.axmlrpc.serializer.SerializerHandler;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.opensubtitles.TmmXmlRpcException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class TmmXmlRpcClient {
    private static final boolean DEBUG = false;
    private final Map<String, Object> callCache = new HashMap<String, Object>();
    private final URL url;
    private String userAgent;
    private final ResponseParser responseParser;
    private final SerializerHandler serializerHandler;

    public TmmXmlRpcClient(URL url) {
        this.url = url;
        this.serializerHandler = new SerializerHandler(2);
        this.responseParser = new ResponseParser();
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Object call(String method, Object ... params) throws TmmXmlRpcException {
        return new Caller().call(method, params);
    }

    private class ResponseParser {
        private static final String FAULT_CODE = "faultCode";
        private static final String FAULT_STRING = "faultString";
        private static final String METHOD_RESPONSE = "methodResponse";
        private static final String PARAMS = "params";
        private static final String PARAM = "param";
        private static final String FAULT = "fault";

        private ResponseParser() {
        }

        public Object parse(InputStream response) throws XMLRPCException {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document dom = builder.parse(response);
                Element e = dom.getDocumentElement();
                if (!e.getNodeName().equals(METHOD_RESPONSE)) {
                    throw new XMLRPCException("MethodResponse root tag is missing.");
                }
                if ((e = XMLUtil.getOnlyChildElement((NodeList)e.getChildNodes())).getNodeName().equals(PARAMS)) {
                    if (!(e = XMLUtil.getOnlyChildElement((NodeList)e.getChildNodes())).getNodeName().equals(PARAM)) {
                        throw new XMLRPCException("The params tag must contain a param tag.");
                    }
                    return this.getReturnValueFromElement(e);
                }
                if (e.getNodeName().equals(FAULT)) {
                    Map o = (Map)this.getReturnValueFromElement(e);
                    throw new XMLRPCServerException((String)o.get(FAULT_STRING), ((Integer)o.get(FAULT_CODE)).intValue());
                }
                throw new XMLRPCException("The methodResponse tag must contain a fault or params tag.");
            }
            catch (Exception ex) {
                if (ex instanceof XMLRPCServerException) {
                    throw (XMLRPCServerException)ex;
                }
                throw new XMLRPCException(ex.getMessage());
            }
        }

        private Object getReturnValueFromElement(Element element) throws XMLRPCException {
            element = XMLUtil.getOnlyChildElement((NodeList)element.getChildNodes());
            return TmmXmlRpcClient.this.serializerHandler.deserialize(element);
        }
    }

    private class Caller {
        private static final String HTTP_POST = "POST";
        private static final String USER_AGENT = "User-Agent";
        private final MediaType XML = MediaType.parse((String)"text/xml");

        public Object call(String methodName, Object[] params) throws TmmXmlRpcException {
            try {
                Call c = new Call(TmmXmlRpcClient.this.serializerHandler, methodName, params);
                String callXml = c.getXML(false);
                Object cachedResponse = TmmXmlRpcClient.this.callCache.get(callXml);
                if (cachedResponse != null) {
                    return cachedResponse;
                }
                RequestBody body = RequestBody.create((String)callXml, (MediaType)this.XML);
                Request request = new Request.Builder().url(TmmXmlRpcClient.this.url).header(USER_AGENT, TmmXmlRpcClient.this.userAgent).addHeader("Connection", "close").post(body).build();
                Response response = TmmHttpClient.getHttpClient().newCall(request).execute();
                int statusCode = response.code();
                if (statusCode != 200) {
                    throw new TmmXmlRpcException(statusCode, TmmXmlRpcClient.this.url.toString());
                }
                cachedResponse = TmmXmlRpcClient.this.responseParser.parse(response.body().byteStream());
                TmmXmlRpcClient.this.callCache.put(callXml, cachedResponse);
                return cachedResponse;
            }
            catch (Exception ex) {
                throw new TmmXmlRpcException(ex, TmmXmlRpcClient.this.url.toString());
            }
        }
    }
}

