/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper;

import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.http.InMemoryCachedUrl;
import org.tinymediamanager.scraper.http.Url;

public class SearchTitleWithGoogle {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchTitleWithGoogle.class);
    private static final String PAGE_ENCODING = "UTF-8";

    public List<MediaSearchResult> search(String site, MediaProviderInfo mpi, MediaSearchAndScrapeOptions options) {
        LOGGER.debug("SearchTitleWithGoogle() - {}", (Object)options);
        ArrayList<MediaSearchResult> resultList = new ArrayList<MediaSearchResult>();
        Object searchUrl = "";
        String searchTerm = "";
        try {
            if (StringUtils.isNotEmpty((CharSequence)options.getSearchQuery())) {
                if (!((String)site).startsWith("http")) {
                    site = "https://" + (String)site;
                }
            } else {
                LOGGER.debug("empty searchString");
                return resultList;
            }
            site = new URL((String)site).getHost();
            searchTerm = options.getSearchQuery();
            String lang = options.getLanguage().toLocale().getLanguage();
            searchUrl = "https://www.google." + lang + "/search?q=" + URLEncoder.encode("site:" + (String)site + " " + searchTerm, PAGE_ENCODING);
            LOGGER.debug("search for: {} ({})", (Object)searchTerm, searchUrl);
        }
        catch (Exception e) {
            LOGGER.debug("error searching {}", (Object)e.getMessage());
            return resultList;
        }
        Document doc = null;
        try {
            InMemoryCachedUrl url = new InMemoryCachedUrl((String)searchUrl);
            InputStream in = ((Url)url).getInputStream();
            doc = Jsoup.parse((InputStream)in, (String)PAGE_ENCODING, (String)"");
            in.close();
            if (doc == null) {
                return resultList;
            }
            Elements res = doc.getElementsByClass("r");
            for (Element el : res) {
                Element a = el.getElementsByTag("a").first();
                MediaSearchResult sr = new MediaSearchResult(mpi.getId(), options.getMediaType());
                String gurl = a.attr("href");
                if (gurl.contains("url?q=")) {
                    String[] params;
                    URL tmp = new URL("https://google.com/" + gurl);
                    for (String param : params = tmp.getQuery().split("[\\?&]")) {
                        String name = param.split("=")[0];
                        String value = param.split("=")[1];
                        if (!name.equals("q")) continue;
                        gurl = value;
                    }
                }
                sr.setUrl(URLDecoder.decode(gurl, PAGE_ENCODING));
                sr.setTitle(a.text().replaceAll((String)site, "(via Google)"));
                resultList.add(sr);
            }
        }
        catch (Exception e) {
            LOGGER.debug("failed to search for {} - {}", (Object)searchTerm, (Object)e.getMessage());
        }
        return resultList;
    }
}

