/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.addon;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.Globals;
import org.tinymediamanager.TmmOsUtils;

public interface IAddon {
    public String getAddonName();

    default public boolean isAvailable() {
        return StringUtils.isNotBlank((CharSequence)this.getExecutablePath());
    }

    public String getExecutableFilename();

    default public String getExecutablePath() {
        String[] pathDirs;
        String executableFilename = this.getExecutableFilename();
        Path executable = Paths.get(Globals.ADDON_FOLDER, new String[0]).toAbsolutePath().resolve(executableFilename);
        if (Files.isExecutable(executable)) {
            return executable.toString();
        }
        executable = Paths.get(TmmOsUtils.getNativeFolderName(), new String[0]).resolve("addons").toAbsolutePath().resolve(executableFilename);
        if (Files.isExecutable(executable)) {
            return executable.toString();
        }
        executable = Paths.get("addons", new String[0]).toAbsolutePath().resolve(executableFilename);
        if (Files.isExecutable(executable)) {
            return executable.toString();
        }
        String systemPath = System.getenv("PATH");
        for (String pathDir : pathDirs = systemPath.split(File.pathSeparator)) {
            try {
                executable = Paths.get(pathDir, executableFilename).toAbsolutePath();
                if (!Files.isExecutable(executable)) continue;
                return executable.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }
}

