/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beansbinding;

import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdesktop.beansbinding.ext.BeanAdapterFactory;
import org.jdesktop.el.BeanELResolver;
import org.jdesktop.el.CompositeELResolver;
import org.jdesktop.el.ELContext;
import org.jdesktop.el.ELResolver;
import org.jdesktop.el.FunctionMapper;
import org.jdesktop.el.MapELResolver;
import org.jdesktop.el.VariableMapper;
import org.jdesktop.el.impl.lang.FunctionMapperImpl;
import org.jdesktop.el.impl.lang.VariableMapperImpl;

class TempELContext
extends ELContext {
    private final CompositeELResolver resolver;
    private final VariableMapper variableMapper = new VariableMapperImpl();
    private final FunctionMapper functionMapper = new FunctionMapperImpl();

    public TempELContext() {
        this.resolver = new CompositeELResolver();
        this.resolver.add((ELResolver)new MapELResolver());
        this.resolver.add((ELResolver)new BeanDelegateELResolver());
    }

    public ELResolver getELResolver() {
        return this.resolver;
    }

    public FunctionMapper getFunctionMapper() {
        return this.functionMapper;
    }

    public VariableMapper getVariableMapper() {
        return this.variableMapper;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeanDelegateELResolver
    extends BeanELResolver {
        private BeanDelegateELResolver() {
        }

        public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
            List<PropertyDescriptor> pds;
            Iterator superDescriptors = super.getFeatureDescriptors(context, base);
            if (base != null && (pds = BeanAdapterFactory.getAdapterPropertyDescriptors(base.getClass())).size() > 0) {
                HashMap<String, FeatureDescriptor> fdMap = new HashMap<String, FeatureDescriptor>();
                while (superDescriptors.hasNext()) {
                    FeatureDescriptor fd = (FeatureDescriptor)superDescriptors.next();
                    fdMap.put(fd.getName(), fd);
                }
                for (PropertyDescriptor pd : pds) {
                    if (pd.getPropertyType() == null) continue;
                    pd.setValue("type", pd.getPropertyType());
                    pd.setValue("resolvableAtDesignTime", Boolean.TRUE);
                    fdMap.put(pd.getName(), pd);
                }
                return fdMap.values().iterator();
            }
            return superDescriptors;
        }

        private Object baseOrAdapter(Object base, Object property) {
            Object adapter;
            if (base != null && property instanceof String && (adapter = BeanAdapterFactory.getAdapter(base, (String)property)) != null) {
                return adapter;
            }
            return base;
        }

        public void setValue(ELContext context, Object base, Object property, Object val) {
            super.setValue(context, this.baseOrAdapter(base, property), property, val);
        }

        public boolean isReadOnly(ELContext context, Object base, Object property) {
            return super.isReadOnly(context, this.baseOrAdapter(base, property), property);
        }

        public Object getValue(ELContext context, Object base, Object property) {
            return super.getValue(context, this.baseOrAdapter(base, property), property);
        }

        public Class<?> getType(ELContext context, Object base, Object property) {
            return super.getType(context, this.baseOrAdapter(base, property), property);
        }
    }
}

