/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowCertificationFilter
extends AbstractCheckComboBoxTvShowUIFilter<MediaCertification> {
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();

    public TvShowCertificationFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallCertificationArray();
        PropertyChangeListener propertyChangeListener = evt -> this.buildAndInstallCertificationArray();
        this.tvShowList.addPropertyChangeListener("certification", propertyChangeListener);
    }

    @Override
    protected String parseTypeToString(MediaCertification type) throws Exception {
        return type.name();
    }

    @Override
    protected MediaCertification parseStringToType(String string) throws Exception {
        return MediaCertification.valueOf(string);
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        if (invert) {
            return !selectedItems.contains((Object)tvShow.getCertification());
        }
        return selectedItems.contains((Object)tvShow.getCertification());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.certification"));
    }

    @Override
    public String getId() {
        return "tvShowCertification";
    }

    private void buildAndInstallCertificationArray() {
        ArrayList<MediaCertification> certifications = new ArrayList<MediaCertification>(this.tvShowList.getCertification());
        Collections.sort(certifications);
        this.setValues(certifications);
    }
}

