/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.dialogs.TmmOptionDialog;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowRemoveAction
extends TmmAction {
    public TvShowRemoveAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.remove"));
        this.putValue("SmallIcon", IconManager.DELETE);
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.remove"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
    }

    @Override
    protected void processAction(ActionEvent e) {
        TvShowSelectionModel.SelectedObjects selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects(true, false);
        if (selectedObjects.isLockedFound()) {
            TvShowSelectionModel.showLockedInformation();
        }
        if (selectedObjects.isEmpty()) {
            return;
        }
        if (Boolean.FALSE.equals(TmmProperties.getInstance().getPropertyAsBoolean("tvshow.hideremovehint"))) {
            JCheckBox checkBox = new JCheckBox(TmmResourceBundle.getString("tmm.donotshowagain"));
            TmmFontHelper.changeFont((JComponent)checkBox, 0.91667);
            checkBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            int answer = TmmOptionDialog.showOptionDialog((Frame)MainWindow.getInstance(), TmmResourceBundle.getString("tvshow.remove"), TmmResourceBundle.getString("tvshow.remove.desc"), checkBox);
            if (checkBox.isSelected()) {
                TmmProperties.getInstance().putProperty("tvshow.hideremovehint", String.valueOf(checkBox.isSelected()));
            }
            if (answer != 0) {
                return;
            }
        }
        TmmTaskManager.getInstance().addUnnamedTask(() -> {
            for (TvShowEpisode episode : selectedObjects.getEpisodes()) {
                if (episode.isDummy()) {
                    episode.getTvShow().removeDummyEpisode(episode);
                    continue;
                }
                episode.getTvShow().removeEpisode(episode);
            }
            for (TvShowSeason season : selectedObjects.getSeasons()) {
                for (TvShowEpisode episode : season.getEpisodesForDisplay()) {
                    if (episode.isDummy()) {
                        season.getTvShow().removeDummyEpisode(episode);
                        continue;
                    }
                    season.getTvShow().removeEpisode(episode);
                }
            }
            for (TvShow tvShow : selectedObjects.getTvShows()) {
                TvShowModuleManager.getInstance().getTvShowList().removeTvShow(tvShow);
            }
        });
    }
}

