/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieChecksumAction
extends TmmAction {
    private static final long serialVersionUID = 1L;

    public MovieChecksumAction() {
        this.putValue("Name", TmmResourceBundle.getString("checksum.crc32.calculate"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("checksum.crc32.calculate"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies(true);
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TmmTask task = new TmmTask(TmmResourceBundle.getString("checksum.crc32.calculate"), selectedMovies.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                for (Movie movie : selectedMovies) {
                    MediaFile main = movie.getMainVideoFile();
                    String crc = Utils.getCRC32(main.getFileAsPath());
                    if (crc.isEmpty()) continue;
                    main.setCRC32(crc);
                    movie.saveToDb();
                }
            }
        };
        TmmTaskManager.getInstance().addUnnamedTask(task);
    }
}

