/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.textfield;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.IconManager;

public class EnhancedTextField
extends JTextField {
    protected JLabel lblIcon;

    public EnhancedTextField() {
        this(null, null);
    }

    public EnhancedTextField(String textWhenNotFocused) {
        this(textWhenNotFocused, null);
    }

    public EnhancedTextField(Icon icon) {
        this(null, icon);
    }

    public EnhancedTextField(String textWhenNotFocused, Icon icon) {
        if (icon != null) {
            this.setLayout(new BorderLayout());
            this.lblIcon = new JLabel(icon);
            this.add((Component)this.lblIcon, "East");
        }
        if (StringUtils.isNotBlank((CharSequence)textWhenNotFocused)) {
            this.putClientProperty("JTextField.placeholderText", textWhenNotFocused);
        }
    }

    public void setIconToolTipText(String tooltip) {
        if (this.lblIcon != null && StringUtils.isNotBlank((CharSequence)tooltip)) {
            this.lblIcon.setToolTipText(tooltip);
        }
    }

    public void addIconMouseListener(MouseListener mouseListener) {
        if (this.lblIcon != null && mouseListener != null) {
            this.lblIcon.setCursor(Cursor.getPredefinedCursor(12));
            this.lblIcon.addMouseListener(mouseListener);
        }
    }

    public static EnhancedTextField createSearchTextField() {
        final EnhancedTextField textField = new EnhancedTextField(TmmResourceBundle.getString("tmm.searchfield"), IconManager.SEARCH_GREY);
        textField.addIconMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (StringUtils.isNotBlank((CharSequence)textField.getText())) {
                    textField.setText("");
                }
            }
        });
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changeIcon();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changeIcon();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changeIcon();
            }

            private void changeIcon() {
                if (StringUtils.isBlank((CharSequence)textField.getText())) {
                    textField.lblIcon.setIcon(IconManager.SEARCH_GREY);
                } else {
                    textField.lblIcon.setIcon(IconManager.CLEAR_GREY);
                }
            }
        });
        return textField;
    }
}

