/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.tinymediamanager.library.bluray.playlist.MPLSObject;
import org.tinymediamanager.library.bluray.playlist.MPLSReader;
import org.tinymediamanager.library.bluray.playlist.MPLSWriter;

public class Main {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("Missing input and output arguments");
            Main.usage();
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        if (!string.toLowerCase().endsWith(".xml") && !string.toLowerCase().endsWith(".mpls") || !string2.toLowerCase().endsWith(".xml") && !string2.toLowerCase().endsWith(".mpls")) {
            System.out.println("Input and output can only have xml or mpls extension.");
            Main.usage();
        }
        if (!new File(string).exists()) {
            System.out.println("File " + string + " not found.");
            Main.usage();
        }
        MPLSObject mPLSObject = null;
        FileInputStream fileInputStream = new FileInputStream(string);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(fileInputStream));
        mPLSObject = string.toLowerCase().endsWith("xml") ? new MPLSReader().readXml(dataInputStream) : new MPLSReader().readBinary(dataInputStream);
        dataInputStream.close();
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
        if (string2.toLowerCase().endsWith("xml")) {
            new MPLSWriter().writeXml(mPLSObject, dataOutputStream);
        } else {
            new MPLSWriter().writeBinary(mPLSObject, dataOutputStream);
        }
        dataOutputStream.close();
    }

    public static void usage() {
        System.out.println("\n\nThis is a tool to convert a Movie PlayList file to xml format and back.\n\n");
        System.out.println("Usage:");
        System.out.println("\n" + Main.class.getName() + " Input Output \n");
        System.out.println("where Input can be one of");
        System.out.println("   location of XXXXX.mpls");
        System.out.println("   location of XXXXX.xml");
        System.out.println("and the Output can be one of");
        System.out.println("   XXXXX.mpls");
        System.out.println("   XXXXX.xml");
        System.exit(1);
    }
}

