/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.index;

import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.tinymediamanager.library.bluray.index.HexStringIntegerAdapter;
import org.tinymediamanager.library.bluray.index.IndexObject;

@XmlType(name="HDMVIndexObject")
public class HDMVIndexObject
extends IndexObject {
    HDMVPlaybackType type;
    int hdmvName;
    IndexObject.IndexObjectType objectType = IndexObject.IndexObjectType.V_01;

    public void setHDMVName(Integer n) {
        this.hdmvName = n;
    }

    @XmlJavaTypeAdapter(value=HexStringIntegerAdapter.class)
    public Integer getHDMVName() {
        return this.hdmvName;
    }

    public void setPlaybackType(HDMVPlaybackType hDMVPlaybackType) {
        this.type = hDMVPlaybackType;
    }

    public HDMVPlaybackType getPlaybackType() {
        return this.type;
    }

    @Override
    public IndexObject.IndexObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public void readObject(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        dataInputStream.skipBytes(1);
        int n = dataInputStream.readUnsignedShort();
        dataInputStream.skipBytes(4);
        int n2 = (by & 0xC0) >> 6;
        HDMVPlaybackType[] hDMVPlaybackTypeArray = HDMVPlaybackType.values();
        for (int i = 0; i < hDMVPlaybackTypeArray.length; ++i) {
            if (hDMVPlaybackTypeArray[i].ordinal() != n2) continue;
            this.setPlaybackType(hDMVPlaybackTypeArray[i]);
            break;
        }
        this.setHDMVName(n);
    }

    @Override
    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        int n = this.getPlaybackType().ordinal() << 6;
        byte[] byArray = new byte[4];
        dataOutputStream.writeByte(n);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeShort((short)this.getHDMVName().intValue());
        dataOutputStream.write(byArray);
    }

    public static enum HDMVPlaybackType {
        HDMVPlayback_MOVIE,
        HDMVPlayback_INTERACTIVE,
        HDMVPlayback_RESERVED,
        HDMVPlayback_RESERVED2;


        public byte getEncoding() {
            return (byte)this.ordinal();
        }
    }
}

