/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.id;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.helpers.DefaultValidationEventHandler;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.tinymediamanager.library.bluray.id.Id;

public class IdWriter {
    private static String iso646String(byte[] byArray) {
        try {
            return new String(byArray, "ISO646-US");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private static byte[] getISO646Bytes(String string) {
        try {
            return string.getBytes("ISO646-US");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public void writeXml(Id id, OutputStream outputStream) throws JAXBException, IOException {
        String string = Id.class.getName();
        String string2 = string.substring(0, string.lastIndexOf(46));
        JAXBContext jAXBContext = JAXBContext.newInstance((String)string2);
        Marshaller marshaller = jAXBContext.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        marshaller.marshal((Object)id, outputStream);
        outputStream.flush();
    }

    public void writeId(Id id, DataOutputStream dataOutputStream) throws IOException {
        int n;
        dataOutputStream.write(IdWriter.getISO646Bytes("BDID"));
        dataOutputStream.write(IdWriter.getISO646Bytes(id.getVersion()));
        for (n = 0; n < 32; ++n) {
            dataOutputStream.writeByte(0);
        }
        dataOutputStream.writeInt(id.getOrgId());
        dataOutputStream.write(id.getDiscId());
        for (n = 0; n < 44; ++n) {
            dataOutputStream.writeByte(0);
        }
        dataOutputStream.flush();
    }
}

