/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ItemModel;

public final class MediaModel {

    public static class BaseDetail
    extends ItemModel.BaseDetail {
        public static final String API_TYPE = "Media.Details.Base";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public final String fanart;
        public final String thumbnail;

        public BaseDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.fanart = BaseDetail.parseString(jsonNode, FANART);
            this.thumbnail = BaseDetail.parseString(jsonNode, THUMBNAIL);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(FANART, this.fanart);
            objectNode.put(THUMBNAIL, this.thumbnail);
            return objectNode;
        }

        static List<BaseDetail> getMediaModelBaseDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<BaseDetail> arrayList = new ArrayList<BaseDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new BaseDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<BaseDetail>(0);
        }
    }

    public static class ArtworkSet
    extends AbstractModel {
        public static final String API_TYPE = "Media.Artwork.Set";
        public static final String BANNER = "banner";
        public static final String FANART = "fanart";
        public static final String POSTER = "poster";
        public static final String THUMB = "thumb";
        public final String banner;
        public final String fanart;
        public final String poster;
        public final String thumb;

        public ArtworkSet(String string, String string2, String string3, String string4) {
            this.banner = string;
            this.fanart = string2;
            this.poster = string3;
            this.thumb = string4;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(BANNER, this.banner);
            objectNode.put(FANART, this.fanart);
            objectNode.put(POSTER, this.poster);
            objectNode.put(THUMB, this.thumb);
            return objectNode;
        }
    }

    public static class Artwork
    extends AbstractModel {
        public static final String API_TYPE = "Media.Artwork";
        public static final String BANNER = "banner";
        public static final String FANART = "fanart";
        public static final String POSTER = "poster";
        public static final String THUMB = "thumb";
        public final String banner;
        public final String fanart;
        public final String poster;
        public final String thumb;

        public Artwork(String string, String string2, String string3, String string4) {
            this.banner = string;
            this.fanart = string2;
            this.poster = string3;
            this.thumb = string4;
        }

        public Artwork(JsonNode jsonNode) {
            this.banner = Artwork.parseString(jsonNode, BANNER);
            this.fanart = Artwork.parseString(jsonNode, FANART);
            this.poster = Artwork.parseString(jsonNode, POSTER);
            this.thumb = Artwork.parseString(jsonNode, THUMB);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(BANNER, this.banner);
            objectNode.put(FANART, this.fanart);
            objectNode.put(POSTER, this.poster);
            objectNode.put(THUMB, this.thumb);
            return objectNode;
        }

        static List<Artwork> getMediaModelArtworkList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<Artwork> arrayList = new ArrayList<Artwork>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new Artwork(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<Artwork>(0);
        }
    }
}

