/*
 * Decompiled with CFR 0.152.
 */
package de.timroes.base64;

import java.util.HashMap;

public class Base64 {
    private static final char[] code = "=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final HashMap<Character, Byte> map = new HashMap();

    private Base64() {
    }

    public static byte[] decode(String in) {
        if ((in = in.replaceAll("\\r|\\n", "")).length() % 4 != 0) {
            throw new IllegalArgumentException("The length of the input string must be a multiple of four.");
        }
        if (!in.matches("^[A-Za-z0-9+/]*[=]{0,3}$")) {
            throw new IllegalArgumentException("The argument contains illegal characters.");
        }
        byte[] out = new byte[in.length() * 3 / 4];
        char[] input = in.toCharArray();
        int outi = 0;
        for (int i = 0; i < input.length; i += 4) {
            int b1 = map.get(Character.valueOf(input[i])) - 1;
            int b2 = map.get(Character.valueOf(input[i + 1])) - 1;
            int b3 = map.get(Character.valueOf(input[i + 2])) - 1;
            int b4 = map.get(Character.valueOf(input[i + 3])) - 1;
            out[outi++] = (byte)(b1 << 2 | b2 >>> 4);
            out[outi++] = (byte)((b2 & 0xF) << 4 | b3 >>> 2);
            out[outi++] = (byte)((b3 & 3) << 6 | b4 & 0x3F);
        }
        if (in.endsWith("=")) {
            byte[] trimmed = new byte[out.length - (in.length() - in.indexOf("="))];
            System.arraycopy(out, 0, trimmed, 0, trimmed.length);
            return trimmed;
        }
        return out;
    }

    public static String decodeAsString(String in) {
        return new String(Base64.decode(in));
    }

    public static String encode(String in) {
        return Base64.encode(in.getBytes());
    }

    public static String encode(Byte[] in) {
        byte[] tmp = new byte[in.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = in[i];
        }
        return Base64.encode(tmp);
    }

    public static String encode(byte[] in) {
        StringBuilder builder = new StringBuilder(4 * ((in.length + 2) / 3));
        byte[] encoded = Base64.encodeAsBytes(in);
        for (int i = 0; i < encoded.length; ++i) {
            builder.append(code[encoded[i] + 1]);
            if (i % 72 != 71) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    public static byte[] encodeAsBytes(String in) {
        return Base64.encodeAsBytes(in.getBytes());
    }

    public static byte[] encodeAsBytes(byte[] inArray) {
        int i;
        byte[] out = new byte[4 * ((inArray.length + 2) / 3)];
        byte[] in = new byte[(inArray.length + 2) / 3 * 3];
        System.arraycopy(inArray, 0, in, 0, inArray.length);
        int outi = 0;
        for (i = 0; i < in.length; i += 3) {
            out[outi++] = (byte)((in[i] & 0xFF) >>> 2);
            out[outi++] = (byte)((in[i] & 3) << 4 | (in[i + 1] & 0xFF) >>> 4);
            out[outi++] = (byte)((in[i + 1] & 0xF) << 2 | (in[i + 2] & 0xFF) >>> 6);
            out[outi++] = (byte)(in[i + 2] & 0x3F);
        }
        for (i = in.length - inArray.length; i > 0; --i) {
            out[out.length - i] = -1;
        }
        return out;
    }

    static {
        for (int i = 0; i < code.length; ++i) {
            map.put(Character.valueOf(code[i]), (byte)i);
        }
    }
}

