/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna.types;

import org.jupnp.model.types.InvalidValueException;
import org.jupnp.support.model.dlna.types.NormalPlayTime;

public class NormalPlayTimeRange {
    public static final String PREFIX = "npt=";
    private NormalPlayTime timeStart;
    private NormalPlayTime timeEnd;
    private NormalPlayTime timeDuration;

    public NormalPlayTimeRange(long timeStart, long timeEnd) {
        this.timeStart = new NormalPlayTime(timeStart);
        this.timeEnd = new NormalPlayTime(timeEnd);
    }

    public NormalPlayTimeRange(NormalPlayTime timeStart, NormalPlayTime timeEnd) {
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
    }

    public NormalPlayTimeRange(NormalPlayTime timeStart, NormalPlayTime timeEnd, NormalPlayTime timeDuration) {
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.timeDuration = timeDuration;
    }

    public NormalPlayTime getTimeStart() {
        return this.timeStart;
    }

    public NormalPlayTime getTimeEnd() {
        return this.timeEnd;
    }

    public NormalPlayTime getTimeDuration() {
        return this.timeDuration;
    }

    public String getString() {
        return this.getString(true);
    }

    public String getString(boolean includeDuration) {
        Object s = PREFIX;
        s = (String)s + this.timeStart.getString() + "-";
        if (this.timeEnd != null) {
            s = (String)s + this.timeEnd.getString();
        }
        if (includeDuration) {
            s = (String)s + "/" + (this.timeDuration != null ? this.timeDuration.getString() : "*");
        }
        return s;
    }

    public static NormalPlayTimeRange valueOf(String s) {
        return NormalPlayTimeRange.valueOf(s, false);
    }

    public static NormalPlayTimeRange valueOf(String s, boolean mandatoryTimeEnd) {
        if (s.startsWith(PREFIX)) {
            NormalPlayTime timeEnd = null;
            NormalPlayTime timeDuration = null;
            String[] params = s.substring(PREFIX.length()).split("[-/]");
            switch (params.length) {
                case 3: {
                    if (!params[2].isEmpty() && !params[2].equals("*")) {
                        timeDuration = NormalPlayTime.valueOf(params[2]);
                    }
                }
                case 2: {
                    if (!params[1].isEmpty()) {
                        timeEnd = NormalPlayTime.valueOf(params[1]);
                    }
                }
                case 1: {
                    if (params[0].isEmpty() || mandatoryTimeEnd && (!mandatoryTimeEnd || params.length <= 1)) break;
                    NormalPlayTime timeStart = NormalPlayTime.valueOf(params[0]);
                    return new NormalPlayTimeRange(timeStart, timeEnd, timeDuration);
                }
            }
        }
        throw new InvalidValueException("Can't parse NormalPlayTimeRange: " + s);
    }
}

